/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.StatementResult;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.api.param.QuerySettings;
import org.mule.db.commons.api.param.StatementDefinition;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.operation.DdlOperations;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class DdlOperationsTestCase {
    private DdlOperations ddlOperations;
    private QueryResolver<ParameterizedStatementDefinition> queryResolver;
    private ConfigurableStatementFactory statementFactory;
    private Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor;
    private AbstractDbConnector connector;
    private DbConnection connection;
    private StreamingHelper streamingHelper;

    @Before
    public void setUp() {
        this.queryResolver = (QueryResolver)Mockito.mock(QueryResolver.class);
        this.statementFactory = (ConfigurableStatementFactory)Mockito.mock(ConfigurableStatementFactory.class);
        this.updateExecutor = (Function)Mockito.mock(Function.class);
        this.connector = (AbstractDbConnector)Mockito.mock(AbstractDbConnector.class);
        this.connection = (DbConnection)Mockito.mock(DbConnection.class);
        this.streamingHelper = (StreamingHelper)Mockito.mock(StreamingHelper.class);
        this.ddlOperations = new DdlOperations.Builder().withQueryResolver(this.queryResolver).withStatementFactory(this.statementFactory).withUpdateExecutor(this.updateExecutor).build();
    }

    @Test
    public void testBuilderWithQueryResolver() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        DdlOperations result = builder.withQueryResolver(this.queryResolver).build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithStatementFactory() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        DdlOperations result = builder.withStatementFactory(this.statementFactory).build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithUpdateExecutor() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        DdlOperations result = builder.withUpdateExecutor(this.updateExecutor).build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithAllParameters() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        DdlOperations result = builder.withQueryResolver(this.queryResolver).withStatementFactory(this.statementFactory).withUpdateExecutor(this.updateExecutor).build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testBuilderWithNoParameters() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        DdlOperations result = builder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testExecuteDdl() throws SQLException {
        String sql = "CREATE TABLE test_table (id INT)";
        QuerySettings settings = new QuerySettings(5, TimeUnit.SECONDS, Integer.valueOf(10), Integer.valueOf(100));
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getType()).thenReturn((Object)QueryType.DDL);
        Mockito.when((Object)queryTemplate.getSqlText()).thenReturn((Object)sql);
        Query resolvedQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)resolvedQuery.getQueryTemplate()).thenReturn((Object)queryTemplate);
        Mockito.when((Object)this.queryResolver.resolve((StatementDefinition)Mockito.any(), (AbstractDbConnector)Mockito.eq((Object)this.connector), (DbConnection)Mockito.eq((Object)this.connection), (StreamingHelper)Mockito.eq((Object)this.streamingHelper))).thenReturn((Object)resolvedQuery);
        QueryExecutor executor = (QueryExecutor)Mockito.mock(QueryExecutor.class);
        Mockito.when((Object)this.updateExecutor.apply((ConfigurableStatementFactory)Mockito.any(ConfigurableStatementFactory.class))).thenReturn((Object)executor);
        StatementResult statementResult = (StatementResult)Mockito.mock(StatementResult.class);
        Mockito.when((Object)statementResult.getAffectedRows()).thenReturn((Object)0);
        Mockito.when((Object)executor.execute((DbConnection)Mockito.eq((Object)this.connection), (Query)Mockito.eq((Object)resolvedQuery), (AutoGenerateKeysStrategy)Mockito.any())).thenReturn((Object)statementResult);
        int result = this.ddlOperations.executeDdl(sql, settings, this.connector, this.connection, this.streamingHelper);
        Assert.assertEquals((long)0L, (long)result);
        ((QueryResolver)Mockito.verify(this.queryResolver)).resolve((StatementDefinition)Mockito.any(), (AbstractDbConnector)Mockito.eq((Object)this.connector), (DbConnection)Mockito.eq((Object)this.connection), (StreamingHelper)Mockito.eq((Object)this.streamingHelper));
        ((Function)Mockito.verify(this.updateExecutor)).apply(Mockito.any(ConfigurableStatementFactory.class));
        ((QueryExecutor)Mockito.verify((Object)executor)).execute((DbConnection)Mockito.eq((Object)this.connection), (Query)Mockito.eq((Object)resolvedQuery), (AutoGenerateKeysStrategy)Mockito.any());
    }

    @Test(expected=NullPointerException.class)
    public void testExecuteDdlWithNullSettings() throws SQLException {
        String sql = "DROP TABLE test_table";
        this.ddlOperations.executeDdl(sql, null, this.connector, this.connection, this.streamingHelper);
    }

    @Test
    public void testExecuteDdlWithEmptySql() throws SQLException {
        String sql = "";
        QuerySettings settings = new QuerySettings(1, TimeUnit.SECONDS, Integer.valueOf(5), Integer.valueOf(50));
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getType()).thenReturn((Object)QueryType.DDL);
        Mockito.when((Object)queryTemplate.getSqlText()).thenReturn((Object)sql);
        Query resolvedQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)resolvedQuery.getQueryTemplate()).thenReturn((Object)queryTemplate);
        Mockito.when((Object)this.queryResolver.resolve((StatementDefinition)Mockito.any(), (AbstractDbConnector)Mockito.eq((Object)this.connector), (DbConnection)Mockito.eq((Object)this.connection), (StreamingHelper)Mockito.eq((Object)this.streamingHelper))).thenReturn((Object)resolvedQuery);
        QueryExecutor executor = (QueryExecutor)Mockito.mock(QueryExecutor.class);
        Mockito.when((Object)this.updateExecutor.apply((ConfigurableStatementFactory)Mockito.any(ConfigurableStatementFactory.class))).thenReturn((Object)executor);
        StatementResult statementResult = (StatementResult)Mockito.mock(StatementResult.class);
        Mockito.when((Object)statementResult.getAffectedRows()).thenReturn((Object)0);
        Mockito.when((Object)executor.execute((DbConnection)Mockito.eq((Object)this.connection), (Query)Mockito.eq((Object)resolvedQuery), (AutoGenerateKeysStrategy)Mockito.any())).thenReturn((Object)statementResult);
        int result = this.ddlOperations.executeDdl(sql, settings, this.connector, this.connection, this.streamingHelper);
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testBuilderChaining() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        DdlOperations.Builder chainedBuilder = builder.withQueryResolver(this.queryResolver).withStatementFactory(this.statementFactory).withUpdateExecutor(this.updateExecutor);
        Assert.assertSame((Object)builder, (Object)chainedBuilder);
        DdlOperations result = chainedBuilder.build();
        Assert.assertNotNull((Object)result);
    }

    @Test(expected=NullPointerException.class)
    public void testBuilderWithNullParameters() {
        DdlOperations.Builder builder = new DdlOperations.Builder();
        builder.withQueryResolver(null);
    }

    @Test
    public void testExecuteDdlWithComplexSql() throws SQLException {
        String sql = "CREATE TABLE users (id INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255) NOT NULL, email VARCHAR(255) UNIQUE, created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
        QuerySettings settings = new QuerySettings(10, TimeUnit.SECONDS, Integer.valueOf(20), Integer.valueOf(200));
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getType()).thenReturn((Object)QueryType.DDL);
        Mockito.when((Object)queryTemplate.getSqlText()).thenReturn((Object)sql);
        Query resolvedQuery = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)resolvedQuery.getQueryTemplate()).thenReturn((Object)queryTemplate);
        Mockito.when((Object)this.queryResolver.resolve((StatementDefinition)Mockito.any(), (AbstractDbConnector)Mockito.eq((Object)this.connector), (DbConnection)Mockito.eq((Object)this.connection), (StreamingHelper)Mockito.eq((Object)this.streamingHelper))).thenReturn((Object)resolvedQuery);
        QueryExecutor executor = (QueryExecutor)Mockito.mock(QueryExecutor.class);
        Mockito.when((Object)this.updateExecutor.apply((ConfigurableStatementFactory)Mockito.any(ConfigurableStatementFactory.class))).thenReturn((Object)executor);
        StatementResult statementResult = (StatementResult)Mockito.mock(StatementResult.class);
        Mockito.when((Object)statementResult.getAffectedRows()).thenReturn((Object)0);
        Mockito.when((Object)executor.execute((DbConnection)Mockito.eq((Object)this.connection), (Query)Mockito.eq((Object)resolvedQuery), (AutoGenerateKeysStrategy)Mockito.any())).thenReturn((Object)statementResult);
        int result = this.ddlOperations.executeDdl(sql, settings, this.connector, this.connection, this.streamingHelper);
        Assert.assertEquals((long)0L, (long)result);
    }
}

