/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.InsertStatementTypeDetector;

public class InsertStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        InsertStatementTypeDetector detector = new InsertStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.INSERT));
    }

    @Test
    public void validInsertStatementTest() {
        InsertStatementTypeDetector detector = new InsertStatementTypeDetector();
        List<String> insertStatements = Arrays.asList("INSERT INTO MYTABLE;", "insert into mytable", " insert into mytable", "Insert into myschema.myTable", "insert into myawesometable select * from othertable");
        for (String statement : insertStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidInsertStatementTest() {
        InsertStatementTypeDetector detector = new InsertStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("SELECT DELETE FROM MY TABLE;", "SELECT FROM MYTABLE", "UPDATE delete from table");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

