/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.StatementTypeDetector;
import org.mule.db.commons.internal.parser.statement.detector.UnknownStatementTypeException;

@RunWith(value=MockitoJUnitRunner.class)
public class StatementTypeDetectorTestCase {
    private StatementTypeDetector detector;

    @Before
    public void setUp() {
        this.detector = new StatementTypeDetector();
    }

    @Test
    public void testDetectSelectStatements() throws UnknownStatementTypeException {
        List<String> selectStatements = Arrays.asList("SELECT name, surname FROM employees WHERE last_name LIKE 'ZDA%'", "SELECT * FROM COUNTRY", "SELECT * FROM MYTABLE", "select * from users", "Select name, surname from employees where last_name like 'ZDA%'", "SELECT u.name, t.data FROM temp t JOIN users u ON t.id = u.id", "SELECT * FROM users WHERE id IN (SELECT user_id FROM orders)", "SELECT CASE WHEN id = 1 THEN 'one' ELSE 'other' END FROM users");
        for (String statement : selectStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        }
    }

    @Test
    public void testDetectInsertStatements() throws UnknownStatementTypeException {
        List<String> insertStatements = Arrays.asList("INSERT INTO users (name, email) VALUES ('John', 'john@example.com')", "INSERT INTO employees VALUES (1, 'John', 'Doe')", "insert into users (id, name) values (1, 'test')", "Insert Into users (name) Values ('John')");
        for (String statement : insertStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.INSERT));
        }
    }

    @Test
    public void testDetectUpdateStatements() throws UnknownStatementTypeException {
        List<String> updateStatements = Arrays.asList("UPDATE users SET name = 'John' WHERE id = 1", "UPDATE employees SET salary = 50000 WHERE department = 'IT'", "update users set email = 'new@example.com' where id = 1", "Update users Set name = 'John' Where id = 1");
        for (String statement : updateStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.UPDATE));
        }
    }

    @Test
    public void testDetectDeleteStatements() throws UnknownStatementTypeException {
        List<String> deleteStatements = Arrays.asList("DELETE FROM users WHERE id = 1", "DELETE FROM employees WHERE department = 'HR'", "delete from users where id = 1", "Delete From users Where id = 1");
        for (String statement : deleteStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.DELETE));
        }
    }

    @Test
    public void testDetectStoredProcedureStatements() throws UnknownStatementTypeException {
        List<String> storedProcedureStatements = Arrays.asList("CALL get_user(1)", "call update_user(1, 'John')", "CALL complex_procedure(:param1, :param2)");
        for (String statement : storedProcedureStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.STORE_PROCEDURE_CALL));
        }
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testDetectUnsupportedStoredProcedureStatements() throws UnknownStatementTypeException {
        List<String> unsupportedStoredProcedureStatements = Arrays.asList("EXECUTE complex_procedure(:param1, :param2)", "EXEC get_user_data", "Execute complex_procedure(:param1, :param2)", "Exec get_user_data");
        for (String statement : unsupportedStoredProcedureStatements) {
            this.detector.detect(statement);
        }
    }

    @Test
    public void testDetectTruncateStatements() throws UnknownStatementTypeException {
        List<String> truncateStatements = Arrays.asList("TRUNCATE TABLE users", "TRUNCATE TABLE employees", "truncate table users", "Truncate Table users");
        for (String statement : truncateStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.TRUNCATE));
        }
    }

    @Test
    public void testDetectMergeStatements() throws UnknownStatementTypeException {
        List<String> mergeStatements = Arrays.asList("MERGE INTO users USING (SELECT 1 as id, 'John' as name) AS source ON users.id = source.id", "MERGE INTO employees USING temp_employees ON employees.id = temp_employees.id", "merge into users using (select 1 as id) as source on users.id = source.id", "Merge Into users Using (select 1 as id) As source On users.id = source.id");
        for (String statement : mergeStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.MERGE));
        }
    }

    @Test
    public void testDetectWithStatements() throws UnknownStatementTypeException {
        List<String> withStatements = Arrays.asList("WITH temp AS (SELECT * FROM users) SELECT * FROM temp", "WITH temp_table AS (SELECT id, name FROM users) SELECT * FROM temp_table", "with temp as (select * from users) select * from temp", "With temp As (select * from users) Select * from temp");
        for (String statement : withStatements) {
            MatcherAssert.assertThat((Object)this.detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        }
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testInvalidStatement() throws UnknownStatementTypeException {
        this.detector.detect("THISISANINVALIDSTATEMENT");
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testEmptyStatement() throws UnknownStatementTypeException {
        this.detector.detect("");
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testWhitespaceOnlyStatement() throws UnknownStatementTypeException {
        this.detector.detect("   ");
    }

    @Test(expected=NullPointerException.class)
    public void testNullStatement() throws UnknownStatementTypeException {
        this.detector.detect(null);
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testPartialStatement() throws UnknownStatementTypeException {
        this.detector.detect("SELECT");
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testInvalidSQLSyntax() throws UnknownStatementTypeException {
        this.detector.detect("INVALID SQL SYNTAX STATEMENT");
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testDDLStatement() throws UnknownStatementTypeException {
        this.detector.detect("CREATE TABLE users (id INT, name VARCHAR(100))");
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testAlterStatement() throws UnknownStatementTypeException {
        this.detector.detect("ALTER TABLE users ADD COLUMN email VARCHAR(100)");
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void testDropStatement() throws UnknownStatementTypeException {
        this.detector.detect("DROP TABLE users");
    }

    @Test
    public void testCaseInsensitiveDetection() throws UnknownStatementTypeException {
        MatcherAssert.assertThat((Object)this.detector.detect("select * from users"), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)this.detector.detect("SELECT * FROM users"), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)this.detector.detect("Select * From users"), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)this.detector.detect("SeLeCt * FrOm UsErS"), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
    }

    @Test
    public void testWhitespaceHandling() throws UnknownStatementTypeException {
        MatcherAssert.assertThat((Object)this.detector.detect("  SELECT  *  FROM  users  "), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)this.detector.detect("SELECT\t*\tFROM\tusers"), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)this.detector.detect("SELECT\n*\nFROM\nusers"), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
    }

    @Test
    public void testComplexQueries() throws UnknownStatementTypeException {
        String complexSelect = "SELECT u.name, e.salary FROM users u JOIN employees e ON u.id = e.user_id WHERE e.department = 'IT' AND e.salary > 50000 ORDER BY e.salary DESC";
        MatcherAssert.assertThat((Object)this.detector.detect(complexSelect), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        String complexInsert = "INSERT INTO users (id, name, email, created_at) VALUES (1, 'John Doe', 'john@example.com', CURRENT_TIMESTAMP)";
        MatcherAssert.assertThat((Object)this.detector.detect(complexInsert), (Matcher)CoreMatchers.equalTo((Object)QueryType.INSERT));
    }

    @Test
    public void testQueriesWithComments() throws UnknownStatementTypeException {
        String selectWithComment = "SELECT * FROM users -- This is a comment";
        MatcherAssert.assertThat((Object)this.detector.detect(selectWithComment), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        String insertWithComment = "INSERT INTO users (name) VALUES ('John') -- Insert user";
        MatcherAssert.assertThat((Object)this.detector.detect(insertWithComment), (Matcher)CoreMatchers.equalTo((Object)QueryType.INSERT));
    }

    @Test
    public void testQueriesWithStringLiterals() throws UnknownStatementTypeException {
        String selectWithString = "SELECT * FROM users WHERE name = 'John's data'";
        MatcherAssert.assertThat((Object)this.detector.detect(selectWithString), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        String insertWithString = "INSERT INTO users (name) VALUES ('John''s data')";
        MatcherAssert.assertThat((Object)this.detector.detect(insertWithString), (Matcher)CoreMatchers.equalTo((Object)QueryType.INSERT));
    }

    @Test
    public void testQueriesWithParameters() throws UnknownStatementTypeException {
        String selectWithParams = "SELECT * FROM users WHERE id = :id AND name = :name";
        MatcherAssert.assertThat((Object)this.detector.detect(selectWithParams), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        String insertWithParams = "INSERT INTO users (name, email) VALUES (:name, :email)";
        MatcherAssert.assertThat((Object)this.detector.detect(insertWithParams), (Matcher)CoreMatchers.equalTo((Object)QueryType.INSERT));
    }

    @Test
    public void testMultipleDetectors() throws UnknownStatementTypeException {
        StatementTypeDetector detector1 = new StatementTypeDetector();
        StatementTypeDetector detector2 = new StatementTypeDetector();
        String sql = "SELECT * FROM users";
        MatcherAssert.assertThat((Object)detector1.detect(sql), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        MatcherAssert.assertThat((Object)detector2.detect(sql), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
    }

    @Test
    public void testExceptionMessage() {
        try {
            this.detector.detect("INVALID STATEMENT");
            Assert.fail((String)"Should have thrown UnknownStatementTypeException");
        }
        catch (UnknownStatementTypeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot detect the statement type for query"));
            Assert.assertTrue((boolean)e.getMessage().contains("INVALID STATEMENT"));
        }
    }
}

