/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.exception.connection.DbError;
import org.mule.db.commons.api.param.QueryDefinition;
import org.mule.db.commons.api.param.StatementDefinition;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryParamValue;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.DynamicDbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.resolver.query.AbstractQueryResolver;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractQueryResolverTestCase {
    @Mock
    private AbstractDbConnector mockConnector;
    @Mock
    private DbConnection mockConnection;
    @Mock
    private StreamingHelper mockStreamingHelper;
    @Mock
    private DbTypeManager mockTypeManager;
    @Mock
    private DbType mockDbType;
    @Mock
    private Connection mockJdbcConnection;
    @Mock
    private PreparedStatement mockPreparedStatement;
    @Mock
    private ParameterMetaData mockParameterMetaData;
    private TestAbstractQueryResolver resolver;

    @Before
    public void setUp() throws Exception {
        this.resolver = new TestAbstractQueryResolver();
        Mockito.when((Object)this.mockConnector.getTypeManager()).thenReturn((Object)this.mockTypeManager);
        Mockito.when((Object)this.mockConnection.getVendorDataTypes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockConnection.getCustomDataTypes()).thenReturn(Collections.emptyList());
        Cache mockCache = Caffeine.newBuilder().maximumSize(10L).build();
        Mockito.when((Object)this.mockConnection.getCacheTemplates()).thenReturn((Object)mockCache);
        Mockito.when((Object)this.mockConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        Mockito.lenient().when((Object)this.mockParameterMetaData.getParameterType(ArgumentMatchers.anyInt())).thenReturn((Object)12);
        Mockito.lenient().when((Object)this.mockParameterMetaData.getParameterTypeName(ArgumentMatchers.anyInt())).thenReturn((Object)"VARCHAR");
    }

    @Test
    public void testResolveWithValidStatement() throws SQLException {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        statementDef.addInputParameter("id", (Object)1);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)4);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"INTEGER");
        ResolvedDbType resolvedType = new ResolvedDbType(4, "INTEGER");
        Mockito.lenient().when((Object)this.mockTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.eq((int)4), (String)ArgumentMatchers.eq((Object)"INTEGER"))).thenReturn((Object)resolvedType);
        Query result = this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getQueryTemplate());
        Assert.assertEquals((Object)"SELECT * FROM test WHERE id = ?", (Object)result.getQueryTemplate().getSqlText());
        Assert.assertFalse((boolean)result.getParamValues().isEmpty());
    }

    @Test
    public void testResolveWithEmptySql() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("");
        MuleRuntimeException exception = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertTrue((boolean)exception.getMessage().contains("Could not resolve query: "));
    }

    @Test
    public void testResolveWithBlankSql() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("   ");
        MuleRuntimeException exception = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertTrue((boolean)exception.getMessage().contains("Could not resolve query: "));
    }

    @Test
    public void testResolveWithNullSql() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql(null);
        MuleRuntimeException exception = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertTrue((boolean)exception.getMessage().contains("Could not resolve query: "));
    }

    @Test
    public void testCreateQueryTemplateWithSimpleQuery() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test");
        QueryTemplate result = this.resolver.createQueryTemplate(statementDef, this.mockConnector, this.mockConnection);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM test", (Object)result.getSqlText());
        Assert.assertTrue((boolean)result.getParams().isEmpty());
    }

    @Test
    public void testCreateQueryTemplateWithParameterizedQuery() throws SQLException {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id AND name = :name");
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)4);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(2)).thenReturn((Object)12);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"INTEGER");
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(2)).thenReturn((Object)"VARCHAR");
        ResolvedDbType integerType = new ResolvedDbType(4, "INTEGER");
        ResolvedDbType varcharType = new ResolvedDbType(12, "VARCHAR");
        Mockito.lenient().when((Object)this.mockTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.eq((int)4), (String)ArgumentMatchers.eq((Object)"INTEGER"))).thenReturn((Object)integerType);
        Mockito.lenient().when((Object)this.mockTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.eq((int)12), (String)ArgumentMatchers.eq((Object)"VARCHAR"))).thenReturn((Object)varcharType);
        QueryTemplate result = this.resolver.createQueryTemplate(statementDef, this.mockConnector, this.mockConnection);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM test WHERE id = ? AND name = ?", (Object)result.getSqlText());
        Assert.assertEquals((long)2L, (long)result.getParams().size());
    }

    @Test
    public void testCreateQueryTemplateWithUnknownDbType() throws SQLException {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)12);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"VARCHAR");
        Mockito.lenient().when((Object)this.mockTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.eq((int)12), (String)ArgumentMatchers.eq((Object)"VARCHAR"))).thenReturn((Object)UnknownDbType.getInstance());
        QueryTemplate result = this.resolver.createQueryTemplate(statementDef, this.mockConnector, this.mockConnection);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getParams().size());
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)((QueryParam)result.getParams().get(0)).getType());
    }

    @Test
    public void testCreateQueryTemplateWithDynamicDbType() throws SQLException {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)12);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"VARCHAR");
        DynamicDbType dynamicType = new DynamicDbType("DYNAMIC_TYPE");
        Mockito.lenient().when((Object)this.mockTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.eq((int)12), (String)ArgumentMatchers.eq((Object)"VARCHAR"))).thenReturn((Object)dynamicType);
        QueryTemplate result = this.resolver.createQueryTemplate(statementDef, this.mockConnector, this.mockConnection);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getParams().size());
        Assert.assertEquals((Object)dynamicType, (Object)((QueryParam)result.getParams().get(0)).getType());
    }

    @Test
    public void testCreateTypeManagerWithVendorAndCustomTypes() {
        ArrayList<DbType> vendorTypes = new ArrayList<DbType>();
        vendorTypes.add(this.mockDbType);
        ArrayList<DbType> customTypes = new ArrayList<DbType>();
        customTypes.add(this.mockDbType);
        Mockito.when((Object)this.mockConnection.getVendorDataTypes()).thenReturn(vendorTypes);
        Mockito.when((Object)this.mockConnection.getCustomDataTypes()).thenReturn(customTypes);
        DbTypeManager result = this.resolver.createTypeManager(this.mockConnector, this.mockConnection);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testCreateTypeManagerWithEmptyTypes() {
        Mockito.when((Object)this.mockConnection.getVendorDataTypes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.mockConnection.getCustomDataTypes()).thenReturn(Collections.emptyList());
        DbTypeManager result = this.resolver.createTypeManager(this.mockConnector, this.mockConnection);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testResolveWithSQLException() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        SQLException sqlException = new SQLException("Test SQL Exception");
        Mockito.when((Object)this.mockTypeManager.lookup((DbConnection)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new RuntimeException(sqlException)});
        MuleRuntimeException exception = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertTrue((boolean)exception.getMessage().contains("Could not resolve query: SELECT * FROM test WHERE id = :id"));
    }

    @Test
    public void testResolveWithModuleException() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        Mockito.when((Object)this.mockConnection.getCacheTemplates()).thenThrow(new Throwable[]{new ModuleException("Test Module Exception", (ErrorTypeDefinition)DbError.QUERY_EXECUTION)});
        ModuleException exception = (ModuleException)Assert.assertThrows(ModuleException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertEquals((Object)"Test Module Exception", (Object)exception.getMessage());
    }

    @Test
    public void testResolveWithMuleRuntimeException() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        Mockito.when((Object)this.mockConnection.getCacheTemplates()).thenThrow(new Throwable[]{new RuntimeException("Test Runtime Exception")});
        MuleRuntimeException exception = (MuleRuntimeException)Assert.assertThrows(MuleRuntimeException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertTrue((boolean)exception.getMessage().contains("Could not resolve query: SELECT * FROM test WHERE id = :id"));
    }

    @Test
    public void testResolveWithModuleExceptionAsCause() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        RuntimeException runtimeException = new RuntimeException("Test Runtime Exception");
        runtimeException.initCause((Throwable)new ModuleException("Test Module Exception", (ErrorTypeDefinition)DbError.QUERY_EXECUTION));
        Mockito.when((Object)this.mockConnection.getCacheTemplates()).thenThrow(new Throwable[]{runtimeException});
        ModuleException exception = (ModuleException)Assert.assertThrows(ModuleException.class, () -> this.resolver.resolve((StatementDefinition)statementDef, this.mockConnector, this.mockConnection, this.mockStreamingHelper));
        Assert.assertEquals((Object)"Test Module Exception", (Object)exception.getMessage());
    }

    @Test
    public void testResolveParamsAbstractMethod() {
        QueryDefinition statementDef = new QueryDefinition();
        statementDef.setSql("SELECT * FROM test WHERE id = :id");
        statementDef.addInputParameter("id", (Object)1);
        QueryTemplate template = new QueryTemplate("SELECT * FROM test WHERE id = ?", QueryType.SELECT, Collections.emptyList());
        List<QueryParamValue> result = this.resolver.resolveParams(statementDef, template, this.mockStreamingHelper);
        Assert.assertNotNull(result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"id", (Object)result.get(0).getName());
        Assert.assertEquals((Object)1, (Object)result.get(0).getValue());
    }

    private static class TestAbstractQueryResolver
    extends AbstractQueryResolver<QueryDefinition> {
        private TestAbstractQueryResolver() {
        }

        protected List<QueryParamValue> resolveParams(QueryDefinition statementDefinition, QueryTemplate template, StreamingHelper streamingHelper) {
            ArrayList<QueryParamValue> params = new ArrayList<QueryParamValue>();
            for (String paramName : statementDefinition.getInputParameters().keySet()) {
                Object value = statementDefinition.getInputParameters().get(paramName);
                params.add(new QueryParamValue(paramName, value));
            }
            return params;
        }

        public QueryTemplate createQueryTemplate(QueryDefinition statementDefinition, AbstractDbConnector connector, DbConnection connection) {
            return super.createQueryTemplate((StatementDefinition)statementDefinition, connector, connection);
        }

        public DbTypeManager createTypeManager(AbstractDbConnector connector, DbConnection connection) {
            return super.createTypeManager(connector, connection);
        }
    }
}

