/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.parser.QueryTemplateParser;
import org.mule.db.commons.internal.resolver.query.BulkQueryFactory;
import org.mule.db.commons.internal.resolver.query.FileBulkQueryFactory;
import org.mule.db.commons.internal.resolver.query.QueryResolutionException;
import org.mule.db.commons.internal.util.FileReader;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class FileBulkQueryFactoryTestCase
extends AbstractMuleTestCase {
    private FileBulkQueryFactory factory;
    private QueryTemplateParser mockParser;
    private FileReader mockFileReader;
    private String testFile = "test-queries.sql";

    @Before
    public void setUp() {
        this.mockParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        this.mockFileReader = (FileReader)Mockito.mock(FileReader.class);
        this.factory = new FileBulkQueryFactory(this.testFile, this.mockParser, this.mockFileReader);
    }

    @Test
    public void testConstructorWithValidParameters() {
        MatcherAssert.assertThat((Object)this.factory, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)this.factory.toString(), (Matcher)CoreMatchers.is((Object)this.testFile));
    }

    @Test
    public void testResolveBulkQueriesSuccess() throws IOException {
        String expectedContent = "SELECT * FROM users; INSERT INTO logs VALUES (1);";
        Mockito.when((Object)this.mockFileReader.getResourceAsString(this.testFile)).thenReturn((Object)expectedContent);
        String result = this.factory.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)expectedContent));
    }

    @Test
    public void testResolveBulkQueriesWithEmptyFile() throws IOException {
        String expectedContent = "";
        Mockito.when((Object)this.mockFileReader.getResourceAsString(this.testFile)).thenReturn((Object)expectedContent);
        String result = this.factory.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)expectedContent));
    }

    @Test
    public void testResolveBulkQueriesWithNullFile() throws IOException {
        Object expectedContent = null;
        Mockito.when((Object)this.mockFileReader.getResourceAsString(this.testFile)).thenReturn(expectedContent);
        String result = this.factory.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)null));
    }

    @Test(expected=QueryResolutionException.class)
    public void testResolveBulkQueriesWithIOException() throws IOException {
        Mockito.when((Object)this.mockFileReader.getResourceAsString(this.testFile)).thenThrow(new Throwable[]{new IOException("File not found")});
        this.factory.resolveBulkQueries();
    }

    @Test
    public void testToStringReturnsFileName() {
        String result = this.factory.toString();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.testFile));
    }

    @Test
    public void testClassExtendsBulkQueryFactory() {
        MatcherAssert.assertThat((Object)(this.factory instanceof BulkQueryFactory), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.factory.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.resolver.query"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.factory.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"FileBulkQueryFactory"));
    }

    @Test
    public void testConstructorWithNullFile() {
        FileBulkQueryFactory factoryWithNullFile = new FileBulkQueryFactory(null, this.mockParser, this.mockFileReader);
        MatcherAssert.assertThat((Object)factoryWithNullFile, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)factoryWithNullFile.toString(), (Matcher)CoreMatchers.is((Object)null));
    }

    @Test
    public void testConstructorWithEmptyFile() {
        FileBulkQueryFactory factoryWithEmptyFile = new FileBulkQueryFactory("", this.mockParser, this.mockFileReader);
        MatcherAssert.assertThat((Object)factoryWithEmptyFile, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)factoryWithEmptyFile.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testResolveBulkQueriesWithLargeContent() throws IOException {
        String largeContent = "SELECT * FROM large_table WHERE id > 1000; UPDATE large_table SET status = 'processed' WHERE id > 1000; INSERT INTO audit_log (table_name, action, timestamp) VALUES ('large_table', 'bulk_update', NOW());";
        Mockito.when((Object)this.mockFileReader.getResourceAsString(this.testFile)).thenReturn((Object)largeContent);
        String result = this.factory.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)largeContent));
    }

    @Test
    public void testResolveBulkQueriesWithSpecialCharacters() throws IOException {
        String contentWithSpecialChars = "SELECT * FROM users WHERE name LIKE '%test%'; INSERT INTO logs (message) VALUES ('Test with \"quotes\" and 'apostrophes'');";
        Mockito.when((Object)this.mockFileReader.getResourceAsString(this.testFile)).thenReturn((Object)contentWithSpecialChars);
        String result = this.factory.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)contentWithSpecialChars));
    }
}

