/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.runtime.extension.api.exception.ModuleException;

@RunWith(value=MockitoJUnitRunner.class)
public class ResultSetIteratorTest {
    @Mock
    private ResultSet mockResultSet;
    @Mock
    private RowHandler mockRowHandler;
    private ResultSetIterator iterator;

    @Before
    public void setUp() {
        this.iterator = new ResultSetIterator(this.mockResultSet, this.mockRowHandler);
    }

    @Test
    public void testHasNextWithCachedException() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenThrow(new Throwable[]{new SQLException("Database error")});
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertTrue((boolean)this.iterator.hasNext());
        try {
            this.iterator.next();
            Assert.fail((String)"Should have thrown SQLException");
        }
        catch (ModuleException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof SQLException));
            Assert.assertEquals((Object)"Database error", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testHasNextWithNoMoreResults() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.iterator.hasNext());
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void testHasNextWithMoreResults() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertTrue((boolean)this.iterator.hasNext());
    }

    @Test
    public void testNextWithCachedNextTrue() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true);
        HashMap<String, Object> expectedRow = new HashMap<String, Object>();
        expectedRow.put("id", 1);
        expectedRow.put("name", "test");
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenReturn(expectedRow);
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Map result = this.iterator.next();
        Assert.assertEquals(expectedRow, (Object)result);
        ((ResultSet)Mockito.verify((Object)this.mockResultSet, (VerificationMode)Mockito.times((int)1))).next();
    }

    @Test
    public void testNextWithCachedNextFalse() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.iterator.hasNext());
        try {
            this.iterator.next();
            Assert.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((Object)"Attempted to get more results after the end of the set was signaled", (Object)e.getMessage());
        }
    }

    @Test
    public void testNextWithoutCachedResult() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true);
        HashMap<String, Integer> expectedRow = new HashMap<String, Integer>();
        expectedRow.put("id", 1);
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenReturn(expectedRow);
        Map result = this.iterator.next();
        Assert.assertEquals(expectedRow, (Object)result);
    }

    @Test
    public void testNextWithNoMoreResults() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)false);
        try {
            this.iterator.next();
            Assert.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((Object)"Attempted to get more results but there are none", (Object)e.getMessage());
        }
    }

    @Test
    public void testNextWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenThrow(new Throwable[]{new SQLException("Processing error")});
        try {
            this.iterator.next();
            Assert.fail((String)"Should have thrown ModuleException");
        }
        catch (ModuleException e) {
            Assert.assertEquals((Object)"Unable to obtain next row", (Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof SQLException));
            Assert.assertEquals((Object)"Processing error", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testRemove() {
        try {
            this.iterator.remove();
            Assert.fail((String)"Should have thrown UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleNextCalls() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        HashMap<String, Integer> row1 = new HashMap<String, Integer>();
        row1.put("id", 1);
        HashMap<String, Integer> row2 = new HashMap<String, Integer>();
        row2.put("id", 2);
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenReturn(row1, (Object[])new Map[]{row2});
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals(row1, (Object)this.iterator.next());
        Assert.assertTrue((boolean)this.iterator.hasNext());
        Assert.assertEquals(row2, (Object)this.iterator.next());
        Assert.assertFalse((boolean)this.iterator.hasNext());
    }

    @Test
    public void testIteratorWithEmptyResultSet() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.iterator.hasNext());
        try {
            this.iterator.next();
            Assert.fail((String)"Should have thrown NoSuchElementException");
        }
        catch (NoSuchElementException e) {
            Assert.assertEquals((Object)"Attempted to get more results after the end of the set was signaled", (Object)e.getMessage());
        }
    }
}

