/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.result.resultset.ResultSetProcessingException;

public class ResultSetProcessingExceptionTestCase {
    @Test
    public void testConstructorWithMessageAndCause() {
        String message = "Test error message";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithNullMessage() {
        String message = null;
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertNull((Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithNullCause() {
        String message = "Test error message";
        Throwable cause = null;
        ResultSetProcessingException exception = new ResultSetProcessingException(message, cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertNull((Object)exception.getCause());
    }

    @Test
    public void testConstructorWithBothNull() {
        String message = null;
        Throwable cause = null;
        ResultSetProcessingException exception = new ResultSetProcessingException(message, cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertNull((Object)exception.getMessage());
        Assert.assertNull((Object)exception.getCause());
    }

    @Test
    public void testConstructorWithEmptyMessage() {
        String message = "";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithWhitespaceMessage() {
        String message = "   ";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithLongMessage() {
        String message = "This is a very long error message that contains multiple words and should be handled properly by the exception constructor";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithSpecialCharactersInMessage() {
        String message = "Error with special chars: !@#$%^&*()_+-=[]{}|;':\",./<>?";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithUnicodeCharactersInMessage() {
        String message = "Error with unicode: \u00f1\u00e1\u00e9\u00ed\u00f3\u00fa\u00fc\u00e7";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithSQLExceptionAsCause() {
        String message = "Database error occurred";
        SQLException sqlException = new SQLException("SQL error");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)sqlException);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)sqlException, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithNullPointerExceptionAsCause() {
        String message = "Null pointer error";
        NullPointerException nullPointerException = new NullPointerException("Object is null");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)nullPointerException);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)nullPointerException, (Object)exception.getCause());
    }

    @Test
    public void testConstructorWithIllegalArgumentExceptionAsCause() {
        String message = "Invalid argument error";
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid parameter");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)illegalArgumentException);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertEquals((Object)illegalArgumentException, (Object)exception.getCause());
    }

    @Test
    public void testExceptionInheritance() {
        String message = "Test error message";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertTrue((boolean)(exception instanceof RuntimeException));
        Assert.assertTrue((boolean)(exception instanceof Exception));
        Assert.assertTrue((boolean)(exception instanceof Throwable));
    }

    @Test
    public void testExceptionPackage() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.result.resultset", (Object)ResultSetProcessingException.class.getPackage().getName());
    }

    @Test
    public void testExceptionClassName() {
        Assert.assertEquals((Object)"ResultSetProcessingException", (Object)ResultSetProcessingException.class.getSimpleName());
    }

    @Test
    public void testExceptionFullClassName() {
        Assert.assertEquals((Object)"org.mule.db.commons.internal.result.resultset.ResultSetProcessingException", (Object)ResultSetProcessingException.class.getName());
    }

    @Test
    public void testMultipleInstances() {
        String message1 = "First error";
        String message2 = "Second error";
        RuntimeException cause1 = new RuntimeException("Cause 1");
        RuntimeException cause2 = new RuntimeException("Cause 2");
        ResultSetProcessingException exception1 = new ResultSetProcessingException(message1, (Throwable)cause1);
        ResultSetProcessingException exception2 = new ResultSetProcessingException(message2, (Throwable)cause2);
        Assert.assertNotNull((Object)exception1);
        Assert.assertNotNull((Object)exception2);
        Assert.assertEquals((Object)message1, (Object)exception1.getMessage());
        Assert.assertEquals((Object)message2, (Object)exception2.getMessage());
        Assert.assertEquals((Object)cause1, (Object)exception1.getCause());
        Assert.assertEquals((Object)cause2, (Object)exception2.getCause());
    }

    @Test
    public void testExceptionStackTrace() {
        String message = "Test error message";
        RuntimeException cause = new RuntimeException("Original cause");
        ResultSetProcessingException exception = new ResultSetProcessingException(message, (Throwable)cause);
        Assert.assertNotNull((Object)exception.getStackTrace());
        Assert.assertTrue((exception.getStackTrace().length > 0 ? 1 : 0) != 0);
    }
}

