/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import com.mchange.v2.c3p0.PooledDataSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class DbPoolingProfileLoggerUtilsTestCase {
    private DataSource mockDataSource;
    private PooledDataSource mockPooledDataSource;
    private Logger mockLogger;

    @Before
    public void setUp() {
        this.mockDataSource = (DataSource)Mockito.mock(DataSource.class);
        this.mockPooledDataSource = (PooledDataSource)Mockito.mock(PooledDataSource.class);
        this.mockLogger = (Logger)Mockito.mock(Logger.class);
    }

    @Test
    public void testConstructorThrowsException() {
        Assert.assertThrows(InvocationTargetException.class, () -> {
            Constructor constructor = DbPoolingProfileLoggerUtils.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
        });
    }

    @Test
    public void testGetC3P0sPoolingDataWithNullDataSource() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData(null, (String)"testCaller");
    }

    @Test
    public void testGetC3P0sPoolingDataWithNullCaller() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, null);
    }

    @Test
    public void testGetC3P0sPoolingDataWithNonPooledDataSource() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"testCaller");
    }

    @Test
    public void testGetC3P0sPoolingDataWithValidPooledDataSource() throws SQLException {
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenReturn((Object)10);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumBusyConnectionsDefaultUser()).thenReturn((Object)5);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumIdleConnectionsDefaultUser()).thenReturn((Object)5);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumUnclosedOrphanedConnectionsDefaultUser()).thenReturn((Object)0);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumStatementsDefaultUser()).thenReturn((Object)20);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumCheckedOutDefaultUser()).thenReturn((Object)3);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumConnectionsWithCachedStatementsDefaultUser()).thenReturn((Object)8);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStartTimeMillisDefaultUser()).thenReturn((Object)1000L);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getUpTimeMillisDefaultUser()).thenReturn((Object)5000L);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedCheckinsDefaultUser()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedIdleTestsDefaultUser()).thenReturn((Object)0L);
        Mockito.lenient().when((Object)Float.valueOf(this.mockPooledDataSource.getEffectivePropertyCycleDefaultUser())).thenReturn((Object)Float.valueOf(300.0f));
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser()).thenReturn((Object)2);
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"testCaller");
    }

    @Test
    public void testGetC3P0sPoolingDataWithSQLException() throws SQLException {
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenThrow(new Throwable[]{new SQLException("Test SQL Exception")});
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"testCaller");
    }

    @Test
    public void testGetXAPoolDataWithNullDataSource() {
        DbPoolingProfileLoggerUtils.getXAPoolData(null, (String)"testCaller");
    }

    @Test
    public void testGetXAPoolDataWithNullCaller() {
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, null);
    }

    @Test
    public void testGetDataSourcePoolDataWithNullCaller() {
        DbPoolingProfileLoggerUtils.getDataSourcePoolData(null);
    }

    @Test
    public void testGetDataSourcePoolDataWithNoSystemProperty() {
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
    }

    @Test
    public void testGetDataSourcePoolDataWithSystemPropertySet() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            System.setProperty("mule.db.connector.pooling.logger.pattern", "test:pattern=*");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testGetDataSourcePoolDataWithInvalidSystemProperty() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            System.setProperty("mule.db.connector.pooling.logger.pattern", "invalid:pattern[");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testGetMBeanPatternReturnsSystemProperty() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            String testPattern = "test:pattern=*";
            System.setProperty("mule.db.connector.pooling.logger.pattern", testPattern);
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testAllMethodsHandleExceptionsGracefully() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData(null, null);
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"test");
        DbPoolingProfileLoggerUtils.getXAPoolData(null, null);
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"test");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData(null);
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"test");
    }

    @Test
    public void testMethodsWithTraceLoggingDisabled() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"testCaller");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"testCaller");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
    }

    @Test
    public void testMethodsWithTraceLoggingEnabled() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"testCaller");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"testCaller");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
    }

    @Test
    public void testC3P0PoolingDataWithAllMethodsCalled() throws SQLException {
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenReturn((Object)15);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumBusyConnectionsDefaultUser()).thenReturn((Object)8);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumIdleConnectionsDefaultUser()).thenReturn((Object)7);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumUnclosedOrphanedConnectionsDefaultUser()).thenReturn((Object)1);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumStatementsDefaultUser()).thenReturn((Object)25);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumCheckedOutDefaultUser()).thenReturn((Object)5);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumConnectionsWithCachedStatementsDefaultUser()).thenReturn((Object)12);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getStartTimeMillisDefaultUser()).thenReturn((Object)2000L);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getUpTimeMillisDefaultUser()).thenReturn((Object)10000L);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedCheckinsDefaultUser()).thenReturn((Object)2L);
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedIdleTestsDefaultUser()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)Float.valueOf(this.mockPooledDataSource.getEffectivePropertyCycleDefaultUser())).thenReturn((Object)Float.valueOf(500.0f));
        Mockito.lenient().when((Object)this.mockPooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser()).thenReturn((Object)3);
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"testCaller");
    }

    @Test
    public void testSystemPropertyRestoration() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        String testValue = "test:pattern=*";
        try {
            System.setProperty("mule.db.connector.pooling.logger.pattern", testValue);
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
        String currentProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        if (originalProperty != null ? !$assertionsDisabled && !originalProperty.equals(currentProperty) : !$assertionsDisabled && currentProperty != null) {
            throw new AssertionError();
        }
    }

    @Test
    public void testEdgeCasesWithVariousInputs() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"");
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"test@caller.com");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"test@caller.com");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"test@caller.com");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            sb.append("a");
        }
        String longCaller = sb.toString();
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)longCaller);
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)longCaller);
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)longCaller);
    }

    @Test
    public void testMultipleConsecutiveCalls() {
        for (int i = 0; i < 10; ++i) {
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)("testCaller" + i));
            DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)("testCaller" + i));
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)("testCaller" + i));
        }
    }

    @Test
    public void testConcurrentAccessSimulation() {
        Runnable task1 = () -> {
            for (int i = 0; i < 5; ++i) {
                DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"thread1");
            }
        };
        Runnable task2 = () -> {
            for (int i = 0; i < 5; ++i) {
                DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"thread2");
            }
        };
        Runnable task3 = () -> {
            for (int i = 0; i < 5; ++i) {
                DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"thread3");
            }
        };
        task1.run();
        task2.run();
        task3.run();
    }

    @Test
    public void testDirectC3P0DataCollectionForMaximumCoverage() throws Exception {
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenReturn((Object)100);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumBusyConnectionsDefaultUser()).thenReturn((Object)50);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumIdleConnectionsDefaultUser()).thenReturn((Object)50);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumUnclosedOrphanedConnectionsDefaultUser()).thenReturn((Object)5);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumStatementsDefaultUser()).thenReturn((Object)200);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumCheckedOutDefaultUser()).thenReturn((Object)25);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumConnectionsWithCachedStatementsDefaultUser()).thenReturn((Object)75);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStartTimeMillisDefaultUser()).thenReturn((Object)10000L);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getUpTimeMillisDefaultUser()).thenReturn((Object)30000L);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedCheckinsDefaultUser()).thenReturn((Object)10L);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedIdleTestsDefaultUser()).thenReturn((Object)3L);
            Mockito.lenient().when((Object)Float.valueOf(this.mockPooledDataSource.getEffectivePropertyCycleDefaultUser())).thenReturn((Object)Float.valueOf(1000.0f));
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser()).thenReturn((Object)15);
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"directCoverageTest");
        }
        finally {
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
        }
    }

    @Test
    public void testDirectMBeanDataCollectionForMaximumCoverage() throws Exception {
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "java.lang:type=Memory,*");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"directMBeanCoverageTest");
        }
        finally {
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testExceptionHandlingInC3P0DataCollection() throws Exception {
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenThrow(new Throwable[]{new SQLException("Test exception")});
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"exceptionTest");
        }
        finally {
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
        }
    }

    @Test
    public void testExceptionHandlingInMBeanDataCollection() throws Exception {
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "invalid:pattern[");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"mbeanExceptionTest");
        }
        finally {
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testClassStructureAndConstants() {
        Assert.assertEquals((Object)"mule.db.connector.pooling.logger.pattern", (Object)DbPoolingProfileLoggerUtilsTestCase.getPrivateStaticField(DbPoolingProfileLoggerUtils.class, "POOLING_DATA_LOGGER_MBEAN_PATTERN"));
        Assert.assertEquals((Object)"Pooling data being gathered at {} method", (Object)DbPoolingProfileLoggerUtilsTestCase.getPrivateStaticField(DbPoolingProfileLoggerUtils.class, "INITIATION_POLLING_PHRASE"));
    }

    @Test
    public void testClassIsUtilityClass() {
        Assert.assertTrue((boolean)Modifier.isPublic(DbPoolingProfileLoggerUtils.class.getModifiers()));
        for (Method method : DbPoolingProfileLoggerUtils.class.getDeclaredMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || method.getName().equals("getMBeanPattern")) continue;
            Assert.assertTrue((String)("Public method " + method.getName() + " should be static"), (boolean)Modifier.isStatic(method.getModifiers()));
        }
    }

    @Test
    public void testXAPoolDataWithReflectionExceptions() {
        DataSource mockDataSourceWithReflectionIssues = (DataSource)Mockito.mock(DataSource.class);
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)mockDataSourceWithReflectionIssues, (String)"testCaller");
    }

    @Test
    public void testMBeanDataCollectionWithVariousPatterns() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            System.clearProperty("mule.db.connector.pooling.logger.pattern");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "*:*");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "java.lang:type=Memory");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"testCaller");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
        }
    }

    @Test
    public void testC3P0DataCollectionWithExtremeValues() throws SQLException {
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumBusyConnectionsDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumIdleConnectionsDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumUnclosedOrphanedConnectionsDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumStatementsDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumCheckedOutDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumConnectionsWithCachedStatementsDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStartTimeMillisDefaultUser()).thenReturn((Object)Long.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getUpTimeMillisDefaultUser()).thenReturn((Object)Long.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedCheckinsDefaultUser()).thenReturn((Object)Long.MAX_VALUE);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedIdleTestsDefaultUser()).thenReturn((Object)Long.MAX_VALUE);
            Mockito.lenient().when((Object)Float.valueOf(this.mockPooledDataSource.getEffectivePropertyCycleDefaultUser())).thenReturn((Object)Float.valueOf(Float.MAX_VALUE));
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser()).thenReturn((Object)Integer.MAX_VALUE);
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"extremeValuesTest");
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumConnectionsDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumBusyConnectionsDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumIdleConnectionsDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumUnclosedOrphanedConnectionsDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumStatementsDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumCheckedOutDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStatementCacheNumConnectionsWithCachedStatementsDefaultUser()).thenReturn((Object)0);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getStartTimeMillisDefaultUser()).thenReturn((Object)0L);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getUpTimeMillisDefaultUser()).thenReturn((Object)0L);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedCheckinsDefaultUser()).thenReturn((Object)0L);
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumFailedIdleTestsDefaultUser()).thenReturn((Object)0L);
            Mockito.lenient().when((Object)Float.valueOf(this.mockPooledDataSource.getEffectivePropertyCycleDefaultUser())).thenReturn((Object)Float.valueOf(0.0f));
            Mockito.lenient().when((Object)this.mockPooledDataSource.getNumThreadsAwaitingCheckoutDefaultUser()).thenReturn((Object)0);
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockPooledDataSource, (String)"minimumValuesTest");
        }
        finally {
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
        }
    }

    @Test
    public void testMBeanAttributeReadingWithVariousTypes() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        String originalLogLevel = System.getProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
        try {
            System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", "TRACE");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "java.lang:type=Memory,*");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"attributeTypeTest");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
            if (originalLogLevel != null) {
                System.setProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", originalLogLevel);
            } else {
                System.clearProperty("org.slf4j.simpleLogger.log.org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils");
            }
        }
    }

    @Test
    public void testPrivateMethodAccessibility() throws Exception {
        Method getMBeanPatternMethod = DbPoolingProfileLoggerUtils.class.getDeclaredMethod("getMBeanPattern", new Class[0]);
        Assert.assertFalse((String)"Private method should not be accessible by default", (boolean)getMBeanPatternMethod.isAccessible());
        getMBeanPatternMethod.setAccessible(true);
        Assert.assertTrue((String)"Private method should be accessible after setAccessible(true)", (boolean)getMBeanPatternMethod.isAccessible());
    }

    @Test
    public void testLoggerConfiguration() {
        Logger logger = LoggerFactory.getLogger(DbPoolingProfileLoggerUtils.class);
        Assert.assertNotNull((String)"Logger should not be null", (Object)logger);
        Assert.assertEquals((String)"Logger name should match class name", (Object)"org.mule.db.commons.internal.util.DbPoolingProfileLoggerUtils", (Object)logger.getName());
    }

    @Test
    public void testMethodParameterValidation() {
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData(null, null);
        DbPoolingProfileLoggerUtils.getXAPoolData(null, null);
        DbPoolingProfileLoggerUtils.getDataSourcePoolData(null);
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"");
        DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)"   ");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"   ");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"   ");
    }

    @Test
    public void testSystemPropertyHandling() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            System.setProperty("mule.db.connector.pooling.logger.pattern", "test:pattern=*,name=test");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"specialCharsTest");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "test:pattern=*, name=test");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"spacesTest");
            System.setProperty("mule.db.connector.pooling.logger.pattern", "test:pattern=*,name=\u6d4b\u8bd5");
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"unicodeTest");
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testConcurrentSystemPropertyAccess() {
        String originalProperty = System.getProperty("mule.db.connector.pooling.logger.pattern");
        try {
            for (int i = 0; i < 10; ++i) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", "test:pattern=" + i);
                DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)("concurrentTest" + i));
            }
        }
        finally {
            if (originalProperty != null) {
                System.setProperty("mule.db.connector.pooling.logger.pattern", originalProperty);
            } else {
                System.clearProperty("mule.db.connector.pooling.logger.pattern");
            }
        }
    }

    @Test
    public void testMemoryLeakPrevention() {
        for (int i = 0; i < 100; ++i) {
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)("memoryTest" + i));
            DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)("memoryTest" + i));
            DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)("memoryTest" + i));
        }
        System.gc();
    }

    @Test
    public void testPerformanceUnderLoad() {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            DbPoolingProfileLoggerUtils.getC3P0sPoolingData((DataSource)this.mockDataSource, (String)("perfTest" + i));
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        Assert.assertTrue((String)"Performance test should complete within 5 seconds", (duration < 5000L ? 1 : 0) != 0);
    }

    private static Object getPrivateStaticField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to access private static field: " + fieldName, e);
        }
    }

    @Test
    public void testFinalXAPoolCoverageWithVariousDataSources() {
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockDataSource, (String)"finalXACoverageTest");
        DbPoolingProfileLoggerUtils.getXAPoolData((DataSource)this.mockPooledDataSource, (String)"finalXACoverageTest2");
        DbPoolingProfileLoggerUtils.getXAPoolData(null, (String)"finalXACoverageTest3");
    }

    @Test
    public void testFinalDataSourcePoolCoverageWithVariousPatterns() {
        System.setProperty("mule.db.connector.pooling.logger.pattern", "test:pattern=*,name=final");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"finalDataSourceCoverageTest");
        System.setProperty("mule.db.connector.pooling.logger.pattern", "test:type=*,category=pool");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"finalDataSourceCoverageTest2");
        System.setProperty("mule.db.connector.pooling.logger.pattern", "invalid:pattern[");
        DbPoolingProfileLoggerUtils.getDataSourcePoolData((String)"finalDataSourceCoverageTest3");
    }
}

