/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.util.InputStreamWithEOFCallbackWrapper;
import org.mule.runtime.core.api.util.func.CheckedRunnable;

public class InputStreamWithEOFCallbackWrapperTestCase {
    private InputStream mockDelegate;
    private CheckedRunnable mockCallback;
    private InputStreamWithEOFCallbackWrapper wrapper;

    @Before
    public void setUp() {
        this.mockDelegate = (InputStream)Mockito.mock(InputStream.class);
        this.mockCallback = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
        this.wrapper = new InputStreamWithEOFCallbackWrapper(this.mockDelegate, this.mockCallback);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.wrapper);
    }

    @Test
    public void testReadSingleByteNotEOF() throws IOException {
        Mockito.when((Object)this.mockDelegate.read()).thenReturn((Object)65);
        int result = this.wrapper.read();
        Assert.assertEquals((long)65L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testReadSingleByteEOF() throws IOException {
        Mockito.when((Object)this.mockDelegate.read()).thenReturn((Object)-1);
        int result = this.wrapper.read();
        Assert.assertEquals((long)-1L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback)).run();
    }

    @Test
    public void testReadSingleByteEOFCallbackCalledOnce() throws IOException {
        Mockito.when((Object)this.mockDelegate.read()).thenReturn((Object)-1, (Object[])new Integer[]{-1, -1});
        this.wrapper.read();
        this.wrapper.read();
        this.wrapper.read();
        ((InputStream)Mockito.verify((Object)this.mockDelegate, (VerificationMode)Mockito.times((int)3))).read();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void testReadByteArrayNotEOF() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer)).thenReturn((Object)5);
        int result = this.wrapper.read(buffer);
        Assert.assertEquals((long)5L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read(buffer);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testReadByteArrayEOF() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer)).thenReturn((Object)-1);
        int result = this.wrapper.read(buffer);
        Assert.assertEquals((long)-1L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read(buffer);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback)).run();
    }

    @Test
    public void testReadByteArrayWithOffsetNotEOF() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer, 2, 5)).thenReturn((Object)3);
        int result = this.wrapper.read(buffer, 2, 5);
        Assert.assertEquals((long)3L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read(buffer, 2, 5);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testReadByteArrayWithOffsetEOF() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer, 2, 5)).thenReturn((Object)-1);
        int result = this.wrapper.read(buffer, 2, 5);
        Assert.assertEquals((long)-1L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read(buffer, 2, 5);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback)).run();
    }

    @Test
    public void testReadByteArrayWithOffsetEOFCallbackCalledOnce() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer, 2, 5)).thenReturn((Object)-1, (Object[])new Integer[]{-1, -1});
        this.wrapper.read(buffer, 2, 5);
        this.wrapper.read(buffer, 2, 5);
        this.wrapper.read(buffer, 2, 5);
        ((InputStream)Mockito.verify((Object)this.mockDelegate, (VerificationMode)Mockito.times((int)3))).read(buffer, 2, 5);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void testSkip() throws IOException {
        Mockito.when((Object)this.mockDelegate.skip(10L)).thenReturn((Object)5L);
        long result = this.wrapper.skip(10L);
        Assert.assertEquals((long)5L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).skip(10L);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testAvailable() throws IOException {
        Mockito.when((Object)this.mockDelegate.available()).thenReturn((Object)100);
        int result = this.wrapper.available();
        Assert.assertEquals((long)100L, (long)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).available();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testClose() throws IOException {
        this.wrapper.close();
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).close();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testMark() {
        this.wrapper.mark(100);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).mark(100);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testReset() throws IOException {
        this.wrapper.reset();
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).reset();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testMarkSupported() {
        Mockito.when((Object)this.mockDelegate.markSupported()).thenReturn((Object)true);
        boolean result = this.wrapper.markSupported();
        Assert.assertTrue((boolean)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).markSupported();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testMarkSupportedFalse() {
        Mockito.when((Object)this.mockDelegate.markSupported()).thenReturn((Object)false);
        boolean result = this.wrapper.markSupported();
        Assert.assertFalse((boolean)result);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).markSupported();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testCallbackThrowsException() throws IOException {
        CheckedRunnable exceptionCallback = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
        ((CheckedRunnable)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Callback exception")}).when((Object)exceptionCallback)).run();
        InputStreamWithEOFCallbackWrapper exceptionWrapper = new InputStreamWithEOFCallbackWrapper(this.mockDelegate, exceptionCallback);
        Mockito.when((Object)this.mockDelegate.read()).thenReturn((Object)-1);
        try {
            exceptionWrapper.read();
            Assert.fail((String)"Expected RuntimeException to be thrown");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Callback exception", (Object)e.getMessage());
        }
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read();
        ((CheckedRunnable)Mockito.verify((Object)exceptionCallback)).run();
    }

    @Test
    public void testDelegateThrowsIOException() throws IOException {
        Mockito.when((Object)this.mockDelegate.read()).thenThrow(new Throwable[]{new IOException("Delegate exception")});
        try {
            this.wrapper.read();
            Assert.fail((String)"Expected IOException to be thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Delegate exception", (Object)e.getMessage());
        }
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read();
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testReadByteArrayDelegateThrowsIOException() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer)).thenThrow(new Throwable[]{new IOException("Delegate exception")});
        try {
            this.wrapper.read(buffer);
            Assert.fail((String)"Expected IOException to be thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Delegate exception", (Object)e.getMessage());
        }
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read(buffer);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testReadByteArrayWithOffsetDelegateThrowsIOException() throws IOException {
        byte[] buffer = new byte[10];
        Mockito.when((Object)this.mockDelegate.read(buffer, 2, 5)).thenThrow(new Throwable[]{new IOException("Delegate exception")});
        try {
            this.wrapper.read(buffer, 2, 5);
            Assert.fail((String)"Expected IOException to be thrown");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Delegate exception", (Object)e.getMessage());
        }
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read(buffer, 2, 5);
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.never())).run();
    }

    @Test
    public void testIntegrationWithRealInputStream() throws IOException {
        String testData = "Hello, World!";
        ByteArrayInputStream realInputStream = new ByteArrayInputStream(testData.getBytes());
        CheckedRunnable realCallback = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
        InputStreamWithEOFCallbackWrapper realWrapper = new InputStreamWithEOFCallbackWrapper((InputStream)realInputStream, realCallback);
        byte[] buffer = new byte[1024];
        int bytesRead = realWrapper.read(buffer);
        Assert.assertEquals((long)testData.length(), (long)bytesRead);
        ((CheckedRunnable)Mockito.verify((Object)realCallback, (VerificationMode)Mockito.never())).run();
        int eofResult = realWrapper.read();
        Assert.assertEquals((long)-1L, (long)eofResult);
        ((CheckedRunnable)Mockito.verify((Object)realCallback)).run();
    }

    @Test
    public void testIntegrationWithEmptyInputStream() throws IOException {
        ByteArrayInputStream emptyInputStream = new ByteArrayInputStream(new byte[0]);
        CheckedRunnable realCallback = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
        InputStreamWithEOFCallbackWrapper realWrapper = new InputStreamWithEOFCallbackWrapper((InputStream)emptyInputStream, realCallback);
        int result = realWrapper.read();
        Assert.assertEquals((long)-1L, (long)result);
        ((CheckedRunnable)Mockito.verify((Object)realCallback)).run();
    }

    @Test
    public void testMultipleReadMethodsEOFCallbackCalledOnce() throws IOException {
        Mockito.when((Object)this.mockDelegate.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.mockDelegate.read((byte[])Mockito.any(byte[].class))).thenReturn((Object)-1);
        Mockito.when((Object)this.mockDelegate.read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        this.wrapper.read();
        this.wrapper.read(new byte[10]);
        this.wrapper.read(new byte[10], 0, 5);
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read();
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read((byte[])Mockito.any(byte[].class));
        ((InputStream)Mockito.verify((Object)this.mockDelegate)).read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt());
        ((CheckedRunnable)Mockito.verify((Object)this.mockCallback, (VerificationMode)Mockito.times((int)1))).run();
    }

    @Test
    public void testNullDelegate() throws IOException {
        InputStreamWithEOFCallbackWrapper nullDelegateWrapper = new InputStreamWithEOFCallbackWrapper(null, this.mockCallback);
        try {
            nullDelegateWrapper.read();
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testNullCallback() throws IOException {
        InputStreamWithEOFCallbackWrapper nullCallbackWrapper = new InputStreamWithEOFCallbackWrapper(this.mockDelegate, null);
        Mockito.when((Object)this.mockDelegate.read()).thenReturn((Object)-1);
        try {
            nullCallbackWrapper.read();
            Assert.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

