/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.util;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.exception.connection.BadSqlSyntaxException;
import org.mule.db.commons.internal.util.StoredProcedureUtils;
import org.mule.runtime.api.util.Pair;

public class StoredProcedureUtilsTestCase {
    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedure() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.procedure()}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedureWithDollar() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.proce$dures()}");
        Assert.assertEquals((Object)"proce$dures", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedureWithDollarAtEnd() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.procedure$()}");
        Assert.assertEquals((Object)"procedure$", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedureWithDollarAtStart() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call db.$procedure()}");
        Assert.assertEquals((Object)"$procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedureWithBrackets() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call [db].[procedure]()}");
        Assert.assertEquals((Object)"[procedure]", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedureWithSchema() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call schema.procedure()}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidStoredProcedureWithPackage() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call schema.package.procedure()}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidFunction() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call db.function()}");
        Assert.assertEquals((Object)"function", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidFunctionWithBrackets() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call [db].[function]()}");
        Assert.assertEquals((Object)"[function]", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidFunctionWithSchema() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call schema.function()}");
        Assert.assertEquals((Object)"function", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithValidFunctionWithPackage() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call schema.package.function()}");
        Assert.assertEquals((Object)"function", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithInvalidStoredProcedure() {
        StoredProcedureUtils.analyzeStoredOperation((String)"{call [db].procedu{re()}");
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithInvalidFunction() {
        StoredProcedureUtils.analyzeStoredOperation((String)"{?=call [db].func{ion()}");
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithInvalidSql() {
        StoredProcedureUtils.analyzeStoredOperation((String)"SELECT * FROM table");
    }

    @Test(expected=NullPointerException.class)
    public void testAnalyzeStoredOperationWithNull() {
        StoredProcedureUtils.analyzeStoredOperation(null);
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithEmptyString() {
        StoredProcedureUtils.analyzeStoredOperation((String)"");
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithWhitespace() {
        StoredProcedureUtils.analyzeStoredOperation((String)"   ");
    }

    @Test
    public void testGetStoreProcedureOwnerWithSchema() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{call schema.procedure()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"schema", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithPackage() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{call schema.package.procedure()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"schema", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithOnlyPackage() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{call package.procedure()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"package", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithNoOwner() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{call procedure()}");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetStoreProcedureOwnerWithFunction() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{?=call schema.function()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"schema", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithFunctionAndPackage() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{?=call schema.package.function()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"schema", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithFunctionOnlyPackage() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{?=call package.function()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"package", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithFunctionNoOwner() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{?=call function()}");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testGetStoreProcedureOwnerWithInvalidSql() {
        StoredProcedureUtils.getStoreProcedureOwner((String)"SELECT * FROM table");
    }

    @Test(expected=NullPointerException.class)
    public void testGetStoreProcedureOwnerWithNull() {
        StoredProcedureUtils.getStoreProcedureOwner(null);
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testGetStoreProcedureOwnerWithEmptyString() {
        StoredProcedureUtils.getStoreProcedureOwner((String)"");
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithPackage() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{call schema.package.procedure()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"package", result.get());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithFunctionPackage() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{?=call schema.package.function()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"package", result.get());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithNoPackage() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{call schema.procedure()}");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithNoOwner() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{call procedure()}");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithFunctionNoPackage() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{?=call schema.function()}");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithFunctionNoOwner() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{?=call function()}");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testGetStoredProcedureParentOwnerWithInvalidSql() {
        StoredProcedureUtils.getStoredProcedureParentOwner((String)"SELECT * FROM table");
    }

    @Test(expected=NullPointerException.class)
    public void testGetStoredProcedureParentOwnerWithNull() {
        StoredProcedureUtils.getStoredProcedureParentOwner(null);
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testGetStoredProcedureParentOwnerWithEmptyString() {
        StoredProcedureUtils.getStoredProcedureParentOwner((String)"");
    }

    @Test
    public void testAnalyzeStoredOperationWithComplexStoredProcedure() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call [MySchema].[MyPackage].[MyProcedure](@param1, @param2)}");
        Assert.assertEquals((Object)"[MyProcedure]", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithComplexFunction() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call [MySchema].[MyPackage].[MyFunction](@param1, @param2)}");
        Assert.assertEquals((Object)"[MyFunction]", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithParameters() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call procedure(?, ?, ?)}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithFunctionWithParameters() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call function(?, ?, ?)}");
        Assert.assertEquals((Object)"function", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithNamedParameters() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call procedure(@param1, @param2)}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithFunctionWithNamedParameters() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call function(@param1, @param2)}");
        Assert.assertEquals((Object)"function", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithMixedCase() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{CALL SCHEMA.PROCEDURE()}");
        Assert.assertEquals((Object)"PROCEDURE", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithFunctionWithMixedCase() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=CALL SCHEMA.FUNCTION()}");
        Assert.assertEquals((Object)"FUNCTION", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithSpaces() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{ call schema.procedure() }");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithNewlines() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{\ncall schema.procedure()\n}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testGetStoreProcedureOwnerWithBrackets() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{call [schema].[procedure]()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"[schema]", result.get());
    }

    @Test
    public void testGetStoreProcedureOwnerWithBracketsAndPackage() {
        Optional result = StoredProcedureUtils.getStoreProcedureOwner((String)"{call [schema].[package].[procedure]()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"[schema]", result.get());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithBrackets() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{call [schema].[package].[procedure]()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"[package]", result.get());
    }

    @Test
    public void testGetStoredProcedureParentOwnerWithBracketsAndFunction() {
        Optional result = StoredProcedureUtils.getStoredProcedureParentOwner((String)"{?=call [schema].[package].[function]()}");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"[package]", result.get());
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithUnderscore() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call schema.my_procedure()}");
        Assert.assertEquals((Object)"my_procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithFunctionWithUnderscore() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call schema.my_function()}");
        Assert.assertEquals((Object)"my_function", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithNumbers() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call schema.procedure123()}");
        Assert.assertEquals((Object)"procedure123", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithFunctionWithNumbers() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{?=call schema.function123()}");
        Assert.assertEquals((Object)"function123", (Object)result.getFirst());
        Assert.assertTrue((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithSpecialCharacters() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{call schema.procedure$123()}");
        Assert.assertEquals((Object)"procedure$123", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithMalformedStoredProcedure() {
        StoredProcedureUtils.analyzeStoredOperation((String)"{call}");
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithMalformedFunction() {
        StoredProcedureUtils.analyzeStoredOperation((String)"{?=call}");
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithIncompleteStoredProcedure() {
        StoredProcedureUtils.analyzeStoredOperation((String)"{call schema.procedure");
    }

    @Test(expected=BadSqlSyntaxException.class)
    public void testAnalyzeStoredOperationWithIncompleteFunction() {
        StoredProcedureUtils.analyzeStoredOperation((String)"{?=call schema.function");
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithMultipleSpaces() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{   call   schema.procedure()   }");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }

    @Test
    public void testAnalyzeStoredOperationWithStoredProcedureWithTabs() {
        Pair result = StoredProcedureUtils.analyzeStoredOperation((String)"{\tcall\tschema.procedure()\t}");
        Assert.assertEquals((Object)"procedure", (Object)result.getFirst());
        Assert.assertFalse((boolean)((Boolean)result.getSecond()));
    }
}

