/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.resolver.query;

import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.param.StatementDefinition;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

import com.github.benmanes.caffeine.cache.Cache;

/**
 * Resolves a {@link Query}
 */
public interface QueryResolver<T extends StatementDefinition> {

  /**
   * Resolves a query
   *
   * @param statementDefinition
   * @param connector
   * @param connection          connection to the database. not null
   * @param streamingHelper
   * @return query resolved for the given event
   */
  Query resolve(T statementDefinition, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper)
      throws QueryResolutionException;
}
