/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.db.commons.internal.domain.connection.generic;

import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DbConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;

import java.util.Optional;
import javax.sql.DataSource;

import static org.mule.runtime.extension.api.annotation.param.ParameterGroup.CONNECTION;

/**
 * {@link ConnectionProvider} that creates connections for any kind of database using a JDBC URL and the required JDBC Driver
 * Class. Consumers of {@link GenericConnectionProvider} must create a class similar to this one with the appropriate annotations
 * (DisplayName, Alias, ExternalLib, ParameterGroup, others), and have an instance of this one to pass the required properties.
 */
public class GenericConnectionProvider extends DbConnectionProvider {


  @ParameterGroup(name = CONNECTION)
  private GenericConnectionParameters genericConnectionParameters;


  @Override
  public java.util.Optional<DataSource> getDataSource() {
    return java.util.Optional.empty();
  }

  @Override
  public java.util.Optional<DataSourceConfig> getDataSourceConfig() {
    return java.util.Optional.ofNullable(genericConnectionParameters);
  }

}
