/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser;

import java.util.ArrayList;
import org.mule.db.commons.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.parser.QueryTemplateParser;
import org.mule.db.commons.internal.parser.QueryTemplateParsingException;
import org.mule.db.commons.internal.parser.statement.detector.StatementTypeDetector;
import org.mule.db.commons.internal.parser.statement.detector.UnknownStatementTypeException;
import org.mule.runtime.core.api.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleQueryTemplateParser
implements QueryTemplateParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleQueryTemplateParser.class);
    private static final QueryType DEFAULT_QUERY_TYPE = QueryType.DDL;
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] BEGIN_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] END_SKIP = new String[]{"'", "\"", "\n", "*/"};
    private static final char COLON_ESCAPE_CHARACTER = '\\';
    private final StatementTypeDetector queryTypeDetector = new StatementTypeDetector();

    @Override
    public QueryTemplate parse(String sql) {
        QueryType queryType;
        sql = sql.trim();
        LOGGER.debug("Parsing SQL: {}", (Object)sql);
        if (StringUtils.isEmpty((String)sql)) {
            throw new QueryTemplateParsingException("SQL text cannot be empty");
        }
        try {
            queryType = this.queryTypeDetector.detect(sql);
        }
        catch (UnknownStatementTypeException ex) {
            LOGGER.debug("Failed to detect query Type for {}. Falling back to default", (Object)sql, (Object)ex);
            queryType = DEFAULT_QUERY_TYPE;
        }
        return this.doParse(sql, queryType);
    }

    private QueryTemplate doParse(String sqlText, QueryType queryType) {
        StringBuilder sqlToUse = new StringBuilder();
        ArrayList<QueryParam> parameterList = new ArrayList<QueryParam>();
        char[] sqlTextChars = sqlText.toCharArray();
        int tokenStart = 0;
        int paramIndex = 1;
        while (tokenStart < sqlTextChars.length) {
            int skipToPosition;
            while (tokenStart < sqlTextChars.length && tokenStart != (skipToPosition = SimpleQueryTemplateParser.skipCommentsAndQuotes(sqlTextChars, tokenStart))) {
                sqlToUse = sqlToUse.append(sqlText, tokenStart, skipToPosition);
                tokenStart = skipToPosition;
            }
            if (tokenStart >= sqlTextChars.length) break;
            char currentChar = sqlTextChars[tokenStart];
            int tokenEnd = tokenStart + 1;
            if (tokenEnd < sqlTextChars.length && currentChar == '#' && sqlTextChars[tokenEnd] == '[') {
                int openBrackets = 0;
                while (tokenEnd < sqlTextChars.length) {
                    if (sqlTextChars[tokenEnd] == ']') {
                        --openBrackets;
                    } else if (sqlTextChars[tokenEnd] == '[') {
                        ++openBrackets;
                    }
                    if (openBrackets == 0) break;
                    ++tokenEnd;
                }
                if (tokenEnd == sqlTextChars.length) {
                    throw new QueryTemplateParsingException("Invalid Mule expression: " + sqlText.substring(tokenStart));
                }
                String value = sqlText.substring(tokenStart, ++tokenEnd);
                DefaultInputQueryParam inputParam = new DefaultInputQueryParam(paramIndex++, UnknownDbType.getInstance(), (Object)value);
                parameterList.add(inputParam);
                sqlToUse = sqlToUse.append("?");
                tokenStart = tokenEnd;
                continue;
            }
            if (currentChar == '\\' && tokenEnd < sqlTextChars.length && ':' == sqlTextChars[tokenEnd]) {
                sqlToUse = sqlToUse.append(':');
                tokenStart = ++tokenEnd;
                continue;
            }
            if (currentChar == ':') {
                if (tokenEnd < sqlTextChars.length && '=' == sqlTextChars[tokenEnd]) {
                    sqlToUse = sqlToUse.append(currentChar);
                    ++tokenStart;
                    continue;
                }
                if (tokenEnd < sqlTextChars.length && ':' == sqlTextChars[tokenEnd]) {
                    sqlToUse = sqlToUse.append(currentChar).append(sqlTextChars[tokenEnd]);
                    tokenStart += 2;
                    continue;
                }
                while (tokenEnd < sqlTextChars.length && !SimpleQueryTemplateParser.isParameterSeparator(sqlTextChars[tokenEnd])) {
                    ++tokenEnd;
                }
                if (tokenEnd - tokenStart > 1) {
                    sqlToUse = sqlToUse.append("?");
                    String parameter = sqlText.substring(tokenStart + 1, tokenEnd);
                    DefaultInputQueryParam inputParam = new DefaultInputQueryParam(paramIndex++, UnknownDbType.getInstance(), null, parameter);
                    parameterList.add(inputParam);
                }
                tokenStart = tokenEnd;
                continue;
            }
            if (this.isParamChar(currentChar)) {
                DefaultInputQueryParam inputParam = new DefaultInputQueryParam(paramIndex++, UnknownDbType.getInstance(), (Object)null);
                parameterList.add(inputParam);
                ++tokenStart;
                sqlToUse = sqlToUse.append(currentChar);
                continue;
            }
            sqlToUse = sqlToUse.append(currentChar);
            ++tokenStart;
        }
        return new QueryTemplate(sqlToUse.toString(), queryType, parameterList);
    }

    private boolean isParamChar(char c) {
        return c == '?';
    }

    private static boolean isParameterSeparator(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        for (char separator : PARAMETER_SEPARATORS) {
            if (c != separator) continue;
            return true;
        }
        return false;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        for (int i = 0; i < BEGIN_SKIP.length; ++i) {
            if (statement[position] != BEGIN_SKIP[i].charAt(0)) continue;
            boolean match = true;
            for (int j = 1; j < BEGIN_SKIP[i].length(); ++j) {
                if (statement[position + j] == BEGIN_SKIP[i].charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            int offset = BEGIN_SKIP[i].length();
            for (int m = position + offset; m < statement.length; ++m) {
                if (statement[m] != END_SKIP[i].charAt(0)) continue;
                boolean endMatch = true;
                int endPos = m;
                for (int n = 1; n < END_SKIP[i].length(); ++n) {
                    if (m + n >= statement.length) {
                        return statement.length;
                    }
                    if (statement[m + n] != END_SKIP[i].charAt(n)) {
                        endMatch = false;
                        break;
                    }
                    endPos = m + n;
                }
                if (!endMatch) continue;
                return endPos + 1;
            }
            return statement.length;
        }
        return position;
    }
}

