/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.util.InputStreamWithEOFCallbackWrapper;

public class InputStreamWithEOFCallbackWrapperTestCase {
    @Test
    public void whenInputStreamReadSingleByteEOF() throws IOException {
        AtomicInteger callCount = new AtomicInteger(0);
        InputStream inputStream = IOUtils.toInputStream((String)"some string", (Charset)StandardCharsets.UTF_8);
        InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper(inputStream, () -> callCount.incrementAndGet());
        while (inputStreamWrapper.read() != -1) {
        }
        MatcherAssert.assertThat((Object)callCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void whenInputStreamReadEOF() throws IOException {
        AtomicInteger callCount = new AtomicInteger(0);
        InputStream inputStream = IOUtils.toInputStream((String)"some string", (Charset)StandardCharsets.UTF_8);
        InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper(inputStream, () -> callCount.incrementAndGet());
        byte[] b = new byte[64];
        inputStreamWrapper.read(b);
        inputStreamWrapper.read(b);
        MatcherAssert.assertThat((Object)callCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void whenInputStreamReadWithOffsetAndLenEOF() throws IOException {
        AtomicInteger callCount = new AtomicInteger(0);
        InputStream inputStream = IOUtils.toInputStream((String)"some string", (Charset)StandardCharsets.UTF_8);
        InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper(inputStream, () -> callCount.incrementAndGet());
        byte[] b = new byte[64];
        inputStreamWrapper.read(b, 0, 64);
        inputStreamWrapper.read(b, 0, 64);
        MatcherAssert.assertThat((Object)callCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }
}

