/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

public class OracleResolvedTypeTestCase {
    private static final int ORACLE_TIMESTAMPLTZ_ID = -102;
    private PreparedStatement mockPreparedStatement;
    private DbConnection mockDbConnection;
    private ResolvedDbType resolvedDbType;
    private Connection mockConnection;
    private DatabaseMetaData mockMetaData;

    @Before
    public void setUp() throws Exception {
        this.mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockConnection = (Connection)Mockito.mock(Connection.class);
        this.mockMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)this.mockPreparedStatement.getConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.getMetaData()).thenReturn((Object)this.mockMetaData);
        Mockito.when((Object)this.mockMetaData.getDriverName()).thenReturn((Object)"Oracle");
    }

    @Test
    public void testSetParameterValueWithOracleTimestampLTZ() throws SQLException {
        String value = "2022-10-05T15:39:20.045";
        this.resolvedDbType = new ResolvedDbType(-102, "TIMESTAMP WITH LOCAL TIME ZONE");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }

    @Test
    public void testSetParameterValueWithDate() throws SQLException {
        String value = "2022-10-05T15:39:20.045";
        this.resolvedDbType = new ResolvedDbType(91, "DATE");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }

    @Test
    public void testSetParameterValueWithTimestamp() throws SQLException {
        String value = "2024-08-14";
        this.resolvedDbType = new ResolvedDbType(93, "TIMESTAMP");
        this.resolvedDbType.setParameterValue(this.mockPreparedStatement, 1, (Object)value, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockPreparedStatement)).setObject(1, value);
    }
}

