/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.SelectStatementTypeDetector;
import org.mule.db.commons.internal.parser.statement.detector.WithStatementTypeDetector;

public class WithStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        WithStatementTypeDetector detector = new WithStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
    }

    @Test
    public void validWithStatementTest() {
        WithStatementTypeDetector detector = new WithStatementTypeDetector();
        List<String> withStatements = Arrays.asList("WITH SELECT A,B,C FROM MYTABLE as AVIEW \n SELECT * FROM AVIEW ", "with select select a as b, c as d from mytable as aview \n select * from aview");
        for (String statement : withStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidWithStatementTest() {
        SelectStatementTypeDetector detector = new SelectStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("DELETE FROM MY TABLE;", "MERGE FROM MYTABLE", "Insert into my table", "UPDATE delete from table");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

