/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.result.row.InsensitiveMapRowHandler;
import org.mule.runtime.api.metadata.TypedValue;

public class InsensitiveMapRowHandlerTestCase {
    public static final long CACHE_MAXIMUM_SIZE = 1000L;
    private DefaultDbConnection defaultDbConnection;
    private ResultSet resultSet;

    @Test
    public void testDB2ClobPreemptivelyConsumption() throws Exception {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        FakeClob clob = new FakeClob();
        clob.setString(1L, RandomStringUtils.randomPrint((int)10000));
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"ClobColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)clob);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        this.defaultDbConnection = new DefaultDbConnection(connection, new ArrayList(), Caffeine.newBuilder().maximumSize(1000L).build());
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)this.defaultDbConnection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("ClobColumn")) continue;
            Assert.assertFalse((boolean)((TypedValue)entry.getValue()).getDataType().isStreamType());
        }
    }

    @Test
    public void consumeBlobFreeResourcesTest() throws Exception {
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        InputStream blobIs = (InputStream)Mockito.mock(InputStream.class);
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"BlobColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)blob);
        Mockito.when((Object)blob.getBinaryStream()).thenReturn((Object)blobIs);
        Mockito.when((Object)blobIs.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        DefaultDbConnection connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)true);
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)connection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("BlobColumn")) continue;
            InputStream is = (InputStream)((TypedValue)entry.getValue()).getValue();
            is.read();
            ((Blob)Mockito.verify((Object)blob, (VerificationMode)Mockito.times((int)1))).free();
        }
    }

    @Test
    public void consumeClobFreeResourcesTest() throws Exception {
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        Reader reader = (Reader)Mockito.mock(Reader.class);
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"ClobColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)clob);
        Mockito.when((Object)clob.getCharacterStream()).thenReturn((Object)reader);
        Mockito.when((Object)reader.read()).thenReturn((Object)-1);
        Mockito.when((Object)reader.read((char[])Mockito.any(char[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        DefaultDbConnection connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)true);
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)connection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("ClobColumn")) continue;
            InputStream is2 = (InputStream)((TypedValue)entry.getValue()).getValue();
            is2.read();
            ((Clob)Mockito.verify((Object)clob, (VerificationMode)Mockito.times((int)1))).free();
        }
    }

    @Test
    public void consumeBlobFreeResourcesNonSupportsContentStreamingTest() throws Exception {
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        InputStream blobIs = (InputStream)Mockito.mock(InputStream.class);
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"BlobColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)blob);
        Mockito.when((Object)blob.getBinaryStream()).thenReturn((Object)blobIs);
        Mockito.when((Object)blobIs.read()).thenReturn((Object)-1);
        Mockito.when((Object)blobIs.read((byte[])Mockito.any(byte[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        Mockito.when((Object)blobIs.read((byte[])Mockito.any(byte[].class))).thenReturn((Object)-1);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        DefaultDbConnection connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)false);
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)connection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("BlobColumn")) continue;
            InputStream is = (InputStream)((TypedValue)entry.getValue()).getValue();
            is.read();
            ((Blob)Mockito.verify((Object)blob, (VerificationMode)Mockito.times((int)1))).free();
        }
    }

    @Test
    public void consumeClobFreeResourcesNonSupportsContentStreamingTest() throws Exception {
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        Reader reader = (Reader)Mockito.mock(Reader.class);
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"ClobColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)clob);
        Mockito.when((Object)clob.getCharacterStream()).thenReturn((Object)reader);
        Mockito.when((Object)reader.read()).thenReturn((Object)-1);
        Mockito.when((Object)reader.read((char[])Mockito.any(char[].class), Mockito.anyInt(), Mockito.anyInt())).thenReturn((Object)-1);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        DefaultDbConnection connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)false);
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)connection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("ClobColumn")) continue;
            InputStream is = (InputStream)((TypedValue)entry.getValue()).getValue();
            ((Clob)Mockito.verify((Object)clob, (VerificationMode)Mockito.times((int)1))).free();
        }
    }

    @Test
    public void consumeSQLXMLFreeResources() throws Exception {
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        SQLXML sqlxml = (SQLXML)Mockito.mock(SQLXML.class);
        InputStream sqlxmlIs = (InputStream)Mockito.mock(InputStream.class);
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"XMLColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)sqlxml);
        Mockito.when((Object)sqlxml.getBinaryStream()).thenReturn((Object)sqlxmlIs);
        Mockito.when((Object)sqlxmlIs.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        DefaultDbConnection connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)true);
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)connection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("XMLColumn")) continue;
            InputStream is = (InputStream)((TypedValue)entry.getValue()).getValue();
            is.read();
            ((SQLXML)Mockito.verify((Object)sqlxml, (VerificationMode)Mockito.times((int)1))).free();
        }
    }

    @Test
    public void consumeSQLXMLFreeResourcesNonSupportsContentStreamingTest() throws Exception {
        DatabaseMetaData metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        ResultSetMetaData resultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        SQLXML sqlxml = (SQLXML)Mockito.mock(SQLXML.class);
        InputStream sqlxmlIs = (InputStream)Mockito.mock(InputStream.class);
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)metadata.getDatabaseProductName()).thenReturn((Object)"DB2");
        Mockito.when((Object)resultSetMetaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(1)).thenReturn((Object)"IdColumn");
        Mockito.when((Object)this.resultSet.getObject(1)).thenReturn((Object)333);
        Mockito.when((Object)resultSetMetaData.getColumnLabel(2)).thenReturn((Object)"XMLColumn");
        Mockito.when((Object)this.resultSet.getObject(2)).thenReturn((Object)sqlxml);
        Mockito.when((Object)sqlxml.getBinaryStream()).thenReturn((Object)sqlxmlIs);
        Mockito.when((Object)sqlxmlIs.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.resultSet.getMetaData()).thenReturn((Object)resultSetMetaData);
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true).thenReturn((Object)false);
        DefaultDbConnection connection = (DefaultDbConnection)Mockito.mock(DefaultDbConnection.class);
        Mockito.when((Object)connection.supportsContentStreaming()).thenReturn((Object)false);
        InsensitiveMapRowHandler insensitiveMapRowHandler = new InsensitiveMapRowHandler((DbConnection)connection);
        Map result = insensitiveMapRowHandler.process(this.resultSet);
        Assert.assertFalse((boolean)result.isEmpty());
        for (Map.Entry entry : result.entrySet()) {
            if (!((String)entry.getKey()).equals("XMLColumn")) continue;
            String is = (String)((TypedValue)entry.getValue()).getValue();
            ((SQLXML)Mockito.verify((Object)sqlxml, (VerificationMode)Mockito.times((int)1))).free();
        }
    }

    private static class FakeClob
    implements Clob {
        private String str;

        private FakeClob() {
        }

        @Override
        public long length() throws SQLException {
            return 0L;
        }

        @Override
        public String getSubString(long pos, int length) throws SQLException {
            return null;
        }

        @Override
        public Reader getCharacterStream() throws SQLException {
            return new StringReader(this.str);
        }

        @Override
        public InputStream getAsciiStream() throws SQLException {
            return new ByteArrayInputStream(this.str.getBytes());
        }

        @Override
        public long position(String searchstr, long start) throws SQLException {
            return 0L;
        }

        @Override
        public long position(Clob searchstr, long start) throws SQLException {
            return 0L;
        }

        @Override
        public int setString(long pos, String str) throws SQLException {
            this.str = str;
            return 0;
        }

        @Override
        public int setString(long pos, String str, int offset, int len) throws SQLException {
            this.str = str;
            return 0;
        }

        @Override
        public OutputStream setAsciiStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public Writer setCharacterStream(long pos) throws SQLException {
            return null;
        }

        @Override
        public void truncate(long len) throws SQLException {
        }

        @Override
        public void free() throws SQLException {
        }

        @Override
        public Reader getCharacterStream(long pos, long length) throws SQLException {
            return null;
        }
    }
}

