/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.SelectStatementTypeDetector;

public class SelectStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        SelectStatementTypeDetector detector = new SelectStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
    }

    @Test
    public void validSelectStatementTest() {
        SelectStatementTypeDetector detector = new SelectStatementTypeDetector();
        List<String> selectStatements = Arrays.asList("SELECT A,B,C FROM MYTABLE;", "select a as b, c as d from mytable", " select * from othertable", "Select * myschema.myTable", "select * from my_table where");
        for (String statement : selectStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidSelectStatementTest() {
        SelectStatementTypeDetector detector = new SelectStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("DELETE FROM MY TABLE;", "MERGE FROM MYTABLE", "Insert into my table", "UPDATE delete from table", "INSERT INTO table2 \n SELECT * FROM table1 WHERE condition;", "DELETE FROM tableA\n WHERE ID IN \n ( SELECT q.ID\n FROM tableA q\n WHERE q.status=1 );");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

