/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.db.commons.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.runtime.extension.api.exception.ModuleException;

public class ResultSetIteratorTestCase {
    @Test
    public void oneRow() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        RowHandler rh = (RowHandler)Mockito.mock(RowHandler.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        HashMap map = new HashMap();
        Mockito.when((Object)rh.process((ResultSet)ArgumentMatchers.any())).thenReturn(map);
        ResultSetIterator rsi = new ResultSetIterator(rs, rh);
        Assert.assertTrue((boolean)rsi.hasNext());
        Assert.assertTrue((boolean)rsi.hasNext());
        Map returnedMap = rsi.next();
        Assert.assertSame(map, (Object)returnedMap);
        Assert.assertFalse((boolean)rsi.hasNext());
    }

    @Test
    public void empty() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        RowHandler rh = (RowHandler)Mockito.mock(RowHandler.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)false);
        ResultSetIterator rsi = new ResultSetIterator(rs, rh);
        Assert.assertFalse((boolean)rsi.hasNext());
    }

    @Test(expected=NoSuchElementException.class)
    public void pastEmpty() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        RowHandler rh = (RowHandler)Mockito.mock(RowHandler.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)false);
        ResultSetIterator rsi = new ResultSetIterator(rs, rh);
        Assert.assertFalse((boolean)rsi.hasNext());
        rsi.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void noElements() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        RowHandler rh = (RowHandler)Mockito.mock(RowHandler.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)false);
        ResultSetIterator rsi = new ResultSetIterator(rs, rh);
        rsi.next();
    }

    @Test(expected=ModuleException.class)
    public void rowHandlerFails() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenReturn((Object)true);
        RowHandler rh = (RowHandler)Mockito.mock(RowHandler.class);
        Mockito.when((Object)rh.process((ResultSet)ArgumentMatchers.any(ResultSet.class))).thenThrow(new Throwable[]{new SQLException("Some SQL exception")});
        ResultSetIterator rsi = new ResultSetIterator(rs, rh);
        rsi.next();
    }

    @Test(expected=ModuleException.class)
    public void innerHasNextFails() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)rs.next()).thenThrow(new Throwable[]{new SQLException("Some SQL exception")});
        RowHandler rh = (RowHandler)Mockito.mock(RowHandler.class);
        ResultSetIterator rsi = new ResultSetIterator(rs, rh);
        Assert.assertTrue((boolean)rsi.hasNext());
        Assert.assertTrue((boolean)rsi.hasNext());
        rsi.next();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeMustFail() {
        ResultSetIterator rsi = new ResultSetIterator((ResultSet)Mockito.mock(ResultSet.class), (RowHandler)Mockito.mock(RowHandler.class));
        rsi.remove();
    }
}

