/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.DeleteStatementTypeDetector;

public class DeleteStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        DeleteStatementTypeDetector detector = new DeleteStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.DELETE));
    }

    @Test
    public void validDeleteStatementTest() {
        DeleteStatementTypeDetector detector = new DeleteStatementTypeDetector();
        List<String> deleteStatements = Arrays.asList("DELETE FROM MYTABLE;", "delete from mytable", " delete from mytable", "Delete from myschema.myTable", "delete * from awesometable", "DELETE FROM tableA\n WHERE ID IN \n ( SELECT q.ID\n FROM tableA q\n WHERE q.status=1 );");
        for (String statement : deleteStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidDeleteStatementTest() {
        DeleteStatementTypeDetector detector = new DeleteStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("SELECT DELETE FROM MY TABLE;", "SELECT FROM MYTABLE", "UPDATE delete from table", "SELECT DELETE FROM MY TABLE");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

