/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.StatementTypeDetector;
import org.mule.db.commons.internal.parser.statement.detector.UnknownStatementTypeException;

public class StatementTypeDetectorTestCase {
    @Test
    public void validTypeTest() throws UnknownStatementTypeException {
        List<String> selectStatements = Arrays.asList(" Select name, surname from employees where last_name like 'ZDA%'", "SELECT * FROM COUNTRY", "Select * FROM MYTABLE");
        StatementTypeDetector detector = new StatementTypeDetector();
        for (String statement : selectStatements) {
            MatcherAssert.assertThat((Object)detector.detect(statement), (Matcher)CoreMatchers.equalTo((Object)QueryType.SELECT));
        }
    }

    @Test(expected=UnknownStatementTypeException.class)
    public void invalidTypeTest() throws UnknownStatementTypeException {
        StatementTypeDetector detector = new StatementTypeDetector();
        detector.detect("THISISANINVALIDSTATEMENT");
    }
}

