/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.parser.QueryTemplateParsingException;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SimpleQueryTemplateParserTestCase
extends AbstractMuleTestCase {
    private final SimpleQueryTemplateParser parser = new SimpleQueryTemplateParser();

    @Test
    public void detectsSelect() throws Exception {
        this.doKeywordParsingTest("SELECT", QueryType.SELECT);
        this.doKeywordParsingTest("Select", QueryType.SELECT);
        this.doKeywordParsingTest("select", QueryType.SELECT);
    }

    @Test
    public void detectsUpdate() throws Exception {
        this.doKeywordParsingTest("UPDATE", QueryType.UPDATE);
        this.doKeywordParsingTest("Update", QueryType.UPDATE);
        this.doKeywordParsingTest("update", QueryType.UPDATE);
    }

    @Test
    public void detectsInsert() throws Exception {
        this.doKeywordParsingTest("INSERT", QueryType.INSERT);
        this.doKeywordParsingTest("Insert", QueryType.INSERT);
        this.doKeywordParsingTest("insert", QueryType.INSERT);
    }

    @Test
    public void detectsInsertWithLineBreak() throws Exception {
        String sql = "INSERT INTO PLANET(\nPOSITION, NAME) VALUES (777, 'Mercury')";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.INSERT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsDelete() throws Exception {
        this.doKeywordParsingTest("DELETE", QueryType.DELETE);
        this.doKeywordParsingTest("Delete", QueryType.DELETE);
        this.doKeywordParsingTest("delete", QueryType.DELETE);
    }

    @Test
    public void detectsDdl() throws Exception {
        this.doKeywordParsingTest("DROP", QueryType.DDL);
        this.doKeywordParsingTest("Drop", QueryType.DDL);
        this.doKeywordParsingTest("drop", QueryType.DDL);
    }

    @Test
    public void detectsTruncate() throws Exception {
        this.doKeywordParsingTest("TRUNCATE TABLE", QueryType.TRUNCATE);
        this.doKeywordParsingTest("Truncate table", QueryType.TRUNCATE);
        this.doKeywordParsingTest("truncate table", QueryType.TRUNCATE);
    }

    @Test
    public void detectsMerge() throws Exception {
        this.doKeywordParsingTest("MERGE", QueryType.MERGE);
        this.doKeywordParsingTest("Merge", QueryType.MERGE);
        this.doKeywordParsingTest("merge", QueryType.MERGE);
    }

    @Test
    public void detectsWith() throws Exception {
        this.doKeywordParsingTest("WITH", QueryType.SELECT);
        this.doKeywordParsingTest("With", QueryType.SELECT);
        this.doKeywordParsingTest("with", QueryType.SELECT);
    }

    @Test
    public void detectDoubleColon() throws Exception {
        String sql = "SELECT MAX(modified_date)::DATE FROM test";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    private void doKeywordParsingTest(String keyword, QueryType expectedQueryType) {
        this.doSqlParsingTest(expectedQueryType, keyword + " some unused SQL");
        this.doSqlParsingTest(expectedQueryType, keyword + "\nsome\nunused\nSQL");
    }

    private void doSqlParsingTest(QueryType expectedQueryType, String sql) {
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)expectedQueryType, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsStoredProcedureWithBrackets() throws Exception {
        this.doStoredProcedureParsingTest("{ call getTestRecords() }");
    }

    @Test
    public void detectsStoredProcedureWithOutBrackets() throws Exception {
        this.doStoredProcedureParsingTest("call getTestRecords()");
    }

    @Test
    public void detectsStoredProcedureWithSpaces() throws Exception {
        this.doStoredProcedureParsingTest("  {  call  getTestRecords()  } ");
    }

    @Test
    public void detectsStoredProcedureWithLineBreak() throws Exception {
        this.doStoredProcedureParsingTest("{ call \ngetTestRecords() } ");
    }

    @Test
    public void detectsStoredProcedureAssignment() throws Exception {
        String sql = "{ :out = call getTestRecords() } ";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertThat((Object)queryTemplate.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.STORE_PROCEDURE_CALL));
        Assert.assertThat((Object)queryTemplate.getSqlText(), (Matcher)CoreMatchers.equalTo((Object)"{ ? = call getTestRecords() }"));
        Assert.assertThat((Object)queryTemplate.getParams().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        QueryParam param1 = (QueryParam)queryTemplate.getParams().get(0);
        Assert.assertThat((Object)param1.getName(), (Matcher)CoreMatchers.equalTo((Object)"out"));
        Assert.assertThat((Object)param1.getType(), (Matcher)CoreMatchers.equalTo((Object)UnknownDbType.getInstance()));
    }

    @Test
    public void detectsMissingOutParamStoredProcedureAssignmentAsDdl() throws Exception {
        this.doIncompleteStoredProcedureAssingmentTest("{  = call getTestRecords() } ");
    }

    @Test
    public void detectsMissingParamNameStoredProcedureAssignmentAsDdl() throws Exception {
        this.doIncompleteStoredProcedureAssingmentTest("{ : = call getTestRecords() } ");
    }

    @Test
    public void detectsMissingParamEscapingStoredProcedureAssignmentAsDdl() throws Exception {
        this.doIncompleteStoredProcedureAssingmentTest("{ a = call getTestRecords() } ");
    }

    private void doIncompleteStoredProcedureAssingmentTest(String sql) {
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertThat((Object)queryTemplate.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.DDL));
    }

    @Test
    public void detectsStoredProcedureWithoutSpaceAfterBracket() throws Exception {
        this.doStoredProcedureParsingTest("{call getTestRecords() } ");
    }

    private void doStoredProcedureParsingTest(String sql) {
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.STORE_PROCEDURE_CALL, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql.trim(), (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void parsesQuestionMarkParam() throws Exception {
        String sql = "SELECT * FROM PLANET WHERE POSITION = ?";
        QueryTemplate queryTemplate = this.parser.parse(sql);
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)sql, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
    }

    @Test
    public void parsesNamedParam() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("update PLANET set NAME='Mercury' where ID= :planetId");
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"update PLANET set NAME='Mercury' where ID= ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertEquals((Object)"planetId", (Object)param1.getName());
        Assert.assertNull((Object)param1.getValue());
    }

    @Test
    public void definesTemplateWithExpressionParam() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("update PLANET set NAME='Mercury' where ID= #[mel:planetId]");
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"update PLANET set NAME='Mercury' where ID= ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)1L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertNull((Object)param1.getName());
        Assert.assertEquals((Object)"#[mel:planetId]", (Object)param1.getValue());
    }

    @Test
    public void definesTemplateWithComplexExpressionParam() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("SELECT * FROM PLANET WHERE POSITION = #[mel:message.inboundProperties['position']] AND NAME= #[mel:planetName]");
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT * FROM PLANET WHERE POSITION = ? AND NAME= ?", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)2L, (long)queryTemplate.getInputParams().size());
        InputQueryParam param1 = (InputQueryParam)queryTemplate.getInputParams().get(0);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param1.getType());
        Assert.assertNull((Object)param1.getName());
        Assert.assertEquals((Object)"#[mel:message.inboundProperties['position']]", (Object)param1.getValue());
        InputQueryParam param2 = (InputQueryParam)queryTemplate.getInputParams().get(1);
        Assert.assertEquals((Object)UnknownDbType.getInstance(), (Object)param2.getType());
        Assert.assertNull((Object)param2.getName());
        Assert.assertEquals((Object)"#[mel:planetName]", (Object)param2.getValue());
    }

    @Test
    public void definesTemplateWithEscapedColon() throws Exception {
        QueryTemplate queryTemplate = this.parser.parse("SELECT somecolumn\\:\\:money\\:\\:numeric\\:\\:float8 FROM sometable");
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)"SELECT somecolumn::money::numeric::float8 FROM sometable", (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }

    @Test
    public void detectsUnterminatedMuleExpression() throws Exception {
        try {
            this.parser.parse("SELECT * FROM PLANET where id = #[mel:incompleteExpression");
            Assert.fail((String)"Did not detect an unfinished mule expression");
        }
        catch (QueryTemplateParsingException e) {
            Assert.assertTrue((String)"Error message did not contains invalid expression", (boolean)e.getMessage().endsWith("#[mel:incompleteExpression"));
        }
    }

    @Test
    public void parseSQLVariableAssignment() throws Exception {
        String query = "SELECT @rowNumber := @rowNumber + 1 AS ROWNUMBER, P.* FROM (SELECT * FROM PLANET) P, (SELECT @rowNumber := 0) RN ORDER BY P.NAME";
        QueryTemplate queryTemplate = this.parser.parse(query);
        Assert.assertEquals((Object)QueryType.SELECT, (Object)queryTemplate.getType());
        Assert.assertEquals((Object)query, (Object)queryTemplate.getSqlText());
        Assert.assertEquals((long)0L, (long)queryTemplate.getInputParams().size());
    }
}

