/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import com.github.benmanes.caffeine.cache.Policy;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.api.config.DbPoolingProfile;
import org.mule.db.commons.internal.domain.connection.DataSourceConfig;
import org.mule.db.commons.internal.domain.connection.DbConnectionProvider;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.InitialisationException;

public class DbConnectionProviderTest {
    @Test
    public void testConstructorWithFourParameters() {
        String configName = "testConfig";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        List columnTypes = Collections.emptyList();
        DbConnectionProvider provider = new DbConnectionProvider(configName, registry, poolingProfile, columnTypes){

            public Optional<DataSource> getDataSource() {
                return Optional.empty();
            }

            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.empty();
            }
        };
        MatcherAssert.assertThat((Object)provider, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testConstructorWithFiveParameters() {
        String configName = "testConfig";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        List columnTypes = Collections.emptyList();
        long cacheQueryTemplateSize = 100L;
        DbConnectionProvider provider = new DbConnectionProvider(configName, registry, poolingProfile, columnTypes, cacheQueryTemplateSize){

            public Optional<DataSource> getDataSource() {
                return Optional.empty();
            }

            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.empty();
            }
        };
        MatcherAssert.assertThat((Object)provider, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void testConstructorWithFiveParametersSetsCacheSize() throws InitialisationException {
        String configName = "testConfig";
        Registry registry = (Registry)Mockito.mock(Registry.class);
        DbPoolingProfile poolingProfile = (DbPoolingProfile)Mockito.mock(DbPoolingProfile.class);
        List columnTypes = Collections.emptyList();
        long cacheQueryTemplateSize = 100L;
        final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        DbConnectionProvider provider = new DbConnectionProvider(configName, registry, poolingProfile, columnTypes, cacheQueryTemplateSize){

            public Optional<DataSource> getDataSource() {
                return Optional.of(dataSource);
            }

            public Optional<DataSourceConfig> getDataSourceConfig() {
                return Optional.empty();
            }
        };
        provider.initialise();
        MatcherAssert.assertThat((Object)((Policy.Eviction)provider.cachedTemplates.policy().eviction().get()).getMaximum(), (Matcher)Matchers.is((Object)cacheQueryTemplateSize));
    }
}

