/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.api.param;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.api.param.StatementDefinition;
import org.mule.db.commons.api.param.TypeClassifier;

@RunWith(value=MockitoJUnitRunner.class)
public class StatementDefinitionTestCase {
    private TestStatementDefinition statementDefinition;

    @Before
    public void setUp() {
        this.statementDefinition = new TestStatementDefinition();
    }

    @Test
    public void testDefaultConstructor() {
        TestStatementDefinition def = new TestStatementDefinition();
        Assert.assertNotNull((Object)((Object)def));
        Assert.assertEquals((long)0L, (long)def.getQueryTimeout());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)def.getQueryTimeoutUnit()));
        Assert.assertTrue((boolean)def.getParameterTypes().isEmpty());
    }

    @Test
    public void testParameterizedConstructor() {
        String sql = "SELECT * FROM test_table";
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("param1", new TypeClassifier(JdbcType.VARCHAR, null)), new ParameterType("param2", new TypeClassifier(JdbcType.INTEGER, null)));
        int queryTimeout = 30;
        TimeUnit queryTimeoutUnit = TimeUnit.MINUTES;
        Integer fetchSize = 100;
        Integer maxRows = 1000;
        TestStatementDefinition def = new TestStatementDefinition(sql, parameterTypes, queryTimeout, queryTimeoutUnit, fetchSize, maxRows);
        Assert.assertEquals((Object)sql, (Object)def.getSql());
        Assert.assertEquals(parameterTypes, (Object)def.getParameterTypes());
        Assert.assertEquals((long)queryTimeout, (long)def.getQueryTimeout());
        Assert.assertEquals((Object)((Object)queryTimeoutUnit), (Object)((Object)def.getQueryTimeoutUnit()));
        Assert.assertEquals((Object)fetchSize, (Object)def.getFetchSize());
        Assert.assertEquals((Object)maxRows, (Object)def.getMaxRows());
    }

    @Test
    public void testSetAndGetSql() {
        String sql = "INSERT INTO test_table (id, name) VALUES (1, 'test')";
        this.statementDefinition.setSql(sql);
        Assert.assertEquals((Object)sql, (Object)this.statementDefinition.getSql());
    }

    @Test
    public void testSetAndGetSqlWithNull() {
        this.statementDefinition.setSql(null);
        Assert.assertEquals(null, (Object)this.statementDefinition.getSql());
    }

    @Test
    public void testSetAndGetSqlWithEmptyString() {
        this.statementDefinition.setSql("");
        Assert.assertEquals((Object)"", (Object)this.statementDefinition.getSql());
    }

    @Test
    public void testGetParameterTypes() {
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("param1", new TypeClassifier(JdbcType.VARCHAR, null)), new ParameterType("param2", new TypeClassifier(JdbcType.INTEGER, null)));
        this.statementDefinition.setParameterTypes(parameterTypes);
        Assert.assertEquals(parameterTypes, (Object)this.statementDefinition.getParameterTypes());
    }

    @Test
    public void testGetParameterTypesWhenEmpty() {
        Assert.assertTrue((boolean)this.statementDefinition.getParameterTypes().isEmpty());
    }

    @Test
    public void testGetParameterTypeWithExistingParameter() {
        ParameterType param1 = new ParameterType("param1", new TypeClassifier(JdbcType.VARCHAR, null));
        ParameterType param2 = new ParameterType("param2", new TypeClassifier(JdbcType.INTEGER, null));
        List<ParameterType> parameterTypes = Arrays.asList(param1, param2);
        this.statementDefinition.setParameterTypes(parameterTypes);
        Optional result = this.statementDefinition.getParameterType("param1");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)param1, result.get());
    }

    @Test
    public void testGetParameterTypeWithNonExistingParameter() {
        ParameterType param1 = new ParameterType("param1", new TypeClassifier(JdbcType.VARCHAR, null));
        List<ParameterType> parameterTypes = Arrays.asList(param1);
        this.statementDefinition.setParameterTypes(parameterTypes);
        Optional result = this.statementDefinition.getParameterType("nonExistingParam");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetParameterTypeWithEmptyParameterTypes() {
        Optional result = this.statementDefinition.getParameterType("anyParam");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetParameterTypeWithNullParameterName() {
        ParameterType param1 = new ParameterType("param1", new TypeClassifier(JdbcType.VARCHAR, null));
        List<ParameterType> parameterTypes = Arrays.asList(param1);
        this.statementDefinition.setParameterTypes(parameterTypes);
        Optional result = this.statementDefinition.getParameterType(null);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetParameterTypeWithEmptyParameterName() {
        ParameterType param1 = new ParameterType("param1", new TypeClassifier(JdbcType.VARCHAR, null));
        List<ParameterType> parameterTypes = Arrays.asList(param1);
        this.statementDefinition.setParameterTypes(parameterTypes);
        Optional result = this.statementDefinition.getParameterType("");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCopy() {
        String sql = "SELECT * FROM test_table WHERE id = :id";
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("id", new TypeClassifier(JdbcType.INTEGER, null)));
        int queryTimeout = 60;
        TimeUnit queryTimeoutUnit = TimeUnit.SECONDS;
        Integer fetchSize = 50;
        Integer maxRows = 500;
        TestStatementDefinition original = new TestStatementDefinition(sql, parameterTypes, queryTimeout, queryTimeoutUnit, fetchSize, maxRows);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertTrue((copy != original ? 1 : 0) != 0);
        Assert.assertEquals((Object)original.getSql(), (Object)copy.getSql());
        Assert.assertEquals((Object)original.getParameterTypes(), (Object)copy.getParameterTypes());
        Assert.assertEquals((long)original.getQueryTimeout(), (long)copy.getQueryTimeout());
        Assert.assertEquals((Object)((Object)original.getQueryTimeoutUnit()), (Object)((Object)copy.getQueryTimeoutUnit()));
        Assert.assertEquals((Object)original.getFetchSize(), (Object)copy.getFetchSize());
        Assert.assertEquals((Object)original.getMaxRows(), (Object)copy.getMaxRows());
    }

    @Test
    public void testCopyWithEmptyParameterTypes() {
        String sql = "SELECT * FROM test_table";
        TestStatementDefinition original = new TestStatementDefinition(sql, new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertTrue((boolean)copy.getParameterTypes().isEmpty());
        Assert.assertEquals((Object)original.getSql(), (Object)copy.getSql());
    }

    @Test
    public void testCopyWithNullSql() {
        TestStatementDefinition original = new TestStatementDefinition(null, new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals(null, (Object)copy.getSql());
    }

    @Test
    public void testCopyWithNullFetchSizeAndMaxRows() {
        TestStatementDefinition original = new TestStatementDefinition("SELECT * FROM test", new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, null, null);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals(null, (Object)copy.getFetchSize());
        Assert.assertEquals(null, (Object)copy.getMaxRows());
    }

    @Test
    public void testCopyWithComplexParameterTypes() {
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("stringParam", new TypeClassifier(JdbcType.VARCHAR, null)), new ParameterType("intParam", new TypeClassifier(JdbcType.INTEGER, null)), new ParameterType("doubleParam", new TypeClassifier(JdbcType.DOUBLE, null)), new ParameterType("dateParam", new TypeClassifier(JdbcType.DATE, null)), new ParameterType("customParam", new TypeClassifier(null, "CUSTOM_TYPE")));
        TestStatementDefinition original = new TestStatementDefinition("SELECT * FROM test", parameterTypes, 45, TimeUnit.SECONDS, 200, 2000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((long)parameterTypes.size(), (long)copy.getParameterTypes().size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            ParameterType originalParam = parameterTypes.get(i);
            ParameterType copyParam = (ParameterType)copy.getParameterTypes().get(i);
            Assert.assertEquals((Object)originalParam.getKey(), (Object)copyParam.getKey());
            Assert.assertEquals((Object)originalParam.getDbType().getName(), (Object)copyParam.getDbType().getName());
        }
    }

    @Test
    public void testCopyWithSpecialCharactersInSql() {
        String sqlWithSpecialChars = "SELECT * FROM `test-table` WHERE `column-name` = 'value with \"quotes\"' AND `another-column` = 'value with ''single quotes'''";
        TestStatementDefinition original = new TestStatementDefinition(sqlWithSpecialChars, new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((Object)sqlWithSpecialChars, (Object)copy.getSql());
    }

    @Test
    public void testCopyWithUnicodeCharactersInSql() {
        String sqlWithUnicode = "SELECT * FROM test_table WHERE name = 'Jos\u00e9 Mar\u00eda' AND description = 'Caf\u00e9 con leche'";
        TestStatementDefinition original = new TestStatementDefinition(sqlWithUnicode, new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((Object)sqlWithUnicode, (Object)copy.getSql());
    }

    @Test
    public void testCopyWithVeryLongSql() {
        StringBuilder longSql = new StringBuilder("SELECT ");
        for (int i = 1; i <= 100; ++i) {
            longSql.append("column").append(i);
            if (i >= 100) continue;
            longSql.append(", ");
        }
        longSql.append(" FROM very_large_table WHERE condition1 = 'value1' AND condition2 = 'value2' AND condition3 = 'value3'");
        TestStatementDefinition original = new TestStatementDefinition(longSql.toString(), new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((Object)longSql.toString(), (Object)copy.getSql());
    }

    @Test
    public void testCopyWithParameterTypesHavingNullValues() {
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("nullKey", null), new ParameterType(null, new TypeClassifier(JdbcType.VARCHAR, null)));
        TestStatementDefinition original = new TestStatementDefinition("SELECT * FROM test", parameterTypes, 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((long)parameterTypes.size(), (long)copy.getParameterTypes().size());
    }

    @Test
    public void testCopyWithDuplicateParameterNames() {
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("duplicate", new TypeClassifier(JdbcType.VARCHAR, null)), new ParameterType("duplicate", new TypeClassifier(JdbcType.INTEGER, null)));
        TestStatementDefinition original = new TestStatementDefinition("SELECT * FROM test", parameterTypes, 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((long)parameterTypes.size(), (long)copy.getParameterTypes().size());
    }

    @Test
    public void testCopyWithEmptyParameterKeys() {
        List<ParameterType> parameterTypes = Arrays.asList(new ParameterType("", new TypeClassifier(JdbcType.VARCHAR, null)), new ParameterType("   ", new TypeClassifier(JdbcType.INTEGER, null)));
        TestStatementDefinition original = new TestStatementDefinition("SELECT * FROM test", parameterTypes, 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        Assert.assertNotNull((Object)((Object)copy));
        Assert.assertEquals((long)parameterTypes.size(), (long)copy.getParameterTypes().size());
    }

    @Test
    public void testCopyWithModificationAfterCopy() {
        String originalSql = "SELECT * FROM original_table";
        String copySql = "SELECT * FROM copy_table";
        TestStatementDefinition original = new TestStatementDefinition(originalSql, new ArrayList<ParameterType>(), 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        original.setSql(copySql);
        Assert.assertEquals((Object)originalSql, (Object)copy.getSql());
        Assert.assertEquals((Object)copySql, (Object)original.getSql());
    }

    @Test
    public void testCopyWithParameterTypesModificationAfterCopy() {
        ParameterType originalParam = new ParameterType("original", new TypeClassifier(JdbcType.VARCHAR, null));
        ParameterType copyParam = new ParameterType("copy", new TypeClassifier(JdbcType.INTEGER, null));
        ArrayList<ParameterType> originalParams = new ArrayList<ParameterType>();
        originalParams.add(originalParam);
        TestStatementDefinition original = new TestStatementDefinition("SELECT * FROM test", originalParams, 30, TimeUnit.SECONDS, 100, 1000);
        TestStatementDefinition copy = original.copy();
        originalParams.clear();
        originalParams.add(copyParam);
        Assert.assertEquals((long)1L, (long)copy.getParameterTypes().size());
        Assert.assertEquals((Object)originalParam, copy.getParameterTypes().get(0));
        Assert.assertEquals((long)1L, (long)original.getParameterTypes().size());
        Assert.assertEquals((Object)copyParam, original.getParameterTypes().get(0));
    }

    private static class TestStatementDefinition
    extends StatementDefinition<TestStatementDefinition> {
        public TestStatementDefinition() {
        }

        public TestStatementDefinition(String sql, List<ParameterType> parameterTypes, int queryTimeout, TimeUnit queryTimeoutUnit, Integer fetchSize, Integer maxRows) {
            super(sql, parameterTypes, queryTimeout, queryTimeoutUnit, fetchSize, maxRows);
        }

        protected TestStatementDefinition copy() {
            return (TestStatementDefinition)super.copy();
        }

        public void setParameterTypes(List<ParameterType> parameterTypes) {
            try {
                Field field = StatementDefinition.class.getDeclaredField("parameterTypes");
                field.setAccessible(true);
                field.set((Object)this, parameterTypes != null ? new ArrayList<ParameterType>(parameterTypes) : new ArrayList());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to set parameter types for testing", e);
            }
        }
    }
}

