/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.QueryTemplateParsingException;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;

@RunWith(value=MockitoJUnitRunner.class)
public class SimpleQueryTemplateParserTestCase {
    private SimpleQueryTemplateParser parser;

    @Before
    public void setUp() {
        this.parser = new SimpleQueryTemplateParser();
    }

    @Test
    public void testParseSimpleSelectQuery() {
        String sql = "SELECT * FROM users WHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseSimpleInsertQuery() {
        String sql = "INSERT INTO users (name, email) VALUES (:name, :email)";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"INSERT INTO users (name, email) VALUES (?, ?)", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.INSERT, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"email", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseSimpleUpdateQuery() {
        String sql = "UPDATE users SET name = :name WHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"UPDATE users SET name = ? WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.UPDATE, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseSimpleDeleteQuery() {
        String sql = "DELETE FROM users WHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"DELETE FROM users WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DELETE, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithNoParameters() {
        String sql = "SELECT * FROM users";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)sql, (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertTrue((boolean)result.getInputParams().isEmpty());
    }

    @Test
    public void testParseQueryWithMultipleParameters() {
        String sql = "SELECT * FROM users WHERE name = :name AND age > :age AND city = :city";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE name = ? AND age > ? AND city = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)3L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"age", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
        Assert.assertEquals((Object)"city", (Object)((InputQueryParam)result.getInputParams().get(2)).getName());
    }

    @Test
    public void testParseQueryWithDuplicateParameters() {
        String sql = "SELECT * FROM users WHERE name = :name OR nickname = :name";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE name = ? OR nickname = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseQueryWithComplexParameterNames() {
        String sql = "SELECT * FROM users WHERE user_id = :user_id AND user_name = :user_name";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE user_id = ? AND user_name = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"user_id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"user_name", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseQueryWithNumbersInParameterNames() {
        String sql = "SELECT * FROM users WHERE id1 = :id1 AND id2 = :id2";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id1 = ? AND id2 = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id1", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"id2", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseQueryWithUnderscoresInParameterNames() {
        String sql = "SELECT * FROM users WHERE first_name = :first_name AND last_name = :last_name";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE first_name = ? AND last_name = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"first_name", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"last_name", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseQueryWithMixedCase() {
        String sql = "SeLeCt * FrOm UsErS WhErE Id = :Id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SeLeCt * FrOm UsErS WhErE Id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"Id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithWhitespace() {
        String sql = "  SELECT  *  FROM  users  WHERE  id  =  :id  ";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT  *  FROM  users  WHERE  id  =  ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithNewlines() {
        String sql = "SELECT *\nFROM users\nWHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT *\nFROM users\nWHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithTabs() {
        String sql = "SELECT *\tFROM users\tWHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT *\tFROM users\tWHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithComments() {
        String sql = "SELECT * FROM users -- This is a comment\nWHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users -- This is a comment\nWHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithStringLiterals() {
        String sql = "SELECT * FROM users WHERE name = 'John' AND id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE name = 'John' AND id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithStringLiteralsContainingColons() {
        String sql = "SELECT * FROM users WHERE description = 'This is a test: value' AND id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE description = 'This is a test: value' AND id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithEscapedQuotes() {
        String sql = "SELECT * FROM users WHERE description = 'This is a ''quoted'' string' AND id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE description = 'This is a ''quoted'' string' AND id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithDoubleQuotes() {
        String sql = "SELECT * FROM \"users\" WHERE \"id\" = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM \"users\" WHERE \"id\" = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithBackticks() {
        String sql = "SELECT * FROM `users` WHERE `id` = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM `users` WHERE `id` = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithBrackets() {
        String sql = "SELECT * FROM [users] WHERE [id] = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM [users] WHERE [id] = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithStoredProcedure() {
        String sql = "CALL get_user(:id)";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"CALL get_user(?)", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.STORE_PROCEDURE_CALL, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithExecuteStoredProcedure() {
        String sql = "EXECUTE get_user(:id)";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"EXECUTE get_user(?)", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DDL, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithExecStoredProcedure() {
        String sql = "EXEC get_user(:id)";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"EXEC get_user(?)", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DDL, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithMerge() {
        String sql = "MERGE INTO users USING (SELECT :id as id, :name as name) AS source ON users.id = source.id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"MERGE INTO users USING (SELECT ? as id, ? as name) AS source ON users.id = source.id", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.MERGE, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseQueryWithTruncate() {
        String sql = "TRUNCATE TABLE users";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)sql, (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.TRUNCATE, (Object)result.getType());
        Assert.assertTrue((boolean)result.getInputParams().isEmpty());
    }

    @Test
    public void testParseQueryWithDDL() {
        String sql = "CREATE TABLE users (id INT PRIMARY KEY, name VARCHAR(100))";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)sql, (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DDL, (Object)result.getType());
        Assert.assertTrue((boolean)result.getInputParams().isEmpty());
    }

    @Test
    public void testParseQueryWithAlterTable() {
        String sql = "ALTER TABLE users ADD COLUMN email VARCHAR(100)";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)sql, (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DDL, (Object)result.getType());
        Assert.assertTrue((boolean)result.getInputParams().isEmpty());
    }

    @Test
    public void testParseQueryWithDropTable() {
        String sql = "DROP TABLE users";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)sql, (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DDL, (Object)result.getType());
        Assert.assertTrue((boolean)result.getInputParams().isEmpty());
    }

    @Test
    public void testParseQueryWithWithClause() {
        String sql = "WITH temp_table AS (SELECT * FROM users WHERE id = :id) SELECT * FROM temp_table";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"WITH temp_table AS (SELECT * FROM users WHERE id = ?) SELECT * FROM temp_table", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithUnion() {
        String sql = "SELECT * FROM users WHERE id = :id UNION SELECT * FROM users_backup WHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id = ? UNION SELECT * FROM users_backup WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)2L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
    }

    @Test
    public void testParseQueryWithSubquery() {
        String sql = "SELECT * FROM users WHERE id IN (SELECT user_id FROM orders WHERE order_id = :order_id)";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id IN (SELECT user_id FROM orders WHERE order_id = ?)", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"order_id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithCaseStatement() {
        String sql = "SELECT CASE WHEN id = :id THEN 'match' ELSE 'no match' END FROM users";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT CASE WHEN id = ? THEN 'match' ELSE 'no match' END FROM users", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithNullSql() {
        Assert.assertThrows(NullPointerException.class, () -> this.parser.parse(null));
    }

    @Test
    public void testParseQueryWithEmptySql() {
        String sql = "";
        Assert.assertThrows(QueryTemplateParsingException.class, () -> this.parser.parse(sql));
    }

    @Test
    public void testParseQueryWithWhitespaceOnlySql() {
        String sql = "   ";
        Assert.assertThrows(QueryTemplateParsingException.class, () -> this.parser.parse(sql));
    }

    @Test
    public void testParseQueryWithInvalidSql() {
        String sql = "INVALID SQL STATEMENT";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)sql, (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.DDL, (Object)result.getType());
        Assert.assertTrue((boolean)result.getInputParams().isEmpty());
    }

    @Test
    public void testParseQueryWithParameterAtEnd() {
        String sql = "SELECT * FROM users WHERE id = :id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithParameterAtBeginning() {
        String sql = "SELECT * FROM users WHERE :id = id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE ? = id", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithParameterInMiddle() {
        String sql = "SELECT * FROM users WHERE name = :name AND id = :id AND email = :email";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE name = ? AND id = ? AND email = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)3L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"name", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
        Assert.assertEquals((Object)"id", (Object)((InputQueryParam)result.getInputParams().get(1)).getName());
        Assert.assertEquals((Object)"email", (Object)((InputQueryParam)result.getInputParams().get(2)).getName());
    }

    @Test
    public void testParseQueryWithSpecialCharactersInParameterName() {
        String sql = "SELECT * FROM users WHERE id = :id_123";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"id_123", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithParameterNameStartingWithNumber() {
        String sql = "SELECT * FROM users WHERE id = :1id";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"1id", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }

    @Test
    public void testParseQueryWithParameterNameContainingOnlyNumbers() {
        String sql = "SELECT * FROM users WHERE id = :123";
        QueryTemplate result = this.parser.parse(sql);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"SELECT * FROM users WHERE id = ?", (Object)result.getSqlText());
        Assert.assertEquals((Object)QueryType.SELECT, (Object)result.getType());
        Assert.assertEquals((long)1L, (long)result.getInputParams().size());
        Assert.assertEquals((Object)"123", (Object)((InputQueryParam)result.getInputParams().get(0)).getName());
    }
}

