/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.resultset.ListResultSetHandler;
import org.mule.db.commons.internal.result.row.RowHandler;

@RunWith(value=MockitoJUnitRunner.class)
public class ListResultSetHandlerTest {
    @Mock
    private RowHandler mockRowHandler;
    @Mock
    private DbConnection mockConnection;
    @Mock
    private ResultSet mockResultSet;
    private ListResultSetHandler handler;

    @Before
    public void setUp() {
        this.handler = new ListResultSetHandler(this.mockRowHandler);
    }

    @Test
    public void testConstructorWithDefaultCharset() {
        ListResultSetHandler handler = new ListResultSetHandler(this.mockRowHandler);
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)handler.getCharset());
    }

    @Test
    public void testConstructorWithCustomCharset() {
        Charset customCharset = StandardCharsets.UTF_8;
        ListResultSetHandler handler = new ListResultSetHandler(this.mockRowHandler, customCharset);
        Assert.assertEquals((Object)customCharset, (Object)handler.getCharset());
    }

    @Test
    public void testProcessResultSetWithEmptyResultSet() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)false);
        List result = this.handler.processResultSet(this.mockConnection, this.mockResultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isEmpty());
        ((ResultSet)Mockito.verify((Object)this.mockResultSet)).close();
    }

    @Test
    public void testProcessResultSetWithSingleRow() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        HashMap<String, Object> expectedRow = new HashMap<String, Object>();
        expectedRow.put("id", 1);
        expectedRow.put("name", "test");
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenReturn(expectedRow);
        List result = this.handler.processResultSet(this.mockConnection, this.mockResultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals(expectedRow, result.get(0));
        ((ResultSet)Mockito.verify((Object)this.mockResultSet)).close();
    }

    @Test
    public void testProcessResultSetWithMultipleRows() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        HashMap<String, Object> row1 = new HashMap<String, Object>();
        row1.put("id", 1);
        row1.put("name", "test1");
        HashMap<String, Object> row2 = new HashMap<String, Object>();
        row2.put("id", 2);
        row2.put("name", "test2");
        HashMap<String, Object> row3 = new HashMap<String, Object>();
        row3.put("id", 3);
        row3.put("name", "test3");
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenReturn(row1, (Object[])new Map[]{row2, row3});
        List result = this.handler.processResultSet(this.mockConnection, this.mockResultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals(row1, result.get(0));
        Assert.assertEquals(row2, result.get(1));
        Assert.assertEquals(row3, result.get(2));
        ((ResultSet)Mockito.verify((Object)this.mockResultSet)).close();
    }

    @Test
    public void testProcessResultSetWithSQLException() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenThrow(new Throwable[]{new SQLException("Database error")});
        try {
            this.handler.processResultSet(this.mockConnection, this.mockResultSet);
            Assert.fail((String)"Should have thrown SQLException");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Database error", (Object)e.getMessage());
        }
        ((ResultSet)Mockito.verify((Object)this.mockResultSet)).close();
    }

    @Test
    public void testProcessResultSetWithRowHandlerException() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenThrow(new Throwable[]{new SQLException("Processing error")});
        try {
            this.handler.processResultSet(this.mockConnection, this.mockResultSet);
            Assert.fail((String)"Should have thrown SQLException");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Processing error", (Object)e.getMessage());
        }
        ((ResultSet)Mockito.verify((Object)this.mockResultSet)).close();
    }

    @Test
    public void testRequiresMultipleOpenedResults() {
        Assert.assertFalse((boolean)this.handler.requiresMultipleOpenedResults());
    }

    @Test
    public void testGetCharset() {
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)this.handler.getCharset());
    }

    @Test
    public void testGetCharsetWithCustomCharset() {
        Charset customCharset = StandardCharsets.ISO_8859_1;
        ListResultSetHandler customHandler = new ListResultSetHandler(this.mockRowHandler, customCharset);
        Assert.assertEquals((Object)customCharset, (Object)customHandler.getCharset());
    }

    @Test
    public void testResultSetClosedEvenOnException() throws SQLException {
        Mockito.when((Object)this.mockResultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)this.mockRowHandler.process(this.mockResultSet)).thenThrow(new Throwable[]{new RuntimeException("Unexpected error")});
        try {
            this.handler.processResultSet(this.mockConnection, this.mockResultSet);
            Assert.fail((String)"Should have thrown RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Unexpected error", (Object)e.getMessage());
        }
        ((ResultSet)Mockito.verify((Object)this.mockResultSet)).close();
    }
}

