/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.sql.Statement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.GenericStatementResultIteratorFactory;
import org.mule.db.commons.internal.result.statement.StatementResultIterator;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GenericStatementResultIteratorFactoryTestCase
extends AbstractMuleTestCase {
    private GenericStatementResultIteratorFactory factory;
    private ResultSetHandler mockResultSetHandler;
    private DbConnection mockConnection;
    private Statement mockStatement;
    private QueryTemplate mockQueryTemplate;
    private AutoGenerateKeysStrategy mockAutoGenerateKeysStrategy;

    @Before
    public void setUp() {
        this.mockResultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        this.mockConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockStatement = (Statement)Mockito.mock(Statement.class);
        this.mockQueryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        this.mockAutoGenerateKeysStrategy = (AutoGenerateKeysStrategy)Mockito.mock(AutoGenerateKeysStrategy.class);
        this.factory = new GenericStatementResultIteratorFactory(this.mockResultSetHandler);
    }

    @Test
    public void testConstructor() {
        MatcherAssert.assertThat((Object)this.factory, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testCreate() {
        StatementResultIterator iterator = this.factory.create(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy);
        MatcherAssert.assertThat((Object)iterator, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((boolean)(iterator instanceof StatementResultIterator));
    }

    @Test
    public void testCreateWithNullParameters() {
    }

    @Test
    public void testCreateWithDifferentParameters() {
        ResultSetHandler differentResultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        DbConnection differentConnection = (DbConnection)Mockito.mock(DbConnection.class);
        Statement differentStatement = (Statement)Mockito.mock(Statement.class);
        QueryTemplate differentQueryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        AutoGenerateKeysStrategy differentStrategy = (AutoGenerateKeysStrategy)Mockito.mock(AutoGenerateKeysStrategy.class);
        StatementResultIterator iterator = this.factory.create(differentConnection, differentStatement, differentQueryTemplate, differentStrategy);
        MatcherAssert.assertThat((Object)iterator, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((boolean)(iterator instanceof StatementResultIterator));
    }

    @Test
    public void testDoCreateStatementResultIterator() {
        StatementResultIterator iterator = this.factory.doCreateStatementResultIterator(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy, this.mockResultSetHandler);
        MatcherAssert.assertThat((Object)iterator, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((boolean)(iterator instanceof StatementResultIterator));
    }

    @Test
    public void testDoCreateStatementResultIteratorWithNullParameters() {
    }

    @Test
    public void testFactoryImplementsInterface() {
        Assert.assertTrue((boolean)(this.factory instanceof StatementResultIteratorFactory));
    }

    @Test
    public void testFactoryClass() {
        MatcherAssert.assertThat((Object)this.factory.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"GenericStatementResultIteratorFactory"));
    }

    @Test
    public void testFactoryPackage() {
        String packageName = this.factory.getClass().getPackage().getName();
        MatcherAssert.assertThat((Object)packageName, (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.result.statement"));
    }
}

