/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.result.statement.SingleStatementResult;
import org.mule.db.commons.internal.result.statement.UpdateCountResult;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class UpdateCountResultTestCase
extends AbstractMuleTestCase {
    @Test
    public void testConstructorWithValidParameters() {
        String name = "testUpdate";
        int count = 5;
        UpdateCountResult result = new UpdateCountResult(name, count);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)count));
    }

    @Test
    public void testConstructorWithNullName() {
        int count = 10;
        UpdateCountResult result = new UpdateCountResult(null, count);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)null));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)count));
    }

    @Test
    public void testConstructorWithZeroCount() {
        String name = "zeroUpdate";
        int count = 0;
        UpdateCountResult result = new UpdateCountResult(name, count);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)count));
    }

    @Test
    public void testConstructorWithNegativeCount() {
        String name = "negativeUpdate";
        int count = -1;
        UpdateCountResult result = new UpdateCountResult(name, count);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)count));
    }

    @Test
    public void testConstructorWithLargeCount() {
        String name = "largeUpdate";
        int count = Integer.MAX_VALUE;
        UpdateCountResult result = new UpdateCountResult(name, count);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getName(), (Matcher)CoreMatchers.is((Object)name));
        MatcherAssert.assertThat((Object)result.getResult(), (Matcher)CoreMatchers.is((Object)count));
    }

    @Test
    public void testClassImplementsSingleStatementResult() {
        UpdateCountResult result = new UpdateCountResult("test", 1);
        MatcherAssert.assertThat((Object)(result instanceof SingleStatementResult), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        UpdateCountResult result = new UpdateCountResult("test", 1);
        MatcherAssert.assertThat((Object)result.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.result.statement"));
    }

    @Test
    public void testClassHasCorrectName() {
        UpdateCountResult result = new UpdateCountResult("test", 1);
        MatcherAssert.assertThat((Object)result.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"UpdateCountResult"));
    }

    @Test
    public void testGetResultReturnsInteger() {
        int count = 42;
        UpdateCountResult result = new UpdateCountResult("test", count);
        Object resultValue = result.getResult();
        MatcherAssert.assertThat((Object)(resultValue instanceof Integer), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((Integer)resultValue), (Matcher)CoreMatchers.is((Object)count));
    }

    @Test
    public void testGetNameReturnsString() {
        String name = "testName";
        UpdateCountResult result = new UpdateCountResult(name, 1);
        String resultName = result.getName();
        MatcherAssert.assertThat((Object)(resultName instanceof String), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)resultName, (Matcher)CoreMatchers.is((Object)name));
    }
}

