/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.logger;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.logger.BulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.DebugBulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.DebugPreparedBulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.DebugSingleQueryLogger;
import org.mule.db.commons.internal.domain.logger.DefaultQueryLoggerFactory;
import org.mule.db.commons.internal.domain.logger.NullBulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.NullPreparedBulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.NullSingleQueryLogger;
import org.mule.db.commons.internal.domain.logger.PreparedBulkQueryLogger;
import org.mule.db.commons.internal.domain.logger.SingleQueryLogger;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.slf4j.Logger;

public class DefaultQueryLoggerFactoryTestCase {
    private DefaultQueryLoggerFactory factory;
    private Logger mockLogger;
    private QueryTemplate mockQueryTemplate;

    @Before
    public void setUp() {
        this.factory = new DefaultQueryLoggerFactory();
        this.mockLogger = (Logger)Mockito.mock(Logger.class);
        this.mockQueryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
    }

    @Test
    public void testCreateQueryLoggerWithDebugEnabled() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        SingleQueryLogger logger = this.factory.createQueryLogger(this.mockLogger, this.mockQueryTemplate);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof DebugSingleQueryLogger));
    }

    @Test
    public void testCreateQueryLoggerWithDebugDisabled() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)false);
        SingleQueryLogger logger = this.factory.createQueryLogger(this.mockLogger, this.mockQueryTemplate);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof NullSingleQueryLogger));
    }

    @Test
    public void testCreateBulkQueryLoggerWithDebugEnabled() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        int bulkSize = 10;
        PreparedBulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger, this.mockQueryTemplate, bulkSize);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof DebugPreparedBulkQueryLogger));
    }

    @Test
    public void testCreateBulkQueryLoggerWithDebugDisabled() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)false);
        int bulkSize = 10;
        PreparedBulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger, this.mockQueryTemplate, bulkSize);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof NullPreparedBulkQueryLogger));
    }

    @Test
    public void testCreateBulkQueryLoggerWithDebugEnabledNoTemplate() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        BulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof DebugBulkQueryLogger));
    }

    @Test
    public void testCreateBulkQueryLoggerWithDebugDisabledNoTemplate() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)false);
        BulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof NullBulkQueryLogger));
    }

    @Test(expected=NullPointerException.class)
    public void testCreateQueryLoggerWithNullLogger() {
        this.factory.createQueryLogger(null, this.mockQueryTemplate);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateBulkQueryLoggerWithNullLogger() {
        int bulkSize = 10;
        this.factory.createBulkQueryLogger(null, this.mockQueryTemplate, bulkSize);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateBulkQueryLoggerWithNullLoggerNoTemplate() {
        this.factory.createBulkQueryLogger(null);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateQueryLoggerWithNullTemplate() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        this.factory.createQueryLogger(this.mockLogger, null);
    }

    @Test(expected=NullPointerException.class)
    public void testCreateBulkQueryLoggerWithNullTemplate() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        int bulkSize = 10;
        this.factory.createBulkQueryLogger(this.mockLogger, null, bulkSize);
    }

    @Test
    public void testCreateBulkQueryLoggerWithZeroBulkSize() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        int bulkSize = 0;
        PreparedBulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger, this.mockQueryTemplate, bulkSize);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof DebugPreparedBulkQueryLogger));
    }

    @Test
    public void testCreateBulkQueryLoggerWithNegativeBulkSize() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        int bulkSize = -1;
        PreparedBulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger, this.mockQueryTemplate, bulkSize);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof DebugPreparedBulkQueryLogger));
    }

    @Test
    public void testCreateBulkQueryLoggerWithLargeBulkSize() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        int bulkSize = Integer.MAX_VALUE;
        PreparedBulkQueryLogger logger = this.factory.createBulkQueryLogger(this.mockLogger, this.mockQueryTemplate, bulkSize);
        Assert.assertNotNull((Object)logger);
        Assert.assertTrue((boolean)(logger instanceof DebugPreparedBulkQueryLogger));
    }
}

