/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.metadata.BaseDbMetadataResolver;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class BaseDbMetadataResolverTestCase
extends AbstractMuleTestCase {
    private TestBaseDbMetadataResolver resolver;
    private MetadataContext mockContext;
    private DbConnection mockDbConnection;
    private Connection mockJdbcConnection;
    private PreparedStatement mockPreparedStatement;
    private ClassTypeLoader mockTypeLoader;
    private BaseTypeBuilder mockTypeBuilder;

    @Before
    public void setUp() {
        this.resolver = new TestBaseDbMetadataResolver();
        this.mockContext = (MetadataContext)Mockito.mock(MetadataContext.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockJdbcConnection = (Connection)Mockito.mock(Connection.class);
        this.mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockTypeLoader = (ClassTypeLoader)Mockito.mock(ClassTypeLoader.class);
        this.resolver.typeBuilder = this.mockTypeBuilder = (BaseTypeBuilder)Mockito.mock(BaseTypeBuilder.class);
        this.resolver.typeLoader = this.mockTypeLoader;
    }

    @Test
    public void testParseQuery() {
        String query = "SELECT * FROM test_table";
        QueryTemplate result = this.resolver.parseQuery(query);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)result.getSqlText(), (Matcher)CoreMatchers.is((Object)query));
    }

    @Test
    public void testGetStatementSuccess() throws SQLException, ConnectionException, MetadataResolvingException {
        String query = "SELECT * FROM test_table";
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getSqlText()).thenReturn((Object)query);
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.of(this.mockDbConnection));
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(query)).thenReturn((Object)this.mockPreparedStatement);
        PreparedStatement result = this.resolver.getStatement(this.mockContext, queryTemplate);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.mockPreparedStatement));
    }

    @Test
    public void testGetStatementWithNoConnection() throws ConnectionException {
        String query = "SELECT * FROM test_table";
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.empty());
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getStatement(this.mockContext, queryTemplate));
    }

    @Test
    public void testGetStatementWithSQLException() throws SQLException, ConnectionException {
        String query = "SELECT * FROM test_table";
        QueryTemplate queryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        Mockito.when((Object)queryTemplate.getSqlText()).thenReturn((Object)query);
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.of(this.mockDbConnection));
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(query)).thenThrow(new Throwable[]{new SQLException("Test SQL Exception")});
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getStatement(this.mockContext, queryTemplate));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)((Object)((Object)this.resolver)).getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.metadata"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)((Object)((Object)this.resolver)).getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"TestBaseDbMetadataResolver"));
    }

    private static class TestBaseDbMetadataResolver
    extends BaseDbMetadataResolver {
        private TestBaseDbMetadataResolver() {
        }
    }
}

