/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.AbstractDbType;

@RunWith(value=MockitoJUnitRunner.class)
public class AbstractDbTypeTest {
    @Mock
    private CallableStatement mockStatement;

    @Test
    public void testConstructorAndGetters() {
        TestDbType dbType = new TestDbType(123, "TEST_TYPE");
        Assert.assertEquals((long)123L, (long)dbType.getId());
        Assert.assertEquals((Object)"TEST_TYPE", (Object)dbType.getName());
    }

    @Test
    public void testRegisterOutParameter() throws SQLException {
        TestDbType dbType = new TestDbType(12, "VARCHAR");
        dbType.registerOutParameter(this.mockStatement, 1);
        ((CallableStatement)Mockito.verify((Object)this.mockStatement)).registerOutParameter(1, 12);
    }

    @Test
    public void testRegisterOutParameterWithDifferentIndex() throws SQLException {
        TestDbType dbType = new TestDbType(4, "INTEGER");
        dbType.registerOutParameter(this.mockStatement, 5);
        ((CallableStatement)Mockito.verify((Object)this.mockStatement)).registerOutParameter(5, 4);
    }

    @Test
    public void testRegisterOutParameterWithSQLException() throws SQLException {
        TestDbType dbType = new TestDbType(8, "DOUBLE");
        ((CallableStatement)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Test exception")}).when((Object)this.mockStatement)).registerOutParameter(Mockito.anyInt(), Mockito.anyInt());
        try {
            dbType.registerOutParameter(this.mockStatement, 1);
            Assert.fail((String)"Should have thrown SQLException");
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"Test exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        TestDbType dbType = new TestDbType(16, "BOOLEAN_TYPE");
        Assert.assertEquals((Object)"BOOLEAN_TYPE", (Object)dbType.toString());
    }

    @Test
    public void testToStringWithNullName() {
        TestDbType dbType = new TestDbType(0, null);
        Assert.assertEquals(null, (Object)dbType.toString());
    }

    @Test
    public void testToStringWithEmptyName() {
        TestDbType dbType = new TestDbType(1111, "");
        Assert.assertEquals((Object)"", (Object)dbType.toString());
    }

    @Test
    public void testMultipleInstances() {
        TestDbType dbType1 = new TestDbType(1, "TYPE_1");
        TestDbType dbType2 = new TestDbType(2, "TYPE_2");
        Assert.assertEquals((long)1L, (long)dbType1.getId());
        Assert.assertEquals((Object)"TYPE_1", (Object)dbType1.getName());
        Assert.assertEquals((long)2L, (long)dbType2.getId());
        Assert.assertEquals((Object)"TYPE_2", (Object)dbType2.getName());
    }

    @Test
    public void testRegisterOutParameterMultipleCalls() throws SQLException {
        TestDbType dbType = new TestDbType(91, "DATE");
        dbType.registerOutParameter(this.mockStatement, 1);
        dbType.registerOutParameter(this.mockStatement, 2);
        dbType.registerOutParameter(this.mockStatement, 3);
        ((CallableStatement)Mockito.verify((Object)this.mockStatement)).registerOutParameter(1, 91);
        ((CallableStatement)Mockito.verify((Object)this.mockStatement)).registerOutParameter(2, 91);
        ((CallableStatement)Mockito.verify((Object)this.mockStatement)).registerOutParameter(3, 91);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockStatement});
    }

    private static class TestDbType
    extends AbstractDbType {
        public TestDbType(int id, String name) {
            super(id, name);
        }

        public void setParameterValue(PreparedStatement statement, int index, Object value, DbConnection connection) throws SQLException {
        }

        public Object getParameterValue(CallableStatement statement, int index) throws SQLException {
            return null;
        }
    }
}

