/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.DefaultInOutQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.StructDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;
import org.mule.db.commons.internal.resolver.param.QueryParamTypeResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class QueryParamTypeResolverTestCase
extends AbstractMuleTestCase {
    private QueryParamTypeResolver resolver;
    private DbTypeManager mockDbTypeManager;
    private DbConnection mockDbConnection;
    private Connection mockJdbcConnection;
    private PreparedStatement mockPreparedStatement;
    private ParameterMetaData mockParameterMetaData;
    private QueryTemplate mockQueryTemplate;

    @Before
    public void setUp() {
        this.mockDbTypeManager = (DbTypeManager)Mockito.mock(DbTypeManager.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockJdbcConnection = (Connection)Mockito.mock(Connection.class);
        this.mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockParameterMetaData = (ParameterMetaData)Mockito.mock(ParameterMetaData.class);
        this.mockQueryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        this.resolver = new QueryParamTypeResolver(this.mockDbTypeManager);
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockQueryTemplate.getSqlText()).thenReturn((Object)"SELECT * FROM test WHERE id = ?");
    }

    @Test
    public void testConstructor() {
        MatcherAssert.assertThat((Object)this.resolver, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetParameterTypesWithValidTypes() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList<DefaultInOutQueryParam> queryParams = new ArrayList<DefaultInOutQueryParam>();
        queryParams.add(new DefaultInOutQueryParam(1, null, "id", null));
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)4);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"INTEGER");
        DbType mockType = (DbType)Mockito.mock(DbType.class);
        Mockito.when((Object)this.mockDbTypeManager.lookup(this.mockDbConnection, 4, "INTEGER")).thenReturn((Object)mockType);
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)mockType, result.get(1));
    }

    @Test
    public void testGetParameterTypesWithNullParameterTypeName() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList<DefaultInOutQueryParam> queryParams = new ArrayList<DefaultInOutQueryParam>();
        queryParams.add(new DefaultInOutQueryParam(1, null, "id", null));
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)4);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn(null);
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)1L, (long)result.size());
        MatcherAssert.assertThat(result.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnknownDbType.class)));
    }

    @Test
    public void testGetParameterTypesWithUnspecifiedType() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList<DefaultInOutQueryParam> queryParams = new ArrayList<DefaultInOutQueryParam>();
        queryParams.add(new DefaultInOutQueryParam(1, null, "id", null));
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)4);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"UNSPECIFIED");
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)1L, (long)result.size());
        MatcherAssert.assertThat(result.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnknownDbType.class)));
    }

    @Test
    public void testGetParameterTypesWithStructType() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList<DefaultInOutQueryParam> queryParams = new ArrayList<DefaultInOutQueryParam>();
        queryParams.add(new DefaultInOutQueryParam(1, null, "struct_param", null));
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)2002);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"STRUCT_TYPE");
        Mockito.when((Object)this.mockDbTypeManager.lookup(this.mockDbConnection, 2002, "STRUCT_TYPE")).thenThrow(new Throwable[]{new UnknownDbTypeException("Type not found")});
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)1L, (long)result.size());
        MatcherAssert.assertThat(result.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(StructDbType.class)));
        StructDbType structType = (StructDbType)result.get(1);
        Assert.assertEquals((long)2002L, (long)structType.getId());
        Assert.assertEquals((Object)"STRUCT_TYPE", (Object)structType.getName());
    }

    @Test
    public void testGetParameterTypesWithArrayType() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList<DefaultInOutQueryParam> queryParams = new ArrayList<DefaultInOutQueryParam>();
        queryParams.add(new DefaultInOutQueryParam(1, null, "array_param", null));
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)2003);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"ARRAY_TYPE");
        Mockito.when((Object)this.mockDbTypeManager.lookup(this.mockDbConnection, 2003, "ARRAY_TYPE")).thenThrow(new Throwable[]{new UnknownDbTypeException("Type not found")});
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)1L, (long)result.size());
        MatcherAssert.assertThat(result.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ArrayResolvedDbType.class)));
        ArrayResolvedDbType arrayType = (ArrayResolvedDbType)result.get(1);
        Assert.assertEquals((long)2003L, (long)arrayType.getId());
        Assert.assertEquals((Object)"ARRAY_TYPE", (Object)arrayType.getName());
    }

    @Test
    public void testGetParameterTypesWithOtherType() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList<DefaultInOutQueryParam> queryParams = new ArrayList<DefaultInOutQueryParam>();
        queryParams.add(new DefaultInOutQueryParam(1, null, "other_param", null));
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        Mockito.when((Object)this.mockParameterMetaData.getParameterType(1)).thenReturn((Object)12);
        Mockito.when((Object)this.mockParameterMetaData.getParameterTypeName(1)).thenReturn((Object)"OTHER_TYPE");
        Mockito.when((Object)this.mockDbTypeManager.lookup(this.mockDbConnection, 12, "OTHER_TYPE")).thenThrow(new Throwable[]{new UnknownDbTypeException("Type not found")});
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)1L, (long)result.size());
        MatcherAssert.assertThat(result.get(1), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ResolvedDbType.class)));
        ResolvedDbType resolvedType = (ResolvedDbType)result.get(1);
        Assert.assertEquals((long)12L, (long)resolvedType.getId());
        Assert.assertEquals((Object)"OTHER_TYPE", (Object)resolvedType.getName());
    }

    @Test
    public void testGetParameterTypesWithEmptyParams() throws SQLException {
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement("SELECT * FROM test WHERE id = ?")).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getParameterMetaData()).thenReturn((Object)this.mockParameterMetaData);
        ArrayList queryParams = new ArrayList();
        Mockito.when((Object)this.mockQueryTemplate.getParams()).thenReturn(queryParams);
        ArrayList types = new ArrayList();
        Map result = this.resolver.getParameterTypes(this.mockDbConnection, this.mockQueryTemplate, types);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertEquals((long)0L, (long)result.size());
    }
}

