/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.parser.QueryTemplateParser;
import org.mule.db.commons.internal.resolver.query.BulkQueryFactory;
import org.mule.db.commons.internal.resolver.query.DefaultBulkQueryFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultBulkQueryFactoryTestCase
extends AbstractMuleTestCase {
    private DefaultBulkQueryFactory factory;
    private QueryTemplateParser mockParser;
    private String testBulkQueryText = "SELECT * FROM users; INSERT INTO logs VALUES (1);";

    @Before
    public void setUp() {
        this.mockParser = (QueryTemplateParser)Mockito.mock(QueryTemplateParser.class);
        this.factory = new DefaultBulkQueryFactory(this.mockParser, this.testBulkQueryText);
    }

    @Test
    public void testConstructorWithValidParameters() {
        MatcherAssert.assertThat((Object)this.factory, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)this.factory.toString(), (Matcher)CoreMatchers.is((Object)this.testBulkQueryText));
    }

    @Test
    public void testResolveBulkQueriesReturnsTrimmedText() {
        String result = this.factory.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.testBulkQueryText.trim()));
    }

    @Test
    public void testResolveBulkQueriesWithWhitespace() {
        String queryWithWhitespace = "  SELECT * FROM users;  ";
        DefaultBulkQueryFactory factoryWithWhitespace = new DefaultBulkQueryFactory(this.mockParser, queryWithWhitespace);
        String result = factoryWithWhitespace.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"SELECT * FROM users;"));
    }

    @Test
    public void testResolveBulkQueriesWithEmptyString() {
        String emptyQuery = "";
        DefaultBulkQueryFactory factoryWithEmpty = new DefaultBulkQueryFactory(this.mockParser, emptyQuery);
        String result = factoryWithEmpty.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testResolveBulkQueriesWithWhitespaceOnly() {
        String whitespaceOnly = "   \t\n  ";
        DefaultBulkQueryFactory factoryWithWhitespaceOnly = new DefaultBulkQueryFactory(this.mockParser, whitespaceOnly);
        String result = factoryWithWhitespaceOnly.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testToStringReturnsOriginalText() {
        String result = this.factory.toString();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.testBulkQueryText));
    }

    @Test
    public void testClassExtendsBulkQueryFactory() {
        MatcherAssert.assertThat((Object)(this.factory instanceof BulkQueryFactory), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.factory.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.resolver.query"));
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.factory.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"DefaultBulkQueryFactory"));
    }

    @Test
    public void testConstructorWithNullBulkQueryText() {
    }

    @Test
    public void testResolveBulkQueriesWithNullText() {
    }

    @Test
    public void testResolveBulkQueriesWithLargeQuery() {
        String largeQuery = "SELECT * FROM large_table WHERE id > 1000; UPDATE large_table SET status = 'processed' WHERE id > 1000; INSERT INTO audit_log (table_name, action, timestamp) VALUES ('large_table', 'bulk_update', NOW());";
        DefaultBulkQueryFactory factoryWithLargeQuery = new DefaultBulkQueryFactory(this.mockParser, largeQuery);
        String result = factoryWithLargeQuery.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)largeQuery.trim()));
    }

    @Test
    public void testResolveBulkQueriesWithSpecialCharacters() {
        String queryWithSpecialChars = "SELECT * FROM users WHERE name LIKE '%test%'; INSERT INTO logs (message) VALUES ('Test with \"quotes\" and 'apostrophes'');";
        DefaultBulkQueryFactory factoryWithSpecialChars = new DefaultBulkQueryFactory(this.mockParser, queryWithSpecialChars);
        String result = factoryWithSpecialChars.resolveBulkQueries();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)queryWithSpecialChars.trim()));
    }
}

