/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.result.resultset.ResultSetHandler;
import org.mule.db.commons.internal.result.statement.AbstractMapStatementResultHandler;
import org.mule.db.commons.internal.result.statement.SingleStatementResult;
import org.mule.db.commons.internal.result.statement.StatementResultIterator;
import org.mule.db.commons.internal.result.statement.StatementResultIteratorFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class AbstractMapStatementResultHandlerTestCase
extends AbstractMuleTestCase {
    private TestMapStatementResultHandler handler;
    private DbConnection mockConnection;
    private Statement mockStatement;
    private QueryTemplate mockQueryTemplate;
    private AutoGenerateKeysStrategy mockAutoGenerateKeysStrategy;
    private ResultSetHandler mockResultSetHandler;
    private StatementResultIteratorFactory mockIteratorFactory;
    private StatementResultIterator mockIterator;

    @Before
    public void setUp() {
        this.mockConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockStatement = (Statement)Mockito.mock(Statement.class);
        this.mockQueryTemplate = (QueryTemplate)Mockito.mock(QueryTemplate.class);
        this.mockAutoGenerateKeysStrategy = (AutoGenerateKeysStrategy)Mockito.mock(AutoGenerateKeysStrategy.class);
        this.mockResultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        this.mockIteratorFactory = (StatementResultIteratorFactory)Mockito.mock(StatementResultIteratorFactory.class);
        this.mockIterator = (StatementResultIterator)Mockito.mock(StatementResultIterator.class);
        this.handler = new TestMapStatementResultHandler(this.mockResultSetHandler);
        Mockito.when((Object)this.mockConnection.getStatementResultIteratorFactory(this.mockResultSetHandler)).thenReturn((Object)this.mockIteratorFactory);
        Mockito.when((Object)this.mockIteratorFactory.create(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy)).thenReturn((Object)this.mockIterator);
    }

    @Test
    public void testConstructor() {
        MatcherAssert.assertThat((Object)((Object)this.handler), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testProcessStatementWithEmptyIterator() throws SQLException {
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)false);
        Map result = this.handler.processStatement(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testProcessStatementWithSingleResult() throws SQLException {
        SingleStatementResult mockResult = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)mockResult);
        Mockito.when((Object)mockResult.getName()).thenReturn((Object)"testName");
        Mockito.when((Object)mockResult.getResult()).thenReturn((Object)"testValue");
        Map result = this.handler.processStatement(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"testValue", result.get("testName"));
    }

    @Test
    public void testProcessStatementWithMultipleResults() throws SQLException {
        SingleStatementResult mockResult1 = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        SingleStatementResult mockResult2 = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        SingleStatementResult mockResult3 = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)mockResult1, (Object[])new SingleStatementResult[]{mockResult2, mockResult3});
        Mockito.when((Object)mockResult1.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)mockResult1.getResult()).thenReturn((Object)"value1");
        Mockito.when((Object)mockResult2.getName()).thenReturn((Object)"name2");
        Mockito.when((Object)mockResult2.getResult()).thenReturn((Object)"value2");
        Mockito.when((Object)mockResult3.getName()).thenReturn((Object)"name3");
        Mockito.when((Object)mockResult3.getResult()).thenReturn((Object)"value3");
        Map result = this.handler.processStatement(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"value1", result.get("name1"));
        Assert.assertEquals((Object)"value2", result.get("name2"));
        Assert.assertEquals((Object)"value3", result.get("name3"));
    }

    @Test
    public void testProcessStatementWithNullResults() throws SQLException {
        SingleStatementResult mockResult = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)mockResult);
        Mockito.when((Object)mockResult.getName()).thenReturn((Object)"nullName");
        Mockito.when((Object)mockResult.getResult()).thenReturn(null);
        Map result = this.handler.processStatement(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals(null, result.get("nullName"));
    }

    @Test
    public void testProcessStatementWithDuplicateNames() throws SQLException {
        SingleStatementResult mockResult1 = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        SingleStatementResult mockResult2 = (SingleStatementResult)Mockito.mock(SingleStatementResult.class);
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)mockResult1, (Object[])new SingleStatementResult[]{mockResult2});
        Mockito.when((Object)mockResult1.getName()).thenReturn((Object)"duplicateName");
        Mockito.when((Object)mockResult1.getResult()).thenReturn((Object)"firstValue");
        Mockito.when((Object)mockResult2.getName()).thenReturn((Object)"duplicateName");
        Mockito.when((Object)mockResult2.getResult()).thenReturn((Object)"secondValue");
        Map result = this.handler.processStatement(this.mockConnection, this.mockStatement, this.mockQueryTemplate, this.mockAutoGenerateKeysStrategy);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.notNullValue());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"secondValue", result.get("duplicateName"));
    }

    private static class TestMapStatementResultHandler
    extends AbstractMapStatementResultHandler {
        public TestMapStatementResultHandler(ResultSetHandler resultSetHandler) {
            super(resultSetHandler);
        }

        protected Map<String, Object> createResultMap() {
            return new HashMap<String, Object>();
        }
    }
}

