/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.DbFunctionUtil;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

@RunWith(value=MockitoJUnitRunner.class)
public class DbFunctionUtilTestCase {
    @Mock
    private ExtensionManager mockExtensionManager;
    @Mock
    private ConfigurationInstance mockConfiguration;
    @Mock
    private ConnectionProvider<Object> mockConnectionProvider;
    @Mock
    private DbConnection mockDbConnection;
    private DbFunctionUtil dbFunctionUtil;

    @Before
    public void setUp() {
        this.dbFunctionUtil = new DbFunctionUtil(this.mockExtensionManager);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.dbFunctionUtil);
    }

    @Test
    public void testExecuteSuccess() throws Exception {
        String configName = "testConfig";
        String expectedResult = "test result";
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> expectedResult;
        String result = (String)this.dbFunctionUtil.execute(function, configName);
        Assert.assertEquals((Object)expectedResult, (Object)result);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).connect();
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithNonDbConnection() throws Exception {
        String configName = "testConfig";
        Object nonDbConnection = new Object();
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn(nonDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> "result";
        ConnectionException exception = (ConnectionException)Assert.assertThrows(ConnectionException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertEquals((Object)"Connection is not a DB Connection", (Object)exception.getMessage());
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider, (VerificationMode)Mockito.never())).disconnect(nonDbConnection);
    }

    @Test
    public void testExecuteWithConnectionException() throws Exception {
        String configName = "testConfig";
        ConnectionException connectionException = new ConnectionException("Connection failed");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenThrow(new Throwable[]{connectionException});
        DbFunctionUtil.ConnectedFunction function = connection -> "result";
        ConnectionException exception = (ConnectionException)Assert.assertThrows(ConnectionException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertEquals((Object)connectionException, (Object)exception);
    }

    @Test
    public void testExecuteWithSQLException() throws Exception {
        String configName = "testConfig";
        SQLException sqlException = new SQLException("SQL error");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> {
            throw sqlException;
        };
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertEquals((Object)sqlException, (Object)exception);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithFunctionException() throws Exception {
        String configName = "testConfig";
        RuntimeException functionException = new RuntimeException("Function error");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> {
            throw functionException;
        };
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertEquals((Object)functionException, (Object)exception);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithNoConnectionProvider() throws Exception {
        String configName = "testConfig";
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.empty());
        DbFunctionUtil.ConnectedFunction function = connection -> "result";
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertTrue((boolean)exception.getMessage().contains("Unable to obtain a connection for configuration"));
        Assert.assertTrue((boolean)exception.getMessage().contains(configName));
    }

    @Test
    public void testExecuteWithNullConfigName() throws Exception {
        String configName = null;
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq(configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> "result";
        String result = (String)this.dbFunctionUtil.execute(function, configName);
        Assert.assertEquals((Object)"result", (Object)result);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithNullFunction() throws Exception {
        String configName = "testConfig";
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        Assert.assertThrows(NullPointerException.class, () -> this.dbFunctionUtil.execute(null, configName));
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithComplexReturnType() throws Exception {
        String configName = "testConfig";
        List<String> expectedResult = Arrays.asList("item1", "item2", "item3");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> expectedResult;
        List result = (List)this.dbFunctionUtil.execute(function, configName);
        Assert.assertEquals(expectedResult, (Object)result);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithVoidFunction() throws Exception {
        String configName = "testConfig";
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> null;
        Void result = (Void)this.dbFunctionUtil.execute(function, configName);
        Assert.assertNull((Object)result);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteWithConnectionProviderException() throws Exception {
        String configName = "testConfig";
        RuntimeException providerException = new RuntimeException("Provider error");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenThrow(new Throwable[]{providerException});
        DbFunctionUtil.ConnectedFunction function = connection -> "result";
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertEquals((Object)providerException, (Object)exception);
    }

    @Test
    public void testExecuteWithDisconnectException() throws Exception {
        String configName = "testConfig";
        RuntimeException disconnectException = new RuntimeException("Disconnect error");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        ((ConnectionProvider)Mockito.doThrow((Throwable[])new Throwable[]{disconnectException}).when(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
        DbFunctionUtil.ConnectedFunction function = connection -> "result";
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctionUtil.execute(function, configName));
        Assert.assertEquals((Object)disconnectException, (Object)exception);
    }

    @Test
    public void testConnectedFunctionInterface() {
        DbFunctionUtil.ConnectedFunction function = connection -> "test";
        Assert.assertNotNull((Object)function);
        Assert.assertTrue((boolean)(function instanceof DbFunctionUtil.ConnectedFunction));
    }

    @Test
    public void testWithConnectionInterface() {
        DbFunctionUtil.WithConnection withConnection = (connection, values, typeName) -> "test";
        Assert.assertNotNull((Object)withConnection);
        Assert.assertTrue((boolean)(withConnection instanceof DbFunctionUtil.WithConnection));
    }

    @Test
    public void testExecuteDeprecatedMethod() throws Exception {
        String configName = "testConfig";
        List<Object> values = Arrays.asList("value1", "value2");
        String typeName = "test_type";
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.WithConnection withConnection = (connection, vals, type) -> "result";
        Object result = this.dbFunctionUtil.execute(withConnection, values, typeName, configName);
        Assert.assertEquals((Object)"result", (Object)result);
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }

    @Test
    public void testExecuteDeprecatedMethodWithException() throws Exception {
        String configName = "testConfig";
        List<Object> values = Arrays.asList("value1", "value2");
        String typeName = "test_type";
        RuntimeException functionException = new RuntimeException("Function error");
        Mockito.when((Object)this.mockExtensionManager.getConfiguration((String)ArgumentMatchers.eq((Object)configName), (CoreEvent)ArgumentMatchers.any(CoreEvent.class))).thenReturn((Object)this.mockConfiguration);
        Mockito.when((Object)this.mockConfiguration.getConnectionProvider()).thenReturn(Optional.of(this.mockConnectionProvider));
        Mockito.when((Object)this.mockConnectionProvider.connect()).thenReturn((Object)this.mockDbConnection);
        DbFunctionUtil.WithConnection withConnection = (connection, vals, type) -> {
            throw functionException;
        };
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.dbFunctionUtil.execute(withConnection, values, typeName, configName));
        Assert.assertTrue((boolean)exception.getMessage().contains("An error occurred when trying to create JDBC Structure"));
        Assert.assertTrue((boolean)exception.getMessage().contains(functionException.getMessage()));
        ((ConnectionProvider)Mockito.verify(this.mockConnectionProvider)).disconnect((Object)this.mockDbConnection);
    }
}

