/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.autogeneratedkey;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysAttributes;

public class AutoGenerateKeysAttributesTestCase {
    @Test
    public void testInterfaceConstants() {
        Assert.assertEquals((Object)"Auto Generate Keys", (Object)"Auto Generate Keys");
    }

    @Test
    public void testInterfaceMethods() {
        TestAutoGenerateKeysAttributes attributes = new TestAutoGenerateKeysAttributes();
        Assert.assertTrue((boolean)attributes.isAutoGenerateKeys());
        Assert.assertNotNull((Object)attributes.getAutoGeneratedKeysColumnIndexes());
        Assert.assertNotNull((Object)attributes.getAutoGeneratedKeysColumnNames());
    }

    @Test
    public void testInterfaceMethodSignatures() {
        try {
            AutoGenerateKeysAttributes.class.getMethod("isAutoGenerateKeys", new Class[0]);
            AutoGenerateKeysAttributes.class.getMethod("getAutoGeneratedKeysColumnIndexes", new Class[0]);
            AutoGenerateKeysAttributes.class.getMethod("getAutoGeneratedKeysColumnNames", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)("Interface method not found: " + e.getMessage()));
        }
    }

    @Test
    public void testInterfaceReturnTypes() {
        TestAutoGenerateKeysAttributes attributes = new TestAutoGenerateKeysAttributes();
        Assert.assertTrue((attributes.isAutoGenerateKeys() || !attributes.isAutoGenerateKeys() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(attributes.getAutoGeneratedKeysColumnIndexes() instanceof List));
        Assert.assertTrue((boolean)(attributes.getAutoGeneratedKeysColumnNames() instanceof List));
    }

    @Test
    public void testInterfaceImplementation() {
        TestAutoGenerateKeysAttributes attributes = new TestAutoGenerateKeysAttributes();
        Assert.assertTrue((boolean)attributes.isAutoGenerateKeys());
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)attributes.getAutoGeneratedKeysColumnIndexes());
        Assert.assertEquals(Arrays.asList("id", "uuid", "timestamp"), (Object)attributes.getAutoGeneratedKeysColumnNames());
    }

    @Test
    public void testInterfaceWithEmptyLists() {
        TestAutoGenerateKeysAttributesEmpty attributes = new TestAutoGenerateKeysAttributesEmpty();
        Assert.assertFalse((boolean)attributes.isAutoGenerateKeys());
        Assert.assertEquals(Collections.emptyList(), (Object)attributes.getAutoGeneratedKeysColumnIndexes());
        Assert.assertEquals(Collections.emptyList(), (Object)attributes.getAutoGeneratedKeysColumnNames());
    }

    @Test
    public void testInterfaceWithNullLists() {
        TestAutoGenerateKeysAttributesNull attributes = new TestAutoGenerateKeysAttributesNull();
        Assert.assertTrue((boolean)attributes.isAutoGenerateKeys());
        Assert.assertNull((Object)attributes.getAutoGeneratedKeysColumnIndexes());
        Assert.assertNull((Object)attributes.getAutoGeneratedKeysColumnNames());
    }

    private static class TestAutoGenerateKeysAttributesNull
    implements AutoGenerateKeysAttributes {
        private TestAutoGenerateKeysAttributesNull() {
        }

        public boolean isAutoGenerateKeys() {
            return true;
        }

        public List<Integer> getAutoGeneratedKeysColumnIndexes() {
            return null;
        }

        public List<String> getAutoGeneratedKeysColumnNames() {
            return null;
        }
    }

    private static class TestAutoGenerateKeysAttributesEmpty
    implements AutoGenerateKeysAttributes {
        private TestAutoGenerateKeysAttributesEmpty() {
        }

        public boolean isAutoGenerateKeys() {
            return false;
        }

        public List<Integer> getAutoGeneratedKeysColumnIndexes() {
            return Collections.emptyList();
        }

        public List<String> getAutoGeneratedKeysColumnNames() {
            return Collections.emptyList();
        }
    }

    private static class TestAutoGenerateKeysAttributes
    implements AutoGenerateKeysAttributes {
        private TestAutoGenerateKeysAttributes() {
        }

        public boolean isAutoGenerateKeys() {
            return true;
        }

        public List<Integer> getAutoGeneratedKeysColumnIndexes() {
            return Arrays.asList(1, 2, 3);
        }

        public List<String> getAutoGeneratedKeysColumnNames() {
            return Arrays.asList("id", "uuid", "timestamp");
        }
    }
}

