/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection.generic;

import java.lang.reflect.Field;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.param.TransactionIsolation;
import org.mule.db.commons.internal.domain.connection.generic.GenericConnectionParameters;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GenericConnectionParametersTestCase
extends AbstractMuleTestCase {
    private static final String TEST_URL = "jdbc:mysql://localhost:3306/testdb";
    private static final String TEST_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final String TEST_USER = "testuser";
    private static final String TEST_PASSWORD = "testpass";

    @Test
    public void testDefaultValues() {
        GenericConnectionParameters params = new GenericConnectionParameters();
        Assert.assertEquals((Object)TransactionIsolation.NOT_CONFIGURED, (Object)params.getTransactionIsolation());
        Assert.assertFalse((boolean)params.isUseXaTransactions());
        MatcherAssert.assertThat((Object)params.getUrl(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)params.getDriverClassName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)params.getUser(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)params.getPassword(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testSetAndGetUrl() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "url", TEST_URL);
        Assert.assertEquals((Object)TEST_URL, (Object)params.getUrl());
    }

    @Test
    public void testSetAndGetDriverClassName() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "driverClassName", TEST_DRIVER);
        Assert.assertEquals((Object)TEST_DRIVER, (Object)params.getDriverClassName());
    }

    @Test
    public void testSetAndGetUser() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "user", TEST_USER);
        Assert.assertEquals((Object)TEST_USER, (Object)params.getUser());
    }

    @Test
    public void testSetAndGetPassword() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "password", TEST_PASSWORD);
        Assert.assertEquals((Object)TEST_PASSWORD, (Object)params.getPassword());
    }

    @Test
    public void testSetAndGetTransactionIsolation() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "transactionIsolation", TransactionIsolation.READ_COMMITTED);
        Assert.assertEquals((Object)TransactionIsolation.READ_COMMITTED, (Object)params.getTransactionIsolation());
    }

    @Test
    public void testSetAndGetUseXaTransactions() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "useXaTransactions", true);
        Assert.assertTrue((boolean)params.isUseXaTransactions());
    }

    @Test
    public void testCompleteConfiguration() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "url", TEST_URL);
        this.setField(params, "driverClassName", TEST_DRIVER);
        this.setField(params, "user", TEST_USER);
        this.setField(params, "password", TEST_PASSWORD);
        this.setField(params, "transactionIsolation", TransactionIsolation.SERIALIZABLE);
        this.setField(params, "useXaTransactions", true);
        Assert.assertEquals((Object)TEST_URL, (Object)params.getUrl());
        Assert.assertEquals((Object)TEST_DRIVER, (Object)params.getDriverClassName());
        Assert.assertEquals((Object)TEST_USER, (Object)params.getUser());
        Assert.assertEquals((Object)TEST_PASSWORD, (Object)params.getPassword());
        Assert.assertEquals((Object)TransactionIsolation.SERIALIZABLE, (Object)params.getTransactionIsolation());
        Assert.assertTrue((boolean)params.isUseXaTransactions());
    }

    @Test
    public void testNullValues() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "url", null);
        this.setField(params, "driverClassName", null);
        this.setField(params, "user", null);
        this.setField(params, "password", null);
        MatcherAssert.assertThat((Object)params.getUrl(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)params.getDriverClassName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)params.getUser(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)params.getPassword(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testEmptyStringValues() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        this.setField(params, "url", "");
        this.setField(params, "driverClassName", "");
        this.setField(params, "user", "");
        this.setField(params, "password", "");
        Assert.assertEquals((Object)"", (Object)params.getUrl());
        Assert.assertEquals((Object)"", (Object)params.getDriverClassName());
        Assert.assertEquals((Object)"", (Object)params.getUser());
        Assert.assertEquals((Object)"", (Object)params.getPassword());
    }

    @Test
    public void testAllTransactionIsolationLevels() throws Exception {
        GenericConnectionParameters params = new GenericConnectionParameters();
        for (TransactionIsolation isolation : TransactionIsolation.values()) {
            this.setField(params, "transactionIsolation", isolation);
            Assert.assertEquals((Object)isolation, (Object)params.getTransactionIsolation());
        }
    }

    private void setField(Object target, String fieldName, Object value) throws Exception {
        Field field = this.findField(target.getClass(), fieldName);
        field.setAccessible(true);
        field.set(target, value);
    }

    private Field findField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                return this.findField(superClass, fieldName);
            }
            throw e;
        }
    }
}

