/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.metadata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.metadata.BaseDbMetadataResolver;
import org.mule.db.commons.internal.domain.metadata.SelectMetadataResolver;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class SelectMetadataResolverTestCase
extends AbstractMuleTestCase {
    private SelectMetadataResolver resolver;
    private MetadataContext mockContext;
    private DbConnection mockDbConnection;
    private Connection mockJdbcConnection;
    private PreparedStatement mockPreparedStatement;
    private ResultSetMetaData mockResultSetMetaData;
    private ClassTypeLoader mockTypeLoader;
    private BaseTypeBuilder mockTypeBuilder;
    private ObjectTypeBuilder mockObjectTypeBuilder;
    private ObjectFieldTypeBuilder mockObjectFieldTypeBuilder;
    private ObjectType mockObjectType;

    @Before
    public void setup() {
        this.resolver = new SelectMetadataResolver();
        this.mockContext = (MetadataContext)Mockito.mock(MetadataContext.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        this.mockJdbcConnection = (Connection)Mockito.mock(Connection.class);
        this.mockPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockResultSetMetaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        this.mockTypeLoader = (ClassTypeLoader)Mockito.mock(ClassTypeLoader.class);
        this.mockTypeBuilder = (BaseTypeBuilder)Mockito.mock(BaseTypeBuilder.class);
        this.mockObjectTypeBuilder = (ObjectTypeBuilder)Mockito.mock(ObjectTypeBuilder.class);
        this.mockObjectFieldTypeBuilder = (ObjectFieldTypeBuilder)Mockito.mock(ObjectFieldTypeBuilder.class);
        this.mockObjectType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)this.mockContext.getTypeLoader()).thenReturn((Object)this.mockTypeLoader);
        Mockito.when((Object)this.mockContext.getTypeBuilder()).thenReturn((Object)this.mockTypeBuilder);
        Mockito.when((Object)this.mockTypeBuilder.objectType()).thenReturn((Object)this.mockObjectTypeBuilder);
        Mockito.when((Object)this.mockObjectTypeBuilder.addField()).thenReturn((Object)this.mockObjectFieldTypeBuilder);
        Mockito.when((Object)this.mockObjectFieldTypeBuilder.key(ArgumentMatchers.anyString())).thenReturn((Object)this.mockObjectFieldTypeBuilder);
        Mockito.when((Object)this.mockObjectFieldTypeBuilder.value((MetadataType)ArgumentMatchers.any(MetadataType.class))).thenReturn((Object)this.mockObjectFieldTypeBuilder);
        Mockito.when((Object)this.mockObjectFieldTypeBuilder.required(((Boolean)ArgumentMatchers.any(Boolean.class)).booleanValue())).thenReturn((Object)this.mockObjectFieldTypeBuilder);
        Mockito.when((Object)this.mockObjectTypeBuilder.build()).thenReturn((Object)this.mockObjectType);
    }

    @Test
    public void testClassHasCorrectName() {
        MatcherAssert.assertThat((Object)this.resolver.getClass().getSimpleName(), (Matcher)CoreMatchers.is((Object)"SelectMetadataResolver"));
    }

    @Test
    public void testClassHasCorrectPackage() {
        MatcherAssert.assertThat((Object)this.resolver.getClass().getPackage().getName(), (Matcher)CoreMatchers.is((Object)"org.mule.db.commons.internal.domain.metadata"));
    }

    @Test
    public void testClassExtendsBaseDbMetadataResolver() {
        MatcherAssert.assertThat((Object)(this.resolver instanceof BaseDbMetadataResolver), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testGetCategoryName() {
        MatcherAssert.assertThat((Object)this.resolver.getCategoryName(), (Matcher)CoreMatchers.is((Object)"DbCategory"));
    }

    @Test
    public void testGetResolverName() {
        MatcherAssert.assertThat((Object)this.resolver.getResolverName(), (Matcher)CoreMatchers.is((Object)"SelectResolver"));
    }

    @Test
    public void testGetOutputTypeWithNullQuery() {
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, null));
    }

    @Test
    public void testGetOutputTypeWithEmptyQuery() {
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, ""));
    }

    @Test
    public void testGetOutputType_ConnectionException() throws SQLException, ConnectionException {
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.empty());
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_PreparedStatementSQLException() throws SQLException, ConnectionException {
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.of(this.mockDbConnection));
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new SQLException("Prepare failed")});
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_GetMetadataSQLException() throws SQLException, ConnectionException {
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.of(this.mockDbConnection));
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getMetaData()).thenThrow(new Throwable[]{new SQLException("Metadata failed")});
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_NullResultSetMetaData() throws SQLException, ConnectionException {
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.of(this.mockDbConnection));
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getMetaData()).thenReturn(null);
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_SQLExceptionDuringColumnProcessing() throws SQLException, ConnectionException {
        this.setupValidConnectionWithMetadata();
        Mockito.when((Object)this.mockResultSetMetaData.getColumnCount()).thenThrow(new Throwable[]{new SQLException("Column processing failed")});
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_SQLExceptionDuringColumnType() throws SQLException, ConnectionException {
        this.setupValidConnectionWithMetadata();
        Mockito.when((Object)this.mockResultSetMetaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnType(1)).thenThrow(new Throwable[]{new SQLException("Column type failed")});
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_SQLExceptionDuringColumnClassName() throws SQLException, ConnectionException {
        this.setupValidConnectionWithMetadata();
        Mockito.when((Object)this.mockResultSetMetaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnType(1)).thenReturn((Object)12);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnClassName(1)).thenThrow(new Throwable[]{new SQLException("Column class name failed")});
        Assert.assertThrows(MetadataResolvingException.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
    }

    @Test
    public void testGetOutputType_SQLExceptionDuringColumnLabel() throws SQLException, ConnectionException {
        this.setupValidConnectionWithMetadata();
        Mockito.when((Object)this.mockResultSetMetaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnType(1)).thenReturn((Object)12);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnClassName(1)).thenReturn((Object)"java.lang.String");
        Mockito.when((Object)this.mockResultSetMetaData.getColumnLabel(1)).thenThrow(new Throwable[]{new SQLException("Column label failed")});
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
        Assert.assertTrue((String)"Expected MetadataResolvingException or NullPointerException", (exception instanceof MetadataResolvingException || exception instanceof NullPointerException ? 1 : 0) != 0);
    }

    @Test
    public void testGetOutputType_SQLExceptionDuringIsNullable() throws SQLException, ConnectionException {
        this.setupValidConnectionWithMetadata();
        Mockito.when((Object)this.mockResultSetMetaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnType(1)).thenReturn((Object)12);
        Mockito.when((Object)this.mockResultSetMetaData.getColumnClassName(1)).thenReturn((Object)"java.lang.String");
        Mockito.when((Object)this.mockResultSetMetaData.getColumnLabel(1)).thenReturn((Object)"test_col");
        Mockito.when((Object)this.mockResultSetMetaData.isNullable(1)).thenThrow(new Throwable[]{new SQLException("IsNullable failed")});
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> this.resolver.getOutputType(this.mockContext, "SELECT * FROM test"));
        Assert.assertTrue((String)"Expected MetadataResolvingException or NullPointerException", (exception instanceof MetadataResolvingException || exception instanceof NullPointerException ? 1 : 0) != 0);
    }

    private void setupValidConnectionWithMetadata() throws SQLException, ConnectionException {
        Mockito.when((Object)this.mockContext.getConnection()).thenReturn(Optional.of(this.mockDbConnection));
        Mockito.when((Object)this.mockDbConnection.getJdbcConnection()).thenReturn((Object)this.mockJdbcConnection);
        Mockito.when((Object)this.mockJdbcConnection.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)this.mockPreparedStatement);
        Mockito.when((Object)this.mockPreparedStatement.getMetaData()).thenReturn((Object)this.mockResultSetMetaData);
    }
}

