/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.param;

import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;

public class DefaultInputQueryParamTest {
    @Test
    public void testConstructorWithValue() {
        ResolvedDbType dbType = new ResolvedDbType(12, "VARCHAR");
        String value = "test value";
        DefaultInputQueryParam param = new DefaultInputQueryParam(1, (DbType)dbType, (Object)value);
        Assert.assertEquals((long)1L, (long)param.getIndex());
        Assert.assertEquals((Object)dbType, (Object)param.getType());
        Assert.assertEquals((Object)value, (Object)param.getValue());
        Assert.assertNull((Object)param.getName());
    }

    @Test
    public void testConstructorWithValueAndName() {
        ResolvedDbType dbType = new ResolvedDbType(4, "INTEGER");
        Integer value = 42;
        String name = "age";
        DefaultInputQueryParam param = new DefaultInputQueryParam(2, (DbType)dbType, (Object)value, name);
        Assert.assertEquals((long)2L, (long)param.getIndex());
        Assert.assertEquals((Object)dbType, (Object)param.getType());
        Assert.assertEquals((Object)value, (Object)param.getValue());
        Assert.assertEquals((Object)name, (Object)param.getName());
    }

    @Test
    public void testConstructorWithNullValue() {
        ResolvedDbType dbType = new ResolvedDbType(12, "VARCHAR");
        DefaultInputQueryParam param = new DefaultInputQueryParam(1, (DbType)dbType, null);
        Assert.assertEquals((long)1L, (long)param.getIndex());
        Assert.assertEquals((Object)dbType, (Object)param.getType());
        Assert.assertNull((Object)param.getValue());
        Assert.assertNull((Object)param.getName());
    }

    @Test
    public void testConstructorWithNullName() {
        ResolvedDbType dbType = new ResolvedDbType(12, "VARCHAR");
        String value = "test";
        DefaultInputQueryParam param = new DefaultInputQueryParam(1, (DbType)dbType, (Object)value, null);
        Assert.assertEquals((long)1L, (long)param.getIndex());
        Assert.assertEquals((Object)dbType, (Object)param.getType());
        Assert.assertEquals((Object)value, (Object)param.getValue());
        Assert.assertNull((Object)param.getName());
    }

    @Test
    public void testGetValueWithDifferentTypes() {
        ResolvedDbType dbType = new ResolvedDbType(12, "VARCHAR");
        DefaultInputQueryParam stringParam = new DefaultInputQueryParam(1, (DbType)dbType, (Object)"string value");
        Assert.assertEquals((Object)"string value", (Object)stringParam.getValue());
        DefaultInputQueryParam intParam = new DefaultInputQueryParam(2, (DbType)dbType, (Object)123);
        Assert.assertEquals((Object)123, (Object)intParam.getValue());
        DefaultInputQueryParam boolParam = new DefaultInputQueryParam(3, (DbType)dbType, (Object)true);
        Assert.assertEquals((Object)true, (Object)boolParam.getValue());
        DefaultInputQueryParam doubleParam = new DefaultInputQueryParam(4, (DbType)dbType, (Object)3.14);
        Assert.assertEquals((Object)3.14, (Object)doubleParam.getValue());
    }

    @Test
    public void testEqualsAndHashCode() {
        ResolvedDbType dbType = new ResolvedDbType(12, "VARCHAR");
        DefaultInputQueryParam param1 = new DefaultInputQueryParam(1, (DbType)dbType, (Object)"value", "name");
        DefaultInputQueryParam param2 = new DefaultInputQueryParam(1, (DbType)dbType, (Object)"value", "name");
        DefaultInputQueryParam param3 = new DefaultInputQueryParam(2, (DbType)dbType, (Object)"value", "name");
        Assert.assertNotEquals((Object)param1, (Object)param2);
        Assert.assertNotEquals((long)param1.hashCode(), (long)param2.hashCode());
    }

    @Test
    public void testToString() {
        ResolvedDbType dbType = new ResolvedDbType(12, "VARCHAR");
        DefaultInputQueryParam param = new DefaultInputQueryParam(1, (DbType)dbType, (Object)"test value", "test_name");
        String toString = param.toString();
        Assert.assertTrue((boolean)toString.contains("DefaultInputQueryParam"));
    }
}

