/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.statement;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysStrategy;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.DefaultInputQueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.domain.statement.QueryStatementFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueryStatementFactoryTestCase
extends AbstractMuleTestCase {
    private final String sqlText = "call test";
    private final String selectSql = "SELECT * FROM users";
    private final String insertSql = "INSERT INTO users (name) VALUES (?)";
    private CallableStatement createdCallableStatement;
    private PreparedStatement createdPreparedStatement;
    private Statement createdStatement;
    private DatabaseMetaData metadata;
    private DbConnection connection;
    private Connection jdbcConnection;
    private QueryStatementFactory factory;

    @Before
    public void setUp() throws Exception {
        this.createdCallableStatement = (CallableStatement)Mockito.mock(CallableStatement.class);
        this.createdPreparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.createdStatement = (Statement)Mockito.mock(Statement.class);
        this.metadata = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        this.connection = (DbConnection)Mockito.mock(DbConnection.class);
        this.jdbcConnection = (Connection)Mockito.mock(Connection.class);
        this.factory = new QueryStatementFactory();
        Mockito.when((Object)this.connection.getJdbcConnection()).thenReturn((Object)this.jdbcConnection);
        Mockito.when((Object)this.jdbcConnection.getMetaData()).thenReturn((Object)this.metadata);
    }

    @Test
    public void createsPreparedStatementsWithScrolling() throws SQLException {
        Mockito.when((Object)this.metadata.supportsResultSetType(1004)).thenReturn((Object)true);
        Mockito.when((Object)this.jdbcConnection.prepareCall("call test", 1004, 1007)).thenReturn((Object)this.createdCallableStatement);
        this.checkStatementCreated(this.connection);
    }

    @Test
    public void createsPreparedStatementsWithForwardOnly() throws SQLException {
        Mockito.when((Object)this.metadata.supportsResultSetType(1004)).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.supportsResultSetType(1005)).thenReturn((Object)false);
        Mockito.when((Object)this.jdbcConnection.prepareCall("call test", 1003, 1007)).thenReturn((Object)this.createdCallableStatement);
        this.checkStatementCreated(this.connection);
    }

    @Test
    public void createsPreparedStatementsWithScrollSensitive() throws SQLException {
        Mockito.when((Object)this.metadata.supportsResultSetType(1004)).thenReturn((Object)false);
        Mockito.when((Object)this.metadata.supportsResultSetType(1005)).thenReturn((Object)true);
        Mockito.when((Object)this.jdbcConnection.prepareCall("call test", 1005, 1007)).thenReturn((Object)this.createdCallableStatement);
        this.checkStatementCreated(this.connection);
    }

    @Test
    public void createsStatementForQueryWithoutParameters() throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).createStatement();
        ((Connection)Mockito.verify((Object)this.jdbcConnection, (VerificationMode)Mockito.never())).prepareStatement("SELECT * FROM users");
    }

    @Test
    public void createsPreparedStatementForQueryWithParameters() throws SQLException {
        DefaultInputQueryParam param = new DefaultInputQueryParam(0, null, (Object)"John", "name");
        QueryTemplate queryTemplate = new QueryTemplate("INSERT INTO users (name) VALUES (?)", QueryType.INSERT, Arrays.asList(param));
        Mockito.when((Object)this.jdbcConnection.prepareStatement("INSERT INTO users (name) VALUES (?)")).thenReturn((Object)this.createdPreparedStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdPreparedStatement));
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).prepareStatement("INSERT INTO users (name) VALUES (?)");
        ((Connection)Mockito.verify((Object)this.jdbcConnection, (VerificationMode)Mockito.never())).createStatement();
    }

    @Test
    public void createsPreparedStatementWithAutoGenerateKeysStrategy() throws SQLException {
        DefaultInputQueryParam param = new DefaultInputQueryParam(0, null, (Object)"John", "name");
        QueryTemplate queryTemplate = new QueryTemplate("INSERT INTO users (name) VALUES (?)", QueryType.INSERT, Arrays.asList(param));
        AutoGenerateKeysStrategy strategy = (AutoGenerateKeysStrategy)Mockito.mock(AutoGenerateKeysStrategy.class);
        Mockito.when((Object)strategy.prepareStatement(this.connection, queryTemplate)).thenReturn((Object)this.createdPreparedStatement);
        Statement result = this.factory.create(this.connection, queryTemplate, strategy);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdPreparedStatement));
        ((AutoGenerateKeysStrategy)Mockito.verify((Object)strategy)).prepareStatement(this.connection, queryTemplate);
    }

    @Test
    public void setsMaxRowsWhenConfigured() throws SQLException {
        this.factory.setMaxRows(100);
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement)).setMaxRows(100);
    }

    @Test
    public void setsFetchSizeWhenConfigured() throws SQLException {
        this.factory.setFetchSize(50);
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement)).setFetchSize(50);
    }

    @Test
    public void setsQueryTimeoutWhenConfigured() throws SQLException {
        this.factory.setQueryTimeout(30);
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement)).setQueryTimeout(30);
    }

    @Test
    public void doesNotSetMaxRowsWhenNotConfigured() throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement, (VerificationMode)Mockito.never())).setMaxRows(ArgumentMatchers.anyInt());
    }

    @Test
    public void doesNotSetFetchSizeWhenNotConfigured() throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement, (VerificationMode)Mockito.never())).setFetchSize(ArgumentMatchers.anyInt());
    }

    @Test
    public void doesNotSetQueryTimeoutWhenNotConfigured() throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement, (VerificationMode)Mockito.never())).setQueryTimeout(ArgumentMatchers.anyInt());
    }

    @Test
    public void setsAllPropertiesWhenAllConfigured() throws SQLException {
        this.factory.setMaxRows(100);
        this.factory.setFetchSize(50);
        this.factory.setQueryTimeout(30);
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Statement)Mockito.verify((Object)this.createdStatement)).setMaxRows(100);
        ((Statement)Mockito.verify((Object)this.createdStatement)).setFetchSize(50);
        ((Statement)Mockito.verify((Object)this.createdStatement)).setQueryTimeout(30);
    }

    @Test
    public void throwsExceptionForNegativeQueryTimeout() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.factory.setQueryTimeout(-1));
    }

    @Test
    public void acceptsZeroQueryTimeout() {
        this.factory.setQueryTimeout(0);
    }

    @Test
    public void acceptsPositiveQueryTimeout() {
        this.factory.setQueryTimeout(1);
    }

    @Test
    public void createsStatementWithAutoGenerateKeysStrategyForQueryWithoutParameters() throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        AutoGenerateKeysStrategy strategy = (AutoGenerateKeysStrategy)Mockito.mock(AutoGenerateKeysStrategy.class);
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenReturn((Object)this.createdStatement);
        Statement result = this.factory.create(this.connection, queryTemplate, strategy);
        Assert.assertThat((Object)result, (Matcher)Matchers.is((Object)this.createdStatement));
        ((Connection)Mockito.verify((Object)this.jdbcConnection)).createStatement();
        ((AutoGenerateKeysStrategy)Mockito.verify((Object)strategy, (VerificationMode)Mockito.never())).prepareStatement(this.connection, queryTemplate);
    }

    @Test
    public void handlesSQLExceptionFromCreateStatement() throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("SELECT * FROM users", QueryType.SELECT, Collections.emptyList());
        SQLException sqlException = new SQLException("Database error");
        Mockito.when((Object)this.jdbcConnection.createStatement()).thenThrow(new Throwable[]{sqlException});
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.factory.create(this.connection, queryTemplate));
        Assert.assertEquals((Object)sqlException, (Object)exception);
    }

    @Test
    public void handlesSQLExceptionFromPrepareStatement() throws SQLException {
        DefaultInputQueryParam param = new DefaultInputQueryParam(0, null, (Object)"John", "name");
        QueryTemplate queryTemplate = new QueryTemplate("INSERT INTO users (name) VALUES (?)", QueryType.INSERT, Arrays.asList(param));
        SQLException sqlException = new SQLException("Database error");
        Mockito.when((Object)this.jdbcConnection.prepareStatement("INSERT INTO users (name) VALUES (?)")).thenThrow(new Throwable[]{sqlException});
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.factory.create(this.connection, queryTemplate));
        Assert.assertEquals((Object)sqlException, (Object)exception);
    }

    @Test
    public void handlesSQLExceptionFromPrepareCall() throws SQLException {
        Mockito.when((Object)this.metadata.supportsResultSetType(1004)).thenReturn((Object)true);
        SQLException sqlException = new SQLException("Database error");
        Mockito.when((Object)this.jdbcConnection.prepareCall("call test", 1004, 1007)).thenThrow(new Throwable[]{sqlException});
        SQLException exception = (SQLException)Assert.assertThrows(SQLException.class, () -> this.checkStatementCreated(this.connection));
        Assert.assertEquals((Object)sqlException, (Object)exception);
    }

    private void checkStatementCreated(DbConnection connection) throws SQLException {
        QueryTemplate queryTemplate = new QueryTemplate("call test", QueryType.STORE_PROCEDURE_CALL, Collections.emptyList());
        CallableStatement statement = (CallableStatement)this.factory.create(connection, queryTemplate);
        Assert.assertThat((Object)statement, (Matcher)Matchers.is((Object)this.createdCallableStatement));
    }
}

