/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.BlobDbType;
import org.mule.runtime.api.exception.MuleRuntimeException;

public class BlobDbTypeTestCase {
    private BlobDbType blobDbType;
    private PreparedStatement mockStatement;
    private Connection mockConnection;
    private Blob mockBlob;
    private DbConnection mockDbConnection;

    @Before
    public void setUp() throws SQLException {
        this.blobDbType = new BlobDbType(2004, "BLOB");
        this.mockStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.mockConnection = (Connection)Mockito.mock(Connection.class);
        this.mockBlob = (Blob)Mockito.mock(Blob.class);
        this.mockDbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)this.mockStatement.getConnection()).thenReturn((Object)this.mockConnection);
        Mockito.when((Object)this.mockConnection.createBlob()).thenReturn((Object)this.mockBlob);
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((long)2004L, (long)this.blobDbType.getId());
        Assert.assertEquals((Object)"BLOB", (Object)this.blobDbType.getName());
    }

    @Test
    public void testSetParameterValueWithByteArray() throws SQLException {
        byte[] byteArray = "test data".getBytes();
        int index = 1;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)byteArray, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, byteArray);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithInputStream() throws SQLException {
        String testData = "test input stream data";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(testData.getBytes());
        int index = 2;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)inputStream, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, testData.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithString() throws SQLException {
        String testString = "test string data";
        int index = 3;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)testString, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, testString.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithNull() throws SQLException {
        int index = 4;
        this.blobDbType.setParameterValue(this.mockStatement, index, null, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setNull(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithUnsupportedType() throws SQLException {
        Integer unsupportedValue = 123;
        int index = 5;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)unsupportedValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)unsupportedValue), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithLargeByteArray() throws SQLException {
        byte[] largeByteArray = new byte[10000];
        for (int i = 0; i < largeByteArray.length; ++i) {
            largeByteArray[i] = (byte)(i % 256);
        }
        int index = 6;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)largeByteArray, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, largeByteArray);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithEmptyByteArray() throws SQLException {
        byte[] emptyByteArray = new byte[]{};
        int index = 7;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)emptyByteArray, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, emptyByteArray);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithEmptyString() throws SQLException {
        String emptyString = "";
        int index = 8;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)emptyString, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, emptyString.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithSpecialCharacters() throws SQLException {
        String specialChars = "!@#$%^&*()_+-=[]{}|;':\",./<>?";
        int index = 9;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)specialChars, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, specialChars.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithUnicodeString() throws SQLException {
        String unicodeString = "Hello \u4e16\u754c \ud83c\udf0d";
        int index = 10;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)unicodeString, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, unicodeString.getBytes());
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithDifferentIndexes() throws SQLException {
        byte[] byteArray = "test".getBytes();
        this.blobDbType.setParameterValue(this.mockStatement, 1, (Object)byteArray, this.mockDbConnection);
        this.blobDbType.setParameterValue(this.mockStatement, 100, (Object)byteArray, this.mockDbConnection);
        this.blobDbType.setParameterValue(this.mockStatement, 0, (Object)byteArray, this.mockDbConnection);
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.times((int)3))).createBlob();
        ((Blob)Mockito.verify((Object)this.mockBlob, (VerificationMode)Mockito.times((int)3))).setBytes(1L, byteArray);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)100), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((Object)this.mockBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithInputStreamIOException() throws SQLException {
        InputStream mockInputStream = (InputStream)Mockito.mock(InputStream.class);
        int index = 11;
        try {
            Mockito.when((Object)mockInputStream.read((byte[])ArgumentMatchers.any(byte[].class))).thenThrow(new Throwable[]{new IOException("Test IO exception")});
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertThrows(MuleRuntimeException.class, () -> this.blobDbType.setParameterValue(this.mockStatement, index, (Object)mockInputStream, this.mockDbConnection));
    }

    @Test
    public void testSetParameterValueWithBlobObject() throws SQLException {
        Blob existingBlob = (Blob)Mockito.mock(Blob.class);
        int index = 12;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)existingBlob, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)existingBlob), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithBoolean() throws SQLException {
        Boolean booleanValue = true;
        int index = 13;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)booleanValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)booleanValue), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithDouble() throws SQLException {
        Double doubleValue = 123.456;
        int index = 14;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)doubleValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)doubleValue), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithFloat() throws SQLException {
        Float floatValue = Float.valueOf(123.456f);
        int index = 15;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)floatValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)floatValue), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithLong() throws SQLException {
        Long longValue = 123456789L;
        int index = 16;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)longValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)longValue), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithShort() throws SQLException {
        Short shortValue = 123;
        int index = 17;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)shortValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)shortValue), ArgumentMatchers.eq((int)2004));
    }

    @Test
    public void testSetParameterValueWithCharacter() throws SQLException {
        Character charValue = Character.valueOf('A');
        int index = 18;
        this.blobDbType.setParameterValue(this.mockStatement, index, (Object)charValue, this.mockDbConnection);
        ((PreparedStatement)Mockito.verify((Object)this.mockStatement)).setObject(ArgumentMatchers.eq((int)index), ArgumentMatchers.eq((Object)charValue), ArgumentMatchers.eq((int)2004));
    }
}

