/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.parser.QueryTemplateParsingException;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryTemplateParsingExceptionTestCase {
    @Test
    public void testConstructorWithMessage() {
        String message = "Test parsing error message";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithNullMessage() {
        QueryTemplateParsingException exception = new QueryTemplateParsingException(null);
        Assert.assertNotNull((Object)exception);
        Assert.assertNull((Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithEmptyMessage() {
        String message = "";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithWhitespaceMessage() {
        String message = "   ";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithLongMessage() {
        String message = "This is a very long error message that contains detailed information about what went wrong during the SQL parsing process. It should include specific details about the problematic SQL statement and the exact location where the parsing failed.";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithSpecialCharacters() {
        String message = "Error parsing SQL: SELECT * FROM users WHERE name = 'John's data' AND id = :id";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithUnicodeCharacters() {
        String message = "Error parsing SQL with unicode: SELECT * FROM users WHERE name = 'Jos\u00e9 Mar\u00eda'";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testExceptionCanBeThrown() {
        String message = "Test exception";
        QueryTemplateParsingException exception = (QueryTemplateParsingException)Assert.assertThrows(QueryTemplateParsingException.class, () -> {
            throw new QueryTemplateParsingException(message);
        });
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testExceptionInheritance() {
        String message = "Test inheritance";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertTrue((boolean)(exception instanceof RuntimeException));
        Assert.assertTrue((boolean)(exception instanceof Exception));
        Assert.assertTrue((boolean)(exception instanceof Throwable));
    }

    @Test
    public void testExceptionStackTrace() {
        String message = "Test stack trace";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception.getStackTrace());
        Assert.assertTrue((exception.getStackTrace().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExceptionToString() {
        String message = "Test toString";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        String toString = exception.toString();
        Assert.assertNotNull((Object)toString);
        Assert.assertTrue((boolean)toString.contains("QueryTemplateParsingException"));
        Assert.assertTrue((boolean)toString.contains(message));
    }

    @Test
    public void testExceptionWithCause() {
        String message = "Test with cause";
        RuntimeException cause = new RuntimeException("Original cause");
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testMultipleExceptions() {
        String message1 = "First exception";
        String message2 = "Second exception";
        QueryTemplateParsingException exception1 = new QueryTemplateParsingException(message1);
        QueryTemplateParsingException exception2 = new QueryTemplateParsingException(message2);
        Assert.assertNotNull((Object)exception1);
        Assert.assertNotNull((Object)exception2);
        Assert.assertEquals((Object)message1, (Object)exception1.getMessage());
        Assert.assertEquals((Object)message2, (Object)exception2.getMessage());
        Assert.assertNotEquals((Object)exception1.getMessage(), (Object)exception2.getMessage());
    }

    @Test
    public void testExceptionWithSQLSyntax() {
        String message = "Invalid SQL syntax: SELECT * FROM users WHERE id = :id AND name = 'John'";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("SELECT"));
        Assert.assertTrue((boolean)exception.getMessage().contains("FROM"));
    }

    @Test
    public void testExceptionWithParameterPlaceholders() {
        String message = "Error parsing parameters: :id, :name, :email";
        QueryTemplateParsingException exception = new QueryTemplateParsingException(message);
        Assert.assertNotNull((Object)exception);
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains(":id"));
        Assert.assertTrue((boolean)exception.getMessage().contains(":name"));
        Assert.assertTrue((boolean)exception.getMessage().contains(":email"));
    }
}

