/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.internal.parser.statement.detector.UnknownStatementTypeException;

@RunWith(value=MockitoJUnitRunner.class)
public class UnknownStatementTypeExceptionTestCase {
    @Test
    public void testConstructorWithMessage() {
        String message = "Cannot detect statement type for query: INVALID SQL";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithNullMessage() {
        UnknownStatementTypeException exception = new UnknownStatementTypeException(null);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertNull((Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithEmptyMessage() {
        String message = "";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithWhitespaceMessage() {
        String message = "   ";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithLongMessage() {
        String message = "This is a very long error message that contains detailed information about what went wrong during the statement type detection process. It should include specific details about the problematic SQL statement and why the type could not be determined.";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithSQLQuery() {
        String message = "Cannot detect the statement type for query: INVALID SQL STATEMENT";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("INVALID SQL STATEMENT"));
    }

    @Test
    public void testConstructorWithSpecialCharacters() {
        String message = "Cannot detect statement type: SELECT * FROM users WHERE name = 'John's data'";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testConstructorWithUnicodeCharacters() {
        String message = "Cannot detect statement type: SELECT * FROM users WHERE name = 'Jos\u00e9 Mar\u00eda'";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testExceptionCanBeThrown() {
        String message = "Test exception";
        UnknownStatementTypeException exception = (UnknownStatementTypeException)Assert.assertThrows(UnknownStatementTypeException.class, () -> {
            throw new UnknownStatementTypeException(message);
        });
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
    }

    @Test
    public void testExceptionInheritance() {
        String message = "Test inheritance";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertTrue((boolean)(exception instanceof Exception));
        Assert.assertTrue((boolean)(exception instanceof Throwable));
        Assert.assertNotNull((Object)((Object)exception));
    }

    @Test
    public void testExceptionStackTrace() {
        String message = "Test stack trace";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)exception.getStackTrace());
        Assert.assertTrue((exception.getStackTrace().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExceptionToString() {
        String message = "Test toString";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        String toString = exception.toString();
        Assert.assertNotNull((Object)toString);
        Assert.assertTrue((boolean)toString.contains("UnknownStatementTypeException"));
        Assert.assertTrue((boolean)toString.contains(message));
    }

    @Test
    public void testMultipleExceptions() {
        String message1 = "First exception";
        String message2 = "Second exception";
        UnknownStatementTypeException exception1 = new UnknownStatementTypeException(message1);
        UnknownStatementTypeException exception2 = new UnknownStatementTypeException(message2);
        Assert.assertNotNull((Object)((Object)exception1));
        Assert.assertNotNull((Object)((Object)exception2));
        Assert.assertEquals((Object)message1, (Object)exception1.getMessage());
        Assert.assertEquals((Object)message2, (Object)exception2.getMessage());
        Assert.assertNotEquals((Object)exception1.getMessage(), (Object)exception2.getMessage());
    }

    @Test
    public void testExceptionWithComplexSQL() {
        String message = "Cannot detect statement type for: WITH temp AS (SELECT * FROM users) SELECT u.name, t.data FROM temp t JOIN users u ON t.id = u.id WHERE u.active = true";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("WITH"));
        Assert.assertTrue((boolean)exception.getMessage().contains("SELECT"));
        Assert.assertTrue((boolean)exception.getMessage().contains("JOIN"));
    }

    @Test
    public void testExceptionWithStoredProcedure() {
        String message = "Cannot detect statement type for: CALL complex_procedure(:param1, :param2)";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("CALL"));
        Assert.assertTrue((boolean)exception.getMessage().contains("complex_procedure"));
    }

    @Test
    public void testExceptionWithDDL() {
        String message = "Cannot detect statement type for: CREATE TABLE users (id INT, name VARCHAR(100))";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("CREATE TABLE"));
    }

    @Test
    public void testExceptionWithDML() {
        String message = "Cannot detect statement type for: INSERT INTO users (name, email) VALUES ('John', 'john@example.com')";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("INSERT INTO"));
    }

    @Test
    public void testExceptionWithParameterizedQuery() {
        String message = "Cannot detect statement type for: SELECT * FROM users WHERE id = :id AND name = :name";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains(":id"));
        Assert.assertTrue((boolean)exception.getMessage().contains(":name"));
    }

    @Test
    public void testExceptionWithSubquery() {
        String message = "Cannot detect statement type for: SELECT * FROM users WHERE id IN (SELECT user_id FROM orders)";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("IN (SELECT"));
    }

    @Test
    public void testExceptionWithUnion() {
        String message = "Cannot detect statement type for: SELECT * FROM users UNION SELECT * FROM users_backup";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("UNION"));
    }

    @Test
    public void testExceptionWithCaseStatement() {
        String message = "Cannot detect statement type for: SELECT CASE WHEN id = 1 THEN 'one' ELSE 'other' END FROM users";
        UnknownStatementTypeException exception = new UnknownStatementTypeException(message);
        Assert.assertNotNull((Object)((Object)exception));
        Assert.assertEquals((Object)message, (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.getMessage().contains("CASE WHEN"));
    }
}

