/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.api.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;

public class ParameterizedStatementDefinitionTestCase {
    @Test
    public void testConstructorWithUseColumnNumbers() {
        String sql = "SELECT * FROM test_table WHERE id = :id";
        ArrayList<ParameterType> parameterTypes = new ArrayList<ParameterType>();
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("id", 123);
        int queryTimeout = 30;
        TimeUnit queryTimeoutUnit = TimeUnit.SECONDS;
        Integer fetchSize = 100;
        Integer maxRows = 1000;
        boolean useColumnNumbers = true;
        TestParameterizedStatement statement = new TestParameterizedStatement(sql, parameterTypes, inputParameters, queryTimeout, queryTimeoutUnit, fetchSize, maxRows, useColumnNumbers);
        Assert.assertEquals((Object)sql, (Object)statement.getSql());
        Assert.assertEquals(inputParameters, (Object)statement.getInputParameters());
        Assert.assertEquals((long)queryTimeout, (long)statement.getQueryTimeout());
        Assert.assertEquals((Object)((Object)queryTimeoutUnit), (Object)((Object)statement.getQueryTimeoutUnit()));
        Assert.assertEquals((Object)fetchSize, (Object)statement.getFetchSize());
        Assert.assertEquals((Object)maxRows, (Object)statement.getMaxRows());
        Assert.assertTrue((boolean)statement.isUseColumnNumbers());
    }

    private static class TestParameterizedStatement
    extends ParameterizedStatementDefinition<TestParameterizedStatement> {
        public TestParameterizedStatement() {
        }

        public TestParameterizedStatement(String sql, List<ParameterType> parameterTypes, Map<String, Object> inputParameters, int queryTimeout, TimeUnit queryTimeoutUnit, Integer fetchSize, Integer maxRows) {
            super(sql, parameterTypes, inputParameters, queryTimeout, queryTimeoutUnit, fetchSize, maxRows);
        }

        public TestParameterizedStatement(String sql, List<ParameterType> parameterTypes, Map<String, Object> inputParameters, int queryTimeout, TimeUnit queryTimeoutUnit, Integer fetchSize, Integer maxRows, boolean useColumnNumbers) {
            super(sql, parameterTypes, inputParameters, queryTimeout, queryTimeoutUnit, fetchSize, maxRows, useColumnNumbers);
        }
    }
}

