/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.api.param;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.db.commons.api.param.QuerySettings;

public class QuerySettingsTestCase {
    @Test
    public void testDefaultUseColumnNumbers() {
        QuerySettings settings = new QuerySettings();
        Assert.assertFalse((String)"Default value should be false", (boolean)settings.isUseColumnNumbers());
    }

    @Test
    public void testSetUseColumnNumbers() {
        QuerySettings settings = new QuerySettings();
        settings.setUseColumnNumbers(true);
        Assert.assertTrue((String)"Should be true after setting", (boolean)settings.isUseColumnNumbers());
        settings.setUseColumnNumbers(false);
        Assert.assertFalse((String)"Should be false after setting", (boolean)settings.isUseColumnNumbers());
    }

    @Test
    public void testConstructorWithUseColumnNumbers() {
        QuerySettings settings = new QuerySettings(30, TimeUnit.SECONDS, Integer.valueOf(100), Integer.valueOf(1000), true);
        Assert.assertTrue((String)"Should be true when set in constructor", (boolean)settings.isUseColumnNumbers());
        Assert.assertEquals((String)"Query timeout should be 30", (long)30L, (long)settings.getQueryTimeout());
        Assert.assertEquals((String)"Query timeout unit should be SECONDS", (Object)((Object)TimeUnit.SECONDS), (Object)((Object)settings.getQueryTimeoutUnit()));
        Assert.assertEquals((String)"Fetch size should be 100", (Object)100, (Object)settings.getFetchSize());
        Assert.assertEquals((String)"Max rows should be 1000", (Object)1000, (Object)settings.getMaxRows());
    }

    @Test
    public void testCopyIntoPreservesUseColumnNumbers() {
        QuerySettings original = new QuerySettings();
        original.setUseColumnNumbers(true);
        QuerySettings copy = new QuerySettings();
        original.copyInto(copy);
        Assert.assertTrue((String)"Copy should preserve useColumnNumbers flag", (boolean)copy.isUseColumnNumbers());
    }
}

