/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.connection;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.ByteArrayInputStream;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.api.exception.connection.ConnectionClosingException;
import org.mule.db.commons.api.param.JdbcType;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.runtime.api.tx.TransactionException;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultDbConnectionTestCase {
    @Mock
    private Connection mockConnection;
    @Mock
    private DatabaseMetaData mockDatabaseMetaData;
    @Mock
    private PreparedStatement mockPreparedStatement;
    @Mock
    private Array mockArray;
    @Mock
    private Struct mockStruct;
    @Mock
    private Blob mockBlob;
    @Mock
    private Clob mockClob;
    @Mock
    private ResultSet mockResultSet;
    private DefaultDbConnection defaultDbConnection;
    private List<DbType> customDataTypes;

    @Before
    public void setUp() throws SQLException {
        this.customDataTypes = new ArrayList<DbType>();
        this.defaultDbConnection = new DefaultDbConnection(this.mockConnection, this.customDataTypes);
        Mockito.when((Object)this.mockConnection.getMetaData()).thenReturn((Object)this.mockDatabaseMetaData);
        Mockito.when((Object)this.mockConnection.createBlob()).thenReturn((Object)this.mockBlob);
        Mockito.when((Object)this.mockConnection.createClob()).thenReturn((Object)this.mockClob);
        Mockito.when((Object)this.mockConnection.prepareStatement(Mockito.anyString())).thenReturn((Object)this.mockPreparedStatement);
    }

    @Test
    public void testConstructorWithCache() {
        DefaultDbConnection connection = new DefaultDbConnection(this.mockConnection, this.customDataTypes, Caffeine.newBuilder().maximumSize(100L).build());
        Assert.assertNotNull((Object)connection);
    }

    @Test
    public void testConstructorWithoutCache() {
        DefaultDbConnection connection = new DefaultDbConnection(this.mockConnection, this.customDataTypes);
        Assert.assertNotNull((Object)connection);
    }

    @Test
    public void testGetJdbcConnection() {
        Connection result = this.defaultDbConnection.getJdbcConnection();
        Assert.assertEquals((Object)this.mockConnection, (Object)result);
    }

    @Test
    public void testGetCustomDataTypes() {
        List result = this.defaultDbConnection.getCustomDataTypes();
        Assert.assertEquals(this.customDataTypes, (Object)result);
    }

    @Test
    public void testGetVendorDataTypes() {
        List result = this.defaultDbConnection.getVendorDataTypes();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testBeginTransaction() throws SQLException, TransactionException {
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)true);
        this.defaultDbConnection.begin();
        ((Connection)Mockito.verify((Object)this.mockConnection)).setAutoCommit(false);
        Assert.assertTrue((boolean)this.defaultDbConnection.isTransactionActive());
    }

    @Test
    public void testBeginTransactionWhenAutoCommitIsFalse() throws SQLException, TransactionException {
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)false);
        this.defaultDbConnection.begin();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).setAutoCommit(false);
        Assert.assertTrue((boolean)this.defaultDbConnection.isTransactionActive());
    }

    @Test(expected=TransactionException.class)
    public void testBeginTransactionWithException() throws SQLException, TransactionException {
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenThrow(new Throwable[]{new SQLException("Test exception")});
        this.defaultDbConnection.begin();
    }

    @Test
    public void testCommitTransaction() throws SQLException, TransactionException {
        this.defaultDbConnection.begin();
        this.defaultDbConnection.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection)).commit();
        Assert.assertFalse((boolean)this.defaultDbConnection.isTransactionActive());
    }

    @Test(expected=TransactionException.class)
    public void testCommitTransactionWithException() throws SQLException, TransactionException {
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Test exception")}).when((Object)this.mockConnection)).commit();
        this.defaultDbConnection.commit();
    }

    @Test
    public void testRollbackTransaction() throws SQLException, TransactionException {
        this.defaultDbConnection.begin();
        this.defaultDbConnection.rollback();
        ((Connection)Mockito.verify((Object)this.mockConnection)).rollback();
        Assert.assertFalse((boolean)this.defaultDbConnection.isTransactionActive());
    }

    @Test(expected=TransactionException.class)
    public void testRollbackTransactionWithException() throws SQLException, TransactionException {
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Test exception")}).when((Object)this.mockConnection)).rollback();
        this.defaultDbConnection.rollback();
    }

    @Test
    public void testRelease() throws SQLException {
        this.defaultDbConnection.release();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    public void testReleaseWithException() throws SQLException {
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException("Test exception")}).when((Object)this.mockConnection)).close();
        try {
            this.defaultDbConnection.release();
            Assert.fail((String)"Expected ConnectionClosingException");
        }
        catch (ConnectionClosingException e) {
            Assert.assertNotNull((Object)((Object)e));
        }
    }

    @Test
    public void testReleaseIfInactive() throws SQLException {
        this.defaultDbConnection.releaseIfInactive();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    public void testReleaseIfInactiveWhenTransactionActive() throws SQLException, TransactionException {
        this.defaultDbConnection.begin();
        this.defaultDbConnection.releaseIfInactive();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testStreamingMethods() {
        Assert.assertFalse((boolean)this.defaultDbConnection.isStreaming());
        this.defaultDbConnection.beginStreaming();
        Assert.assertTrue((boolean)this.defaultDbConnection.isStreaming());
        this.defaultDbConnection.endStreaming();
        Assert.assertFalse((boolean)this.defaultDbConnection.isStreaming());
    }

    @Test
    public void testMultipleStreaming() {
        this.defaultDbConnection.beginStreaming();
        this.defaultDbConnection.beginStreaming();
        Assert.assertTrue((boolean)this.defaultDbConnection.isStreaming());
        this.defaultDbConnection.endStreaming();
        Assert.assertTrue((boolean)this.defaultDbConnection.isStreaming());
        this.defaultDbConnection.endStreaming();
        Assert.assertFalse((boolean)this.defaultDbConnection.isStreaming());
    }

    @Test
    public void testEndStreamingWhenZero() {
        this.defaultDbConnection.endStreaming();
        Assert.assertFalse((boolean)this.defaultDbConnection.isStreaming());
    }

    @Test
    public void testLobStreamingMethods() {
        Assert.assertFalse((boolean)this.defaultDbConnection.hasActiveLobStreams());
        this.defaultDbConnection.incrementActiveLobStreams();
        Assert.assertTrue((boolean)this.defaultDbConnection.hasActiveLobStreams());
        this.defaultDbConnection.decrementActiveLobStreams();
        Assert.assertFalse((boolean)this.defaultDbConnection.hasActiveLobStreams());
    }

    @Test
    public void testMultipleLobStreaming() {
        this.defaultDbConnection.incrementActiveLobStreams();
        this.defaultDbConnection.incrementActiveLobStreams();
        Assert.assertTrue((boolean)this.defaultDbConnection.hasActiveLobStreams());
        this.defaultDbConnection.decrementActiveLobStreams();
        Assert.assertTrue((boolean)this.defaultDbConnection.hasActiveLobStreams());
        this.defaultDbConnection.decrementActiveLobStreams();
        Assert.assertFalse((boolean)this.defaultDbConnection.hasActiveLobStreams());
    }

    @Test
    public void testDecrementLobStreamingWhenZero() {
        this.defaultDbConnection.decrementActiveLobStreams();
        Assert.assertFalse((boolean)this.defaultDbConnection.hasActiveLobStreams());
    }

    @Test
    public void testAbortActiveLobStreams() {
        this.defaultDbConnection.incrementActiveLobStreams();
        this.defaultDbConnection.incrementActiveLobStreams();
        Assert.assertTrue((boolean)this.defaultDbConnection.hasActiveLobStreams());
        this.defaultDbConnection.abortActiveLobStreams();
        Assert.assertFalse((boolean)this.defaultDbConnection.hasActiveLobStreams());
    }

    @Test
    public void testGetCacheTemplates() {
        Assert.assertNotNull((Object)this.defaultDbConnection.getCacheTemplates());
    }

    @Test
    public void testPrepareStatement() throws SQLException {
        PreparedStatement result = this.defaultDbConnection.prepareStatement("SELECT * FROM test");
        Assert.assertEquals((Object)this.mockPreparedStatement, (Object)result);
        ((Connection)Mockito.verify((Object)this.mockConnection)).prepareStatement("SELECT * FROM test");
    }

    @Test
    public void testGetMetaData() throws SQLException {
        DatabaseMetaData result = this.defaultDbConnection.getMetaData();
        Assert.assertEquals((Object)this.mockDatabaseMetaData, (Object)result);
        ((Connection)Mockito.verify((Object)this.mockConnection)).getMetaData();
    }

    @Test
    public void testSupportsContentStreamingWithDB2() throws SQLException {
        Mockito.when((Object)this.mockDatabaseMetaData.getDatabaseProductName()).thenReturn((Object)"DB2");
        boolean result = this.defaultDbConnection.supportsContentStreaming();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testSupportsContentStreamingWithOtherDatabase() throws SQLException {
        Mockito.when((Object)this.mockDatabaseMetaData.getDatabaseProductName()).thenReturn((Object)"MySQL");
        boolean result = this.defaultDbConnection.supportsContentStreaming();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testSupportsContentStreamingWithException() throws SQLException {
        Mockito.when((Object)this.mockDatabaseMetaData.getDatabaseProductName()).thenThrow(new Throwable[]{new SQLException("Test exception")});
        boolean result = this.defaultDbConnection.supportsContentStreaming();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testDoResolveLobInWithBlob() throws SQLException {
        Object[] attributes = new Object[]{"test"};
        String dataTypeName = JdbcType.BLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
    }

    @Test
    public void testDoResolveLobInWithClob() throws SQLException {
        Object[] attributes = new Object[]{"test"};
        String dataTypeName = JdbcType.CLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createClob();
    }

    @Test
    public void testDoResolveLobInWithBlobDataType() throws SQLException {
        Object[] attributes = new Object[]{"test"};
        int dataType = JdbcType.BLOB.getDbType().getId();
        String dataTypeName = "BLOB";
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataType, dataTypeName);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createBlob();
    }

    @Test
    public void testDoResolveLobInWithClobDataType() throws SQLException {
        Object[] attributes = new Object[]{"test"};
        int dataType = JdbcType.CLOB.getDbType().getId();
        String dataTypeName = "CLOB";
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataType, dataTypeName);
        ((Connection)Mockito.verify((Object)this.mockConnection)).createClob();
    }

    @Test
    public void testCreateBlobWithByteArray() throws SQLException {
        Object[] attributes = new Object[]{"test".getBytes()};
        String dataTypeName = JdbcType.BLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, "test".getBytes());
    }

    @Test
    public void testCreateBlobWithInputStream() throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test".getBytes());
        Object[] attributes = new Object[]{inputStream};
        String dataTypeName = JdbcType.BLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(Mockito.eq((long)1L), (byte[])Mockito.any(byte[].class));
    }

    @Test
    public void testCreateBlobWithString() throws SQLException {
        Object[] attributes = new Object[]{"test"};
        String dataTypeName = JdbcType.BLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Blob)Mockito.verify((Object)this.mockBlob)).setBytes(1L, "test".getBytes());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateBlobWithInvalidType() throws SQLException {
        Object[] attributes = new Object[]{123};
        String dataTypeName = JdbcType.BLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
    }

    @Test
    public void testCreateClobWithString() throws SQLException {
        Object[] attributes = new Object[]{"test"};
        String dataTypeName = JdbcType.CLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Clob)Mockito.verify((Object)this.mockClob)).setString(1L, "test");
    }

    @Test
    public void testCreateClobWithInputStream() throws SQLException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test".getBytes());
        Object[] attributes = new Object[]{inputStream};
        String dataTypeName = JdbcType.CLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
        ((Clob)Mockito.verify((Object)this.mockClob)).setString(Mockito.eq((long)1L), Mockito.anyString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateClobWithInvalidType() throws SQLException {
        Object[] attributes = new Object[]{123};
        String dataTypeName = JdbcType.CLOB.getDbType().getName();
        this.defaultDbConnection.doResolveLobIn(attributes, 0, dataTypeName);
    }

    @Test
    public void testAbortStreamingOnCommit() throws SQLException, TransactionException {
        this.defaultDbConnection.beginStreaming();
        Assert.assertTrue((boolean)this.defaultDbConnection.isStreaming());
        this.defaultDbConnection.commit();
        Assert.assertFalse((boolean)this.defaultDbConnection.isStreaming());
    }

    @Test
    public void testAbortStreamingOnRollback() throws SQLException, TransactionException {
        this.defaultDbConnection.beginStreaming();
        Assert.assertTrue((boolean)this.defaultDbConnection.isStreaming());
        this.defaultDbConnection.rollback();
        Assert.assertFalse((boolean)this.defaultDbConnection.isStreaming());
    }

    @Test
    public void testReleaseWhenStreaming() throws SQLException {
        this.defaultDbConnection.beginStreaming();
        this.defaultDbConnection.release();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testReleaseWhenLobStreaming() throws SQLException {
        this.defaultDbConnection.incrementActiveLobStreams();
        this.defaultDbConnection.release();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
    }
}

