/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.domain.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DynamicDbType;

public class DynamicDbTypeTestCase {
    private static final String TEST_NAME = "DYNAMIC_TYPE";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private DynamicDbType dynamicDbType;
    private PreparedStatement preparedStatement;
    private CallableStatement callableStatement;
    private DbConnection dbConnection;

    @Before
    public void setUp() throws Exception {
        this.dynamicDbType = new DynamicDbType(TEST_NAME);
        this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.callableStatement = (CallableStatement)Mockito.mock(CallableStatement.class);
        this.dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
    }

    @Test
    public void testConstructor() {
        Assert.assertEquals((Object)TEST_NAME, (Object)this.dynamicDbType.getName());
    }

    @Test
    public void testConstructorWithNullName() {
        DynamicDbType nullNameType = new DynamicDbType(null);
        Assert.assertNull((Object)nullNameType.getName());
    }

    @Test
    public void testConstructorWithEmptyName() {
        DynamicDbType emptyNameType = new DynamicDbType("");
        Assert.assertEquals((Object)"", (Object)emptyNameType.getName());
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)TEST_NAME, (Object)this.dynamicDbType.getName());
    }

    @Test
    public void testGetNameWithSpecialCharacters() {
        DynamicDbType specialType = new DynamicDbType("SPECIAL_TYPE_123!@#");
        Assert.assertEquals((Object)"SPECIAL_TYPE_123!@#", (Object)specialType.getName());
    }

    @Test
    public void testGetIdThrowsUnsupportedOperationException() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.getId();
    }

    @Test
    public void testSetParameterValueThrowsUnsupportedOperationException() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.setParameterValue(this.preparedStatement, 1, (Object)"test", this.dbConnection);
    }

    @Test
    public void testSetParameterValueThrowsUnsupportedOperationExceptionWithNullValue() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.setParameterValue(this.preparedStatement, 1, null, this.dbConnection);
    }

    @Test
    public void testSetParameterValueThrowsUnsupportedOperationExceptionWithDifferentIndex() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.setParameterValue(this.preparedStatement, 5, (Object)"test", this.dbConnection);
    }

    @Test
    public void testGetParameterValueThrowsUnsupportedOperationException() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.getParameterValue(this.callableStatement, 1);
    }

    @Test
    public void testGetParameterValueThrowsUnsupportedOperationExceptionWithDifferentIndex() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.getParameterValue(this.callableStatement, 10);
    }

    @Test
    public void testRegisterOutParameterThrowsUnsupportedOperationException() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.registerOutParameter(this.callableStatement, 1);
    }

    @Test
    public void testRegisterOutParameterThrowsUnsupportedOperationExceptionWithDifferentIndex() throws SQLException {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.dynamicDbType.registerOutParameter(this.callableStatement, 3);
    }

    @Test
    public void testMultipleInstances() {
        DynamicDbType type1 = new DynamicDbType("TYPE_1");
        DynamicDbType type2 = new DynamicDbType("TYPE_2");
        Assert.assertEquals((Object)"TYPE_1", (Object)type1.getName());
        Assert.assertEquals((Object)"TYPE_2", (Object)type2.getName());
        try {
            type1.getId();
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            type2.getId();
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testImplementsDbType() {
        Assert.assertTrue((boolean)(this.dynamicDbType instanceof DbType));
    }

    @Test
    public void testToString() {
        String toString = this.dynamicDbType.toString();
        Assert.assertNotNull((Object)toString);
        Assert.assertTrue((boolean)toString.contains("DynamicDbType"));
    }

    @Test
    public void testEqualsAndHashCode() {
        DynamicDbType type1 = new DynamicDbType(TEST_NAME);
        DynamicDbType type2 = new DynamicDbType(TEST_NAME);
        DynamicDbType type3 = new DynamicDbType("DIFFERENT_NAME");
        Assert.assertFalse((boolean)type1.equals(type2));
        Assert.assertFalse((boolean)type1.equals(type3));
        Assert.assertFalse((boolean)type1.equals(null));
        Assert.assertTrue((boolean)type1.equals(type1));
        Assert.assertNotEquals((long)type1.hashCode(), (long)type2.hashCode());
        Assert.assertNotEquals((long)type1.hashCode(), (long)type3.hashCode());
    }

    @Test
    public void testExceptionMessages() {
        try {
            this.dynamicDbType.getId();
            Assert.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertTrue((e.getMessage() == null || e.getMessage().isEmpty() ? 1 : 0) != 0);
        }
    }
}

