/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.operation;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.db.commons.AbstractDbConnector;
import org.mule.db.commons.api.StatementResult;
import org.mule.db.commons.api.param.ParameterizedStatementDefinition;
import org.mule.db.commons.api.param.QueryDefinition;
import org.mule.db.commons.api.param.StoredProcedureCall;
import org.mule.db.commons.internal.StatementStreamingResultSetCloser;
import org.mule.db.commons.internal.domain.autogeneratedkey.AutoGenerateKeysAttributes;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.connection.DefaultDbConnection;
import org.mule.db.commons.internal.domain.executor.QueryExecutor;
import org.mule.db.commons.internal.domain.executor.UpdateExecutor;
import org.mule.db.commons.internal.domain.param.InputQueryParam;
import org.mule.db.commons.internal.domain.query.Query;
import org.mule.db.commons.internal.domain.query.QueryParamValue;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.statement.ConfigurableStatementFactory;
import org.mule.db.commons.internal.domain.statement.QueryStatementFactory;
import org.mule.db.commons.internal.domain.statement.StatementFactory;
import org.mule.db.commons.internal.domain.type.CompositeDbTypeManager;
import org.mule.db.commons.internal.operation.DmlOperations;
import org.mule.db.commons.internal.parser.SimpleQueryTemplateParser;
import org.mule.db.commons.internal.resolver.query.ParameterizedQueryResolver;
import org.mule.db.commons.internal.resolver.query.QueryResolutionException;
import org.mule.db.commons.internal.resolver.query.QueryResolver;
import org.mule.db.commons.internal.resolver.query.StoredProcedureQueryResolver;
import org.mule.db.commons.internal.result.resultset.IteratorResultSetHandler;
import org.mule.db.commons.internal.result.resultset.ResultSetIterator;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.runtime.operation.FlowListener;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class DmlOperationsIntegrationTest {
    private static final String DB_URL = "jdbc:h2:mem:testdb_" + UUID.randomUUID().toString().replace("-", "") + ";DB_CLOSE_DELAY=-1";
    private static final String DB_USER = "sa";
    private static final String DB_PASSWORD = "";
    private Connection jdbcConnection;
    private DbConnection dbConnection;
    private DmlOperations dmlOperations;
    private AbstractDbConnector mockConnector;
    private StreamingHelper mockStreamingHelper;
    private FlowListener mockFlowListener;

    @Before
    public void setUp() throws SQLException {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("H2 database driver not found. Please ensure h2 dependency is included.", e);
        }
        this.jdbcConnection = DriverManager.getConnection(DB_URL, DB_USER, DB_PASSWORD);
        this.createTestTable();
        this.dbConnection = new DefaultDbConnection(this.jdbcConnection, Collections.emptyList());
        this.mockConnector = (AbstractDbConnector)Mockito.mock(AbstractDbConnector.class);
        CompositeDbTypeManager typeManager = new CompositeDbTypeManager(Collections.emptyList());
        Mockito.when((Object)this.mockConnector.getTypeManager()).thenReturn((Object)typeManager);
        Mockito.when((Object)this.mockConnector.getCharset()).thenReturn((Object)StandardCharsets.UTF_8);
        this.mockStreamingHelper = (StreamingHelper)Mockito.mock(StreamingHelper.class);
        this.mockFlowListener = (FlowListener)Mockito.mock(FlowListener.class);
        this.dmlOperations = this.createDmlOperations();
    }

    @After
    public void tearDown() throws SQLException {
        if (this.jdbcConnection != null && !this.jdbcConnection.isClosed()) {
            try (Statement stmt = this.jdbcConnection.createStatement();){
                stmt.execute("DROP TABLE IF EXISTS test_users");
            }
            this.jdbcConnection.close();
        }
    }

    private void createTestTable() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.execute("DROP TABLE IF EXISTS test_users");
            stmt.execute("CREATE TABLE test_users (id INT AUTO_INCREMENT PRIMARY KEY,name VARCHAR(100) NOT NULL,email VARCHAR(100) UNIQUE,age INT,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
        }
    }

    private DmlOperations createDmlOperations() {
        QueryResolver<ParameterizedStatementDefinition> customQueryResolver = new QueryResolver<ParameterizedStatementDefinition>(){

            public Query resolve(ParameterizedStatementDefinition statementDefinition, AbstractDbConnector connector, DbConnection connection, StreamingHelper streamingHelper) throws QueryResolutionException {
                SimpleQueryTemplateParser parser = new SimpleQueryTemplateParser();
                QueryTemplate queryTemplate = parser.parse(statementDefinition.getSql());
                System.out.println("DEBUG: Resolving query: " + statementDefinition.getSql());
                System.out.println("DEBUG: Available parameters: " + statementDefinition.getInputParameters());
                ArrayList<QueryParamValue> paramValues = new ArrayList<QueryParamValue>();
                for (InputQueryParam param : queryTemplate.getInputParams()) {
                    String paramName = param.getName();
                    Optional paramValue = statementDefinition.getInputParameter(paramName);
                    System.out.println("DEBUG: Looking for parameter: " + paramName + ", found: " + paramValue.isPresent());
                    if (paramValue.isPresent()) {
                        Object value = ((Reference)paramValue.get()).get();
                        System.out.println("DEBUG: Parameter value: " + value);
                        paramValues.add(new QueryParamValue(paramName, value));
                        continue;
                    }
                    throw new IllegalArgumentException("Parameter '" + paramName + "' was not bound for query '" + statementDefinition.getSql() + "'");
                }
                System.out.println("DEBUG: Final param values: " + paramValues);
                System.out.println("DEBUG: Query template: " + queryTemplate);
                Query query = new Query(queryTemplate, paramValues);
                System.out.println("DEBUG: Final query: " + query);
                return query;
            }
        };
        StoredProcedureQueryResolver storedProcedureResolver = new StoredProcedureQueryResolver();
        QueryStatementFactory statementFactory = new QueryStatementFactory();
        BiFunction selectRowHandler = DmlOperations.getDefaultInsensitiveMapRowHandler();
        BiFunction querySingleRowHandler = DmlOperations.getDefaultNonStreamingInsensitiveMapRowHandler();
        BiFunction storedProcedureRowHandler = DmlOperations.getDefaultInsensitiveMapRowHandler();
        BiFunction selectQueryExecutor = DmlOperations.getDefaultSelectExecutor();
        BiFunction querySingleQueryExecutor = DmlOperations.getDefaultSelectExecutor();
        Function<ConfigurableStatementFactory, QueryExecutor> updateExecutor = factory -> new UpdateExecutor((StatementFactory)factory);
        return new DmlOperations.Builder().withQueryResolver((QueryResolver)customQueryResolver).withStoredProcedureQueryResolver((ParameterizedQueryResolver)storedProcedureResolver).withStatementFactory((ConfigurableStatementFactory)statementFactory).withSelectRowHandler(selectRowHandler).withQuerySingleRowHandler(querySingleRowHandler).withStoredProcedureRowHandler(storedProcedureRowHandler).withSelectQueryExecutor(selectQueryExecutor).withQuerySingleQueryExecutor(querySingleQueryExecutor).withUpdateExecutor(updateExecutor).build();
    }

    @Test
    public void testInsertOperationWithAutoGeneratedKeys() throws SQLException {
        QueryDefinition queryDef = this.createInsertQueryDefinition();
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        StatementResult result = this.dmlOperations.insert(queryDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        this.verifyRecordInserted();
    }

    @Test
    public void testInsertOperationWithoutAutoGeneratedKeys() throws SQLException {
        QueryDefinition queryDef = this.createInsertQueryDefinition();
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(false);
        StatementResult result = this.dmlOperations.insert(queryDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        this.verifyRecordInserted();
    }

    @Test
    public void testInsertOperationWithParameters() throws SQLException {
        QueryDefinition queryDef = this.createInsertQueryDefinitionWithParameters();
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        StatementResult result = this.dmlOperations.insert(queryDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        this.verifyParameterizedRecordInserted();
    }

    @Test
    public void testInsertOperationWithMultipleRecords() throws SQLException {
        QueryDefinition queryDef1 = this.createInsertQueryDefinition("John Doe", "john@example.com", 30);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        StatementResult result1 = this.dmlOperations.insert(queryDef1, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertEquals((long)1L, (long)result1.getAffectedRows());
        QueryDefinition queryDef2 = this.createInsertQueryDefinition("Jane Smith", "jane@example.com", 25);
        StatementResult result2 = this.dmlOperations.insert(queryDef2, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertEquals((long)1L, (long)result2.getAffectedRows());
        this.verifyMultipleRecordsInserted();
    }

    @Test
    public void testUpdateOperation() throws SQLException {
        QueryDefinition insertDef = this.createInsertQueryDefinition("Original User", "original@example.com", 25);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        this.dmlOperations.insert(insertDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        QueryDefinition updateDef = this.createUpdateQueryDefinition("Updated User", "updated@example.com", 30);
        StatementResult result = this.dmlOperations.update(updateDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        this.verifyRecordUpdated();
    }

    @Test
    public void testUpdateOperationWithParameters() throws SQLException {
        QueryDefinition insertDef = this.createInsertQueryDefinition("Param User", "param@example.com", 25);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        this.dmlOperations.insert(insertDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        QueryDefinition updateDef = this.createUpdateQueryDefinitionWithParameters("Parameterized Update", "paramupdate@example.com", 35);
        StatementResult result = this.dmlOperations.update(updateDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        this.verifyParameterizedRecordUpdated();
    }

    @Test
    public void testDeleteOperation() throws SQLException {
        QueryDefinition insertDef = this.createInsertQueryDefinition("Delete User", "delete@example.com", 25);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        this.dmlOperations.insert(insertDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        QueryDefinition deleteDef = this.createDeleteQueryDefinition("Delete User");
        int affectedRows = this.dmlOperations.delete(deleteDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertEquals((long)1L, (long)affectedRows);
        this.verifyRecordDeleted();
    }

    @Test
    public void testDeleteOperationWithParameters() throws SQLException {
        QueryDefinition insertDef = this.createInsertQueryDefinition("Param Delete User", "paramdelete@example.com", 25);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(true);
        this.dmlOperations.insert(insertDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        QueryDefinition deleteDef = this.createDeleteQueryDefinitionWithParameters("Param Delete User");
        int affectedRows = this.dmlOperations.delete(deleteDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertEquals((long)1L, (long)affectedRows);
        this.verifyParameterizedRecordDeleted();
    }

    @Test
    public void testSelectOperation() throws SQLException {
        Throwable throwable;
        ResultSet rs;
        QueryDefinition insertDef = new QueryDefinition();
        insertDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        insertDef.addInputParameter("name", (Object)"Select User");
        insertDef.addInputParameter("email", (Object)"select@example.com");
        insertDef.addInputParameter("age", (Object)25);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(false);
        StatementResult insertResult = this.dmlOperations.insert(insertDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)insertResult);
        Assert.assertEquals((long)1L, (long)insertResult.getAffectedRows());
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Select User'");
            throwable = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        stmt = this.jdbcConnection.createStatement();
        var5_5 = null;
        try {
            rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Select User'");
            throwable = null;
            try {
                Assert.assertTrue((boolean)rs.next());
                System.out.println("DEBUG: Found record - NAME: " + rs.getString("name") + ", EMAIL: " + rs.getString("email") + ", AGE: " + rs.getInt("age"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (stmt != null) {
                if (var5_5 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        QueryDefinition selectDef = this.createSelectQueryDefinition();
        Map row = this.dmlOperations.querySingle(selectDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        System.out.println("DEBUG: Row: " + row);
        System.out.println("DEBUG: NAME value: " + row.get("name"));
        System.out.println("DEBUG: EMAIL value: " + row.get("email"));
        System.out.println("DEBUG: AGE value: " + row.get("age"));
        Assert.assertNotNull((Object)row);
        Assert.assertEquals((Object)"Select User", row.get("name"));
        Assert.assertEquals((Object)"select@example.com", row.get("email"));
        Assert.assertEquals((Object)25, row.get("age"));
    }

    @Test
    public void testSelectOperationWithParameters() throws SQLException {
        Throwable throwable;
        ResultSet rs2;
        try (PreparedStatement pstmt = this.jdbcConnection.prepareStatement("INSERT INTO test_users (name, email, age) VALUES (?, ?, ?)");){
            pstmt.setString(1, "Param Select User");
            pstmt.setString(2, "paramselect@example.com");
            pstmt.setInt(3, 30);
            int result = pstmt.executeUpdate();
            Assert.assertEquals((long)1L, (long)result);
        }
        var2_2 = null;
        try (Statement stmt = this.jdbcConnection.createStatement();){
            rs2 = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Param Select User'");
            throwable = null;
            try {
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((long)1L, (long)rs2.getInt(1));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs2 != null) {
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs2.close();
                    }
                }
            }
        }
        catch (Throwable rs2) {
            var2_2 = rs2;
            throw rs2;
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try {
            rs2 = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Param Select User'");
            throwable = null;
            try {
                Assert.assertTrue((boolean)rs2.next());
                System.out.println("DEBUG: Found record - NAME: " + rs2.getString("name") + ", EMAIL: " + rs2.getString("email") + ", AGE: " + rs2.getInt("age"));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (rs2 != null) {
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        rs2.close();
                    }
                }
            }
        }
        catch (Throwable rs3) {
            var2_2 = rs3;
            throw rs3;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable rs3) {
                        var2_2.addSuppressed(rs3);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        pstmt = this.jdbcConnection.prepareStatement("SELECT * FROM test_users WHERE name = ?");
        var2_2 = null;
        try {
            pstmt.setString(1, "Param Select User");
            rs2 = pstmt.executeQuery();
            throwable = null;
            try {
                Assert.assertTrue((boolean)rs2.next());
                System.out.println("DEBUG: Direct JDBC query - NAME: " + rs2.getString("name") + ", EMAIL: " + rs2.getString("email") + ", AGE: " + rs2.getInt("age"));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (rs2 != null) {
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        rs2.close();
                    }
                }
            }
        }
        catch (Throwable rs4) {
            var2_2 = rs4;
            throw rs4;
        }
        finally {
            if (pstmt != null) {
                if (var2_2 != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Throwable rs4) {
                        var2_2.addSuppressed(rs4);
                    }
                } else {
                    pstmt.close();
                }
            }
        }
        QueryDefinition selectDef = this.createSelectQueryDefinitionWithParameters("Param Select User");
        System.out.println("DEBUG: SQL: " + selectDef.getSql());
        System.out.println("DEBUG: Parameters: " + selectDef.getInputParameters());
        QueryDefinition simpleSelectDef = new QueryDefinition();
        simpleSelectDef.setSql("SELECT * FROM test_users WHERE name = 'Param Select User'");
        System.out.println("DEBUG: Simple SQL: " + simpleSelectDef.getSql());
        PagingProvider simplePagingProvider = this.dmlOperations.select(simpleSelectDef, this.mockConnector, this.mockStreamingHelper, this.mockFlowListener);
        Assert.assertNotNull((Object)simplePagingProvider);
        List simplePage = simplePagingProvider.getPage((Object)this.dbConnection);
        Assert.assertNotNull((Object)simplePage);
        Assert.assertFalse((boolean)simplePage.isEmpty());
        System.out.println("DEBUG: Simple page size: " + simplePage.size());
        Map simpleRow = (Map)simplePage.get(0);
        System.out.println("DEBUG: Simple row: " + simpleRow);
        System.out.println("DEBUG: Simple row keys: " + simpleRow.keySet());
        System.out.println("DEBUG: Simple NAME value: " + simpleRow.get("NAME"));
        System.out.println("DEBUG: Simple name value: " + simpleRow.get("name"));
        PagingProvider pagingProvider = this.dmlOperations.select(selectDef, this.mockConnector, this.mockStreamingHelper, this.mockFlowListener);
        Assert.assertNotNull((Object)pagingProvider);
        List page = pagingProvider.getPage((Object)this.dbConnection);
        Assert.assertNotNull((Object)page);
        Assert.assertFalse((boolean)page.isEmpty());
        System.out.println("DEBUG: Page size: " + page.size());
        Map row = (Map)page.get(0);
        System.out.println("DEBUG: Row: " + row);
        System.out.println("DEBUG: All keys in row: " + row.keySet());
        System.out.println("DEBUG: NAME value: " + row.get("NAME"));
        System.out.println("DEBUG: name value: " + row.get("name"));
        System.out.println("DEBUG: EMAIL value: " + row.get("EMAIL"));
        System.out.println("DEBUG: email value: " + row.get("email"));
        System.out.println("DEBUG: AGE value: " + row.get("AGE"));
        System.out.println("DEBUG: age value: " + row.get("age"));
        Assert.assertNotNull((Object)row);
        Assert.assertTrue((String)"Row should contain data but DmlOperations framework is not working correctly", (row.containsKey("NAME") && row.containsKey("EMAIL") && row.containsKey("AGE") ? 1 : 0) != 0);
    }

    @Test
    public void testQuerySingleOperation() throws SQLException {
        QueryDefinition insertDef = new QueryDefinition();
        insertDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        insertDef.addInputParameter("name", (Object)"QuerySingle User");
        insertDef.addInputParameter("email", (Object)"querysingle@example.com");
        insertDef.addInputParameter("age", (Object)28);
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(false);
        StatementResult insertResult = this.dmlOperations.insert(insertDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)insertResult);
        Assert.assertEquals((long)1L, (long)insertResult.getAffectedRows());
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'QuerySingle User'");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
        QueryDefinition querySingleDef = this.createQuerySingleDefinition("QuerySingle User");
        Map result = this.dmlOperations.querySingle(querySingleDef, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"QuerySingle User", result.get("NAME"));
        Assert.assertEquals((Object)"querysingle@example.com", result.get("EMAIL"));
        Assert.assertEquals((Object)28, result.get("AGE"));
    }

    @Test
    public void testStoredProcedureOperation() throws SQLException {
        this.createTestStoredProcedure();
        StoredProcedureCall storedProcCall = this.createStoredProcedureCall();
        Map result = this.dmlOperations.storedProcedure(storedProcCall, (AutoGenerateKeysAttributes)new TestAutoGenerateKeysAttributes(false), this.mockConnector, this.dbConnection, this.mockStreamingHelper, this.mockFlowListener);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testParameterSetting() {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        queryDef.addInputParameter("name", (Object)"Test User");
        queryDef.addInputParameter("email", (Object)"test@example.com");
        queryDef.addInputParameter("age", (Object)25);
        Assert.assertTrue((boolean)queryDef.getInputParameter("name").isPresent());
        Assert.assertEquals((Object)"Test User", (Object)((Reference)queryDef.getInputParameter("name").get()).get());
        Assert.assertTrue((boolean)queryDef.getInputParameter("email").isPresent());
        Assert.assertEquals((Object)"test@example.com", (Object)((Reference)queryDef.getInputParameter("email").get()).get());
        Assert.assertTrue((boolean)queryDef.getInputParameter("age").isPresent());
        Assert.assertEquals((Object)25, (Object)((Reference)queryDef.getInputParameter("age").get()).get());
        Map params = queryDef.getInputParameters();
        Assert.assertEquals((long)3L, (long)params.size());
        Assert.assertEquals((Object)"Test User", params.get("name"));
        Assert.assertEquals((Object)"test@example.com", params.get("email"));
        Assert.assertEquals((Object)25, params.get("age"));
    }

    private QueryDefinition createInsertQueryDefinition() {
        return this.createInsertQueryDefinition("Test User", "test@example.com", 25);
    }

    private QueryDefinition createInsertQueryDefinition(String name, String email, int age) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        queryDef.addInputParameter("name", (Object)name);
        queryDef.addInputParameter("email", (Object)email);
        queryDef.addInputParameter("age", (Object)age);
        return queryDef;
    }

    private QueryDefinition createInsertQueryDefinitionWithParameters() {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        queryDef.addInputParameter("name", (Object)"Parameterized User");
        queryDef.addInputParameter("email", (Object)"param@example.com");
        queryDef.addInputParameter("age", (Object)35);
        return queryDef;
    }

    private QueryDefinition createUpdateQueryDefinition(String name, String email, int age) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("UPDATE test_users SET name = :name, email = :email, age = :age WHERE name = 'Original User'");
        queryDef.addInputParameter("name", (Object)name);
        queryDef.addInputParameter("email", (Object)email);
        queryDef.addInputParameter("age", (Object)age);
        return queryDef;
    }

    private QueryDefinition createUpdateQueryDefinitionWithParameters(String name, String email, int age) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("UPDATE test_users SET name = :name, email = :email, age = :age WHERE name = :whereName");
        queryDef.addInputParameter("name", (Object)name);
        queryDef.addInputParameter("email", (Object)email);
        queryDef.addInputParameter("age", (Object)age);
        queryDef.addInputParameter("whereName", (Object)"Param User");
        return queryDef;
    }

    private QueryDefinition createDeleteQueryDefinition(String name) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("DELETE FROM test_users WHERE name = :name");
        queryDef.addInputParameter("name", (Object)name);
        return queryDef;
    }

    private QueryDefinition createDeleteQueryDefinitionWithParameters(String name) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("DELETE FROM test_users WHERE name = :name");
        queryDef.addInputParameter("name", (Object)name);
        return queryDef;
    }

    private QueryDefinition createSelectQueryDefinition() {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("SELECT * FROM test_users WHERE name = 'Select User'");
        return queryDef;
    }

    private QueryDefinition createSimpleSelectQueryDefinition() {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("SELECT * FROM test_users");
        return queryDef;
    }

    private QueryDefinition createSelectQueryDefinitionWithParameters(String name) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("SELECT * FROM test_users WHERE name = :name");
        queryDef.addInputParameter("name", (Object)name);
        return queryDef;
    }

    private QueryDefinition createQuerySingleDefinition(String name) {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("SELECT * FROM test_users WHERE name = :name");
        queryDef.addInputParameter("name", (Object)name);
        return queryDef;
    }

    private void createTestStoredProcedure() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.execute("CREATE ALIAS IF NOT EXISTS GET_USER_COUNT AS $$ String getUserCount() {   return \"SELECT COUNT(*) as count FROM test_users\"; } $$");
        }
    }

    private StoredProcedureCall createStoredProcedureCall() {
        StoredProcedureCall storedProcCall = new StoredProcedureCall();
        storedProcCall.setSql("CALL GET_USER_COUNT()");
        return storedProcCall;
    }

    private void verifyRecordInserted() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Test User'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    private void verifyParameterizedRecordInserted() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Parameterized User'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    private void verifyMultipleRecordsInserted() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    private void verifyRecordUpdated() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Updated User'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    private void verifyParameterizedRecordUpdated() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Parameterized Update'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
        }
    }

    private void verifyRecordDeleted() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Delete User'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
        }
    }

    private void verifyParameterizedRecordDeleted() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM test_users WHERE name = 'Param Delete User'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testSimpleInsertOperation() throws SQLException {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES ('Simple User', 'simple@example.com', 30)");
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(false);
        StatementResult result = this.dmlOperations.insert(queryDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Simple User'");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Simple User", (Object)rs.getString("name"));
            Assert.assertEquals((Object)"simple@example.com", (Object)rs.getString("email"));
            Assert.assertEquals((long)30L, (long)rs.getInt("age"));
        }
    }

    @Test
    public void testWorkingInsertOperation() throws SQLException {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        queryDef.addInputParameter("name", (Object)"Working User");
        queryDef.addInputParameter("email", (Object)"working@example.com");
        queryDef.addInputParameter("age", (Object)40);
        Assert.assertTrue((boolean)queryDef.getInputParameter("name").isPresent());
        Assert.assertEquals((Object)"Working User", (Object)((Reference)queryDef.getInputParameter("name").get()).get());
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(false);
        StatementResult result = this.dmlOperations.insert(queryDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Working User'");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Working User", (Object)rs.getString("name"));
            Assert.assertEquals((Object)"working@example.com", (Object)rs.getString("email"));
            Assert.assertEquals((long)40L, (long)rs.getInt("age"));
        }
    }

    @Test
    public void testDebugParameterResolution() {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        queryDef.addInputParameter("name", (Object)"Debug User");
        queryDef.addInputParameter("email", (Object)"debug@example.com");
        queryDef.addInputParameter("age", (Object)50);
        Assert.assertTrue((boolean)queryDef.getInputParameter("name").isPresent());
        Assert.assertEquals((Object)"Debug User", (Object)((Reference)queryDef.getInputParameter("name").get()).get());
        SimpleQueryTemplateParser parser = new SimpleQueryTemplateParser();
        QueryTemplate queryTemplate = parser.parse(queryDef.getSql());
        System.out.println("SQL Text: " + queryTemplate.getSqlText());
        System.out.println("Input Params Count: " + queryTemplate.getInputParams().size());
        for (int i = 0; i < queryTemplate.getInputParams().size(); ++i) {
            InputQueryParam param = (InputQueryParam)queryTemplate.getInputParams().get(i);
            System.out.println("Param " + i + ": name='" + param.getName() + "', value='" + param.getValue() + "'");
        }
        ArrayList<QueryParamValue> paramValues = new ArrayList<QueryParamValue>();
        for (InputQueryParam param : queryTemplate.getInputParams()) {
            String paramName = param.getName();
            Optional paramValue = queryDef.getInputParameter(paramName);
            if (paramValue.isPresent()) {
                paramValues.add(new QueryParamValue(paramName, ((Reference)paramValue.get()).get()));
                System.out.println("Resolved param '" + paramName + "' = '" + ((Reference)paramValue.get()).get() + "'");
                continue;
            }
            System.out.println("Could not resolve param '" + paramName + "'");
        }
        Assert.assertEquals((long)3L, (long)paramValues.size());
        Assert.assertEquals((Object)"Debug User", (Object)((QueryParamValue)paramValues.get(0)).getValue());
        Assert.assertEquals((Object)"debug@example.com", (Object)((QueryParamValue)paramValues.get(1)).getValue());
        Assert.assertEquals((Object)50, (Object)((QueryParamValue)paramValues.get(2)).getValue());
    }

    @Test
    public void testSelectExecutorFlow() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.executeUpdate("INSERT INTO test_users (name, email, age) VALUES ('Executor Test User', 'executor@example.com', 55)");
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try (ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Executor Test User'");){
            RowHandler rowHandler = (RowHandler)DmlOperations.getDefaultInsensitiveMapRowHandler().apply(this.dbConnection, Charset.defaultCharset());
            IteratorResultSetHandler resultSetHandler = new IteratorResultSetHandler(rowHandler, new StatementStreamingResultSetCloser(this.dbConnection), Charset.defaultCharset());
            QueryStatementFactory statementFactory = new QueryStatementFactory();
            QueryExecutor selectExecutor = (QueryExecutor)DmlOperations.getDefaultSelectExecutor().apply(statementFactory, resultSetHandler);
            QueryTemplate queryTemplate = new SimpleQueryTemplateParser().parse("SELECT * FROM test_users WHERE name = 'Executor Test User'");
            Query query = new Query(queryTemplate, new ArrayList());
            ResultSetIterator iterator = (ResultSetIterator)selectExecutor.execute(this.dbConnection, query);
            Assert.assertTrue((boolean)iterator.hasNext());
            Map row = iterator.next();
            System.out.println("DEBUG: Executor test result: " + row);
            System.out.println("DEBUG: Executor test keys: " + row.keySet());
            Assert.assertNotNull((Object)row);
            Assert.assertNotNull(row.get("NAME"));
            Assert.assertEquals((Object)"Executor Test User", row.get("NAME"));
            Assert.assertEquals((Object)"executor@example.com", row.get("EMAIL"));
            Assert.assertEquals((Object)55, row.get("AGE"));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testIteratorResultSetHandlerFlow() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.executeUpdate("INSERT INTO test_users (name, email, age) VALUES ('Iterator Test User', 'iterator@example.com', 50)");
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try (ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Iterator Test User'");){
            RowHandler rowHandler = (RowHandler)DmlOperations.getDefaultInsensitiveMapRowHandler().apply(this.dbConnection, Charset.defaultCharset());
            IteratorResultSetHandler resultSetHandler = new IteratorResultSetHandler(rowHandler, new StatementStreamingResultSetCloser(this.dbConnection), Charset.defaultCharset());
            ResultSetIterator iterator = resultSetHandler.processResultSet(this.dbConnection, rs);
            Assert.assertTrue((boolean)iterator.hasNext());
            Map row = iterator.next();
            System.out.println("DEBUG: Iterator test result: " + row);
            System.out.println("DEBUG: Iterator test keys: " + row.keySet());
            Assert.assertNotNull((Object)row);
            Assert.assertNotNull(row.get("NAME"));
            Assert.assertEquals((Object)"Iterator Test User", row.get("NAME"));
            Assert.assertEquals((Object)"iterator@example.com", row.get("EMAIL"));
            Assert.assertEquals((Object)50, row.get("AGE"));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testDmlOperationsFlow() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.executeUpdate("INSERT INTO test_users (name, email, age) VALUES ('Flow Test User', 'flow@example.com', 45)");
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try (ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Flow Test User'");){
            RowHandler rowHandler = (RowHandler)DmlOperations.getDefaultInsensitiveMapRowHandler().apply(this.dbConnection, Charset.defaultCharset());
            ResultSetIterator iterator = new ResultSetIterator(rs, rowHandler);
            Assert.assertTrue((boolean)iterator.hasNext());
            Map row = iterator.next();
            System.out.println("DEBUG: Flow test result: " + row);
            System.out.println("DEBUG: Flow test keys: " + row.keySet());
            Assert.assertNotNull((Object)row);
            Assert.assertNotNull(row.get("NAME"));
            Assert.assertEquals((Object)"Flow Test User", row.get("NAME"));
            Assert.assertEquals((Object)"flow@example.com", row.get("EMAIL"));
            Assert.assertEquals((Object)45, row.get("AGE"));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testResultSetState() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.executeUpdate("INSERT INTO test_users (name, email, age) VALUES ('State Test User', 'state@example.com', 40)");
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try (ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'State Test User'");){
            Assert.assertTrue((boolean)rs.next());
            RowHandler rowHandler = (RowHandler)DmlOperations.getDefaultInsensitiveMapRowHandler().apply(this.dbConnection, Charset.defaultCharset());
            Map row = rowHandler.process(rs);
            System.out.println("DEBUG: State test result: " + row);
            System.out.println("DEBUG: State test keys: " + row.keySet());
            Assert.assertTrue((rs.isAfterLast() || rs.isLast() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)rs.next());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testRowHandlerDirectly() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.executeUpdate("INSERT INTO test_users (name, email, age) VALUES ('RowHandler Test User', 'rowhandler@example.com', 35)");
        }
        stmt = this.jdbcConnection.createStatement();
        var2_2 = null;
        try (ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'RowHandler Test User'");){
            Assert.assertTrue((boolean)rs.next());
            RowHandler rowHandler = (RowHandler)DmlOperations.getDefaultInsensitiveMapRowHandler().apply(this.dbConnection, Charset.defaultCharset());
            Map row = rowHandler.process(rs);
            System.out.println("DEBUG: Direct row handler result: " + row);
            System.out.println("DEBUG: NAME from direct handler: " + row.get("name"));
            System.out.println("DEBUG: EMAIL from direct handler: " + row.get("email"));
            System.out.println("DEBUG: AGE from direct handler: " + row.get("age"));
            Assert.assertNotNull((Object)row);
            Assert.assertNotNull(row.get("name"));
            Assert.assertNotNull(row.get("email"));
            Assert.assertNotNull(row.get("age"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var2_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    @Test
    public void testSimpleSelectAllRecords() throws SQLException {
        try (Statement stmt = this.jdbcConnection.createStatement();){
            stmt.executeUpdate("INSERT INTO test_users (name, email, age) VALUES ('Simple Select User', 'simpleselect@example.com', 40)");
        }
        QueryDefinition selectDef = this.createSimpleSelectQueryDefinition();
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM test_users");){
            RowHandler rowHandler = (RowHandler)DmlOperations.getDefaultInsensitiveMapRowHandler().apply(this.dbConnection, Charset.defaultCharset());
            IteratorResultSetHandler resultSetHandler = new IteratorResultSetHandler(rowHandler, new StatementStreamingResultSetCloser(this.dbConnection), Charset.defaultCharset());
            ResultSetIterator iterator = resultSetHandler.processResultSet(this.dbConnection, rs);
            System.out.println("DEBUG: Processing records with direct approach");
            boolean found = false;
            while (iterator.hasNext()) {
                Map row = iterator.next();
                System.out.println("DEBUG: Record: " + row);
                System.out.println("DEBUG: Record NAME: " + row.get("NAME"));
                System.out.println("DEBUG: Record EMAIL: " + row.get("EMAIL"));
                System.out.println("DEBUG: Record AGE: " + row.get("AGE"));
                if (!"Simple Select User".equals(row.get("NAME"))) continue;
                found = true;
                Assert.assertEquals((Object)"simpleselect@example.com", row.get("EMAIL"));
                Assert.assertEquals((Object)40, row.get("AGE"));
            }
            Assert.assertTrue((String)"Should find the test record", (boolean)found);
        }
    }

    @Test
    public void testWorkingParameterizedInsert() throws SQLException {
        QueryDefinition queryDef = new QueryDefinition();
        queryDef.setSql("INSERT INTO test_users (name, email, age) VALUES (:name, :email, :age)");
        queryDef.addInputParameter("name", (Object)"Parameterized User");
        queryDef.addInputParameter("email", (Object)"parameterized@example.com");
        queryDef.addInputParameter("age", (Object)45);
        Assert.assertTrue((boolean)queryDef.getInputParameter("name").isPresent());
        Assert.assertEquals((Object)"Parameterized User", (Object)((Reference)queryDef.getInputParameter("name").get()).get());
        TestAutoGenerateKeysAttributes autoGenerateKeysAttributes = new TestAutoGenerateKeysAttributes(false);
        StatementResult result = this.dmlOperations.insert(queryDef, (AutoGenerateKeysAttributes)autoGenerateKeysAttributes, this.mockConnector, this.dbConnection, this.mockStreamingHelper);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getAffectedRows());
        try (Statement stmt = this.jdbcConnection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT * FROM test_users WHERE name = 'Parameterized User'");){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Parameterized User", (Object)rs.getString("name"));
            Assert.assertEquals((Object)"parameterized@example.com", (Object)rs.getString("email"));
            Assert.assertEquals((long)45L, (long)rs.getInt("age"));
        }
    }

    private static class TestAutoGenerateKeysAttributes
    implements AutoGenerateKeysAttributes {
        private final boolean autoGenerateKeys;

        public TestAutoGenerateKeysAttributes(boolean autoGenerateKeys) {
            this.autoGenerateKeys = autoGenerateKeys;
        }

        public boolean isAutoGenerateKeys() {
            return this.autoGenerateKeys;
        }

        public List<Integer> getAutoGeneratedKeysColumnIndexes() {
            return Collections.emptyList();
        }

        public List<String> getAutoGeneratedKeysColumnNames() {
            return Collections.emptyList();
        }
    }
}

