/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.parser.statement.detector;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.db.commons.internal.domain.query.QueryType;
import org.mule.db.commons.internal.parser.statement.detector.MergeStatementTypeDetector;

public class MergeStatementTypeDetectorTestCase {
    @Test
    public void expectedQueryTypeTest() {
        MergeStatementTypeDetector detector = new MergeStatementTypeDetector();
        MatcherAssert.assertThat((Object)detector.getType(), (Matcher)CoreMatchers.equalTo((Object)QueryType.MERGE));
    }

    @Test
    public void validMergeStatementTest() {
        MergeStatementTypeDetector detector = new MergeStatementTypeDetector();
        List<String> mergeStatements = Arrays.asList("MERGE INTO MYTABLE;", "merge into mytable", " merge into mytable", "Merge into myschema.myTable", "merge into myawesometable select * from othertable");
        for (String statement : mergeStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)true));
        }
    }

    @Test
    public void invalidMergeStatementTest() {
        MergeStatementTypeDetector detector = new MergeStatementTypeDetector();
        List<String> invalidStatements = Arrays.asList("SELECT DELETE FROM MY TABLE;", "SELECT FROM MYTABLE", "Insert into my table", "UPDATE delete from table");
        for (String statement : invalidStatements) {
            MatcherAssert.assertThat((Object)detector.isOfType(statement), (Matcher)CoreMatchers.equalTo((Object)false));
        }
    }
}

