/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.resultset.NullResultSetHandler;

@RunWith(value=MockitoJUnitRunner.class)
public class NullResultSetHandlerTestCase {
    @Mock
    private DbConnection mockDbConnection;
    @Mock
    private ResultSet mockResultSet;
    private NullResultSetHandler nullResultSetHandler;

    @Before
    public void setUp() {
        this.nullResultSetHandler = new NullResultSetHandler();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.nullResultSetHandler);
    }

    @Test
    public void testProcessResultSet() throws SQLException {
        ResultSet result = this.nullResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        Assert.assertSame((Object)this.mockResultSet, (Object)result);
    }

    @Test
    public void testProcessResultSetWithNullConnection() throws SQLException {
        ResultSet result = this.nullResultSetHandler.processResultSet(null, this.mockResultSet);
        Assert.assertSame((Object)this.mockResultSet, (Object)result);
    }

    @Test
    public void testProcessResultSetWithNullResultSet() throws SQLException {
        ResultSet result = this.nullResultSetHandler.processResultSet(this.mockDbConnection, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testProcessResultSetWithBothNull() throws SQLException {
        ResultSet result = this.nullResultSetHandler.processResultSet(null, null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testRequiresMultipleOpenedResults() {
        boolean result = this.nullResultSetHandler.requiresMultipleOpenedResults();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testProcessResultSetDoesNotCloseResultSet() throws SQLException {
        this.nullResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        ((ResultSet)Mockito.verify((Object)this.mockResultSet, (VerificationMode)Mockito.never())).close();
    }

    @Test
    public void testProcessResultSetDoesNotInteractWithConnection() throws SQLException {
        this.nullResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection, (VerificationMode)Mockito.never())).beginStreaming();
        ((DbConnection)Mockito.verify((Object)this.mockDbConnection, (VerificationMode)Mockito.never())).endStreaming();
    }

    @Test
    public void testProcessResultSetReturnsSameInstance() throws SQLException {
        ResultSet result1 = this.nullResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        ResultSet result2 = this.nullResultSetHandler.processResultSet(this.mockDbConnection, this.mockResultSet);
        Assert.assertSame((Object)this.mockResultSet, (Object)result1);
        Assert.assertSame((Object)this.mockResultSet, (Object)result2);
        Assert.assertSame((Object)result1, (Object)result2);
    }

    @Test
    public void testMultipleCallsReturnSameResult() throws SQLException {
        boolean result1 = this.nullResultSetHandler.requiresMultipleOpenedResults();
        boolean result2 = this.nullResultSetHandler.requiresMultipleOpenedResults();
        boolean result3 = this.nullResultSetHandler.requiresMultipleOpenedResults();
        Assert.assertFalse((boolean)result1);
        Assert.assertFalse((boolean)result2);
        Assert.assertFalse((boolean)result3);
    }
}

